/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.Sacrifice;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class SculkCatalyst
extends Building
implements NightSource,
RangeIndicator {
    public static final String buildingName = "Sculk Catalyst";
    public static final String structureName = "sculk_catalyst";
    public static final ResourceCost cost = ResourceCosts.SCULK_CATALYST;
    public static final int ESTIMATED_RANGE = 10;
    private static final Random random = new Random();
    public static final int nightRangeMin = 25;
    public static final int nightRangeMax = 50;
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();
    private static final int SCULK_SEARCH_RANGE = 30;
    private static final float HP_PER_SCULK = 0.5f;
    private static final float RANGE_PER_SCULK = 0.25f;
    public final ArrayList<BlockPos> sculkBps = new ArrayList();
    private final boolean didSculkFix = false;
    private final BlockPos sculkFixBp = null;
    private static final int destroys = 0;

    public SculkCatalyst(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(SculkCatalyst.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_220857_;
        this.icon = new ResourceLocation("minecraft", "textures/block/sculk_catalyst_side.png");
        this.foodCost = SculkCatalyst.cost.food;
        this.woodCost = SculkCatalyst.cost.wood;
        this.oreCost = SculkCatalyst.cost.ore;
        this.popSupply = SculkCatalyst.cost.population;
        this.buildTimeModifier = 2.5f;
        this.startingBlockTypes.add(Blocks.f_50734_);
        this.abilities.add(new Sacrifice(level));
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyQ));
        }
    }

    @Override
    public float getMagicDamageMult() {
        return 0.5f;
    }

    public int getUncappedNightRange() {
        if (this.isBuilt || this.isBuiltServerside) {
            return (int)((float)this.sculkBps.size() * 0.25f) + 25;
        }
        return 0;
    }

    @Override
    public int getNightRange() {
        if (this.isBuilt || this.isBuiltServerside) {
            return (int)Math.min(25.0f + (float)this.sculkBps.size() * 0.25f, 50.0f);
        }
        return 0;
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.updateBorderBps();
        this.updateSculkBps();
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.updateSculkBps();
        this.nightBorderBps.clear();
        this.nightBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getNightRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.nightBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return false;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            if (tickLevel.m_5776_()) {
                this.updateBorderBps();
            } else {
                this.updateSculkBps();
            }
        }
    }

    @Override
    public int getHealth() {
        return (int)((float)this.getBlocksPlaced() / 0.5f) - this.getHighestBlockCountReached() + (int)((float)this.sculkBps.size() * 0.5f);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    private void updateSculkBps() {
        this.sculkBps.clear();
        for (int x = this.centrePos.m_123341_() - 15; x < this.centrePos.m_123341_() + 15; ++x) {
            for (int z = this.centrePos.m_123343_() - 15; z < this.centrePos.m_123343_() + 15; ++z) {
                BlockPos bp;
                BlockState bs;
                BlockPos topBp = new BlockPos(x, this.maxCorner.m_123342_(), z);
                if (BuildingUtils.isPosInsideAnyBuilding(this.level.m_5776_(), topBp)) continue;
                int y = 0;
                while ((bs = this.level.m_8055_(bp = topBp.m_7918_(0, -(++y), 0))).m_60795_() && y < 10) {
                }
                if (!SculkCatalyst.isSculk(bs.m_60734_())) continue;
                this.sculkBps.add(bp);
            }
        }
        Collections.shuffle(this.sculkBps);
    }

    public static boolean isSculk(Block block) {
        return block == Blocks.f_220855_ || block == Blocks.f_220856_ || block == Blocks.f_220857_ || block == Blocks.f_152500_ || block == Blocks.f_220858_ || block == Blocks.f_276595_;
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        super.destroy(serverLevel);
        if (this.isBuilt) {
            this.updateSculkBps();
            for (int i = 0; this.sculkBps.size() > 0 && i < 10; ++i) {
                this.restoreRandomSculk(100);
            }
        }
    }

    private int restoreRandomSculk(int amount) {
        if (this.getLevel().m_5776_()) {
            return 0;
        }
        int restoredSculk = 0;
        this.updateSculkBps();
        block0: for (int i = 0; i < amount; ++i) {
            if (i >= this.sculkBps.size()) {
                return restoredSculk;
            }
            BlockPos bp = this.sculkBps.get(i);
            BlockState bs = this.level.m_8055_(bp);
            if (bs.m_60734_() == Blocks.f_220855_) {
                for (BlockPos bpAdj : List.of(bp.m_7495_(), bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
                    BlockState bsAdj = this.level.m_8055_(bpAdj);
                    if (bsAdj.m_60795_() || SculkCatalyst.isSculk(bsAdj.m_60734_())) continue;
                    this.level.m_46597_(bp, bsAdj);
                    ++restoredSculk;
                    continue block0;
                }
                continue;
            }
            if (bs.m_60734_() != Blocks.f_220856_ && bs.m_60734_() != Blocks.f_152500_) continue;
            this.level.m_46961_(bp, false);
            ++restoredSculk;
        }
        return restoredSculk;
    }

    @Override
    public void destroyRandomBlocks(int amount) {
        if (this.getLevel().m_5776_() || amount <= 0) {
            return;
        }
        int restoredSculk = this.restoreRandomSculk((int)((float)amount / 0.5f));
        if (restoredSculk < amount) {
            super.destroyRandomBlocks(amount - restoredSculk);
        }
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/sculk_catalyst_side.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == SculkCatalyst.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Mausoleum") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(SculkCatalyst.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.sculk_catalyst", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.sculk_catalyst.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.sculk_catalyst.tooltip2", (Object[])new Object[]{25}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.sculk_catalyst.tooltip3", (Object[])new Object[]{50}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.sculk_catalyst.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

