/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class SpruceBridge
extends AbstractBridge {
    public static final String buildingName = "Spruce Bridge";
    public static final String structureNameOrthogonal = "bridge_spruce_orthogonal";
    public static final String structureNameDiagonal = "bridge_spruce_diagonal";
    public static final ResourceCost cost = ResourceCosts.SPRUCE_BRIDGE;

    public SpruceBridge(Level level, BlockPos originPos, Rotation rotation, String ownerName, boolean diagonal) {
        super(level, originPos, rotation, ownerName, diagonal, SpruceBridge.getCulledBlocks(BuildingUtils.getAbsoluteBlockData(SpruceBridge.getRelativeBlockData((LevelAccessor)level, diagonal), (LevelAccessor)level, originPos, rotation), level));
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50483_;
        this.icon = new ResourceLocation("reignofnether", "textures/icons/blocks/spruce_fence.png");
        this.foodCost = SpruceBridge.cost.food;
        this.woodCost = SpruceBridge.cost.wood;
        this.oreCost = SpruceBridge.cost.ore;
        this.popSupply = SpruceBridge.cost.population;
        this.buildTimeModifier = 1.0f;
        this.startingBlockTypes.add(Blocks.f_50000_);
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level, boolean diagonal) {
        return BuildingBlockData.getBuildingBlocks(diagonal ? structureNameDiagonal : structureNameOrthogonal, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        Minecraft MC = Minecraft.m_91087_();
        return new AbilityButton(buildingName, new ResourceLocation("reignofnether", "textures/icons/blocks/spruce_fence.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == SpruceBridge.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Town Centre") || BuildingClientEvents.hasFinishedBuilding("Mausoleum") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(SpruceBridge.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spruce_bridge", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spruce_bridge.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spruce_bridge.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spruce_bridge.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.spruce_bridge.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

