/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.units.monsters.WardenProd;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Stronghold
extends ProductionBuilding
implements GarrisonableBuilding,
NightSource,
RangeIndicator {
    public static final String buildingName = "Stronghold";
    public static final String structureName = "stronghold";
    public static final ResourceCost cost = ResourceCosts.STRONGHOLD;
    public static final int nightRange = 60;
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();
    private static final int MAX_OCCUPANTS = 7;

    public Stronghold(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Stronghold.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_220863_;
        this.icon = new ResourceLocation("minecraft", "textures/block/reinforced_deepslate_side.png");
        this.foodCost = Stronghold.cost.food;
        this.woodCost = Stronghold.cost.wood;
        this.oreCost = Stronghold.cost.ore;
        this.popSupply = Stronghold.cost.population;
        this.buildTimeModifier = 0.5f;
        this.startingBlockTypes.add(Blocks.f_50734_);
        this.startingBlockTypes.add(Blocks.f_152561_);
        this.startingBlockTypes.add(Blocks.f_50711_);
        this.startingBlockTypes.add(Blocks.f_152550_);
        this.updateButtons();
        this.updateBorderBps();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = List.of(WardenProd.getStartButton(this, Keybindings.keyQ));
        }
    }

    @Override
    public int getNightRange() {
        return this.isBuilt || this.isBuiltServerside ? 60 : 0;
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.updateBorderBps();
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.nightBorderBps.clear();
        this.nightBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getNightRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.nightBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return false;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
    }

    @Override
    public int getAttackRange() {
        return 30;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 15;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 13 && relativeBp.m_123342_() != 14;
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/reinforced_deepslate_side.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Stronghold.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Laboratory") && BuildingClientEvents.hasFinishedBuilding("Spider Lair") && BuildingClientEvents.hasFinishedBuilding("Dungeon") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Stronghold.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip2", (Object[])new Object[]{7}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip3", (Object[])new Object[]{60}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        return this.originPos.m_121955_((Vec3i)this.getExitPosition());
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 14, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 14, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 14, -5);
        }
        return new BlockPos(5, 14, -5);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 2, 6);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 2, 6);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 2, -6);
        }
        return new BlockPos(5, 2, -6);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 7;
    }
}

