/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.BeaconHaste;
import com.solegendary.reignofnether.ability.abilities.BeaconRegeneration;
import com.solegendary.reignofnether.ability.abilities.BeaconResistance;
import com.solegendary.reignofnether.ability.abilities.BeaconStrength;
import com.solegendary.reignofnether.ability.abilities.BeaconWealth;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.building.buildings.neutral.CapturableBeacon;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel1;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel2;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel3;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel4;
import com.solegendary.reignofnether.research.researchItems.ResearchBeaconLevel5;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.packets.BeaconSyncClientboundPacket;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3d;

public class Beacon
extends ProductionBuilding
implements RangeIndicator {
    public static final String buildingName = "Beacon";
    public static final String structureName = "beacon_t0";
    public static final String structureNameT1 = "beacon_t1";
    public static final String structureNameT2 = "beacon_t2";
    public static final String structureNameT3 = "beacon_t3";
    public static final String structureNameT4 = "beacon_t4";
    public static final String structureNameT5 = "beacon_t5";
    public static final ResourceCost cost = ResourceCosts.BEACON;
    public static final int MAX_UPGRADE_LEVEL = 5;
    private MobEffect auraEffect = null;
    private boolean beaconActive = false;
    public BlockPos beaconPos;
    public static final int RANGE = 40;
    private final Set<BlockPos> borderBps = new HashSet<BlockPos>();

    public static int getTicksToWin(Level level) {
        if (level.f_46443_) {
            return (int)(GameruleClient.beaconWinMinutes * 20.0 * 60.0);
        }
        if (level.m_7654_() != null) {
            return ((GameRules.IntegerValue)level.m_7654_().m_129900_().m_46170_(GameRuleRegistrar.BEACON_WIN_MINUTES)).m_46288_() * 20 * 60;
        }
        return 24000;
    }

    public boolean isBeaconActive() {
        return this.auraEffect != null && this.beaconActive;
    }

    public Beacon(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Beacon.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50273_;
        this.icon = new ResourceLocation("minecraft", "textures/item/nether_star.png");
        this.foodCost = Beacon.cost.food;
        this.woodCost = Beacon.cost.wood;
        this.oreCost = Beacon.cost.ore;
        this.popSupply = Beacon.cost.population;
        this.buildTimeModifier = 2.0f;
        this.capturable = false;
        this.invulnerable = false;
        this.shouldDestroyOnReset = true;
        this.startingBlockTypes.add(Blocks.f_50225_);
        this.explodeChance = 0.2f;
        this.abilities.add(new BeaconWealth(this));
        this.abilities.add(new BeaconHaste(this));
        this.abilities.add(new BeaconRegeneration(this));
        this.abilities.add(new BeaconResistance(this));
        this.abilities.add(new BeaconStrength(this));
        this.updateButtons();
        for (BuildingBlock bb : this.blocks) {
            if (bb.getBlockState().m_60734_() != Blocks.f_50273_) continue;
            this.beaconPos = bb.getBlockPos();
        }
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ResearchBeaconLevel1.getStartButton(this, null), ResearchBeaconLevel2.getStartButton(this, null), ResearchBeaconLevel3.getStartButton(this, null), ResearchBeaconLevel4.getStartButton(this, null), ResearchBeaconLevel5.getStartButton(this, null));
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyQ));
            this.abilityButtons.add(((Ability)this.abilities.get(1)).getButton(Keybindings.keyW));
            this.abilityButtons.add(((Ability)this.abilities.get(2)).getButton(Keybindings.keyE));
            this.abilityButtons.add(((Ability)this.abilities.get(3)).getButton(Keybindings.keyR));
            this.abilityButtons.add(((Ability)this.abilities.get(4)).getButton(Keybindings.keyT));
        }
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        super.destroy(serverLevel);
        if (!(this instanceof CapturableBeacon) && !this.ownerName.isBlank()) {
            this.sendWarning("destroy_warning");
        }
    }

    @Override
    public String getUpgradedName() {
        if (this.getAuraEffect() == MobEffects.f_19621_) {
            return this.name + " (" + I18n.m_118938_((String)"ability.reignofnether.beacon_aura.wealth", (Object[])new Object[0]) + ")";
        }
        if (this.getAuraEffect() == MobEffects.f_19598_) {
            return this.name + " (" + I18n.m_118938_((String)"ability.reignofnether.beacon_aura.haste", (Object[])new Object[0]) + ")";
        }
        if (this.getAuraEffect() == MobEffects.f_19605_) {
            return this.name + " (" + I18n.m_118938_((String)"ability.reignofnether.beacon_aura.regeneration", (Object[])new Object[0]) + ")";
        }
        if (this.getAuraEffect() == MobEffects.f_19600_) {
            return this.name + " (" + I18n.m_118938_((String)"ability.reignofnether.beacon_aura.strength", (Object[])new Object[0]) + ")";
        }
        if (this.getAuraEffect() == MobEffects.f_19606_) {
            return this.name + " (" + I18n.m_118938_((String)"ability.reignofnether.beacon_aura.resistance", (Object[])new Object[0]) + ")";
        }
        return this.name;
    }

    private Block getBeaconBlock() {
        return this.level.m_8055_(this.beaconPos).m_60734_();
    }

    private BlockEntity getBeaconBlockEntity() {
        return this.level.m_7702_(this.beaconPos);
    }

    public MobEffect getAuraEffect() {
        if (this.getBeaconBlockEntity() != null) {
            return this.auraEffect;
        }
        return null;
    }

    public static MobEffect getMobEffectForAction(UnitAction action) {
        return switch (action) {
            case UnitAction.BEACON_HASTE -> MobEffects.f_19598_;
            case UnitAction.BEACON_REGENERATION -> MobEffects.f_19605_;
            case UnitAction.BEACON_RESISTANCE -> MobEffects.f_19606_;
            case UnitAction.BEACON_WEALTH -> MobEffects.f_19621_;
            case UnitAction.BEACON_STRENGTH -> MobEffects.f_19600_;
            default -> null;
        };
    }

    public static UnitAction getActionForMobEffect(MobEffect effect) {
        if (effect == MobEffects.f_19598_) {
            return UnitAction.BEACON_HASTE;
        }
        if (effect == MobEffects.f_19605_) {
            return UnitAction.BEACON_REGENERATION;
        }
        if (effect == MobEffects.f_19606_) {
            return UnitAction.BEACON_RESISTANCE;
        }
        if (effect == MobEffects.f_19621_) {
            return UnitAction.BEACON_WEALTH;
        }
        if (effect == MobEffects.f_19600_) {
            return UnitAction.BEACON_STRENGTH;
        }
        return UnitAction.NONE;
    }

    public void activate(MobEffect effect) {
        this.beaconActive = true;
        this.auraEffect = effect;
        if (!this.level.m_5776_()) {
            SoundClientboundPacket.playSoundAtPos(SoundAction.BEACON_ACTIVATE, this.beaconPos);
            BeaconSyncClientboundPacket.syncBeacon(Beacon.getActionForMobEffect(effect), this.originPos, true);
        }
    }

    public void deactivate() {
        this.beaconActive = false;
        this.auraEffect = null;
        if (!this.level.m_5776_()) {
            SoundClientboundPacket.playSoundAtPos(SoundAction.BEACON_DEACTIVATE, this.beaconPos);
            BeaconSyncClientboundPacket.syncBeacon(UnitAction.NONE, this.originPos, false);
        }
    }

    public void setAuraEffect(MobEffect effect) {
        if (this.isBeaconActive()) {
            this.deactivate();
            CompletableFuture.delayedExecutor(2500L, TimeUnit.MILLISECONDS).execute(() -> this.activate(effect));
        } else {
            this.activate(effect);
        }
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
        if (this.isBeaconActive() && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 20L == 0L && !this.level.m_5776_()) {
            List<LivingEntity> nearbyEntities = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.centrePos.m_123342_(), (double)this.centrePos.m_123343_()), 40.0f, LivingEntity.class, this.level);
            for (LivingEntity le : nearbyEntities) {
                Player player;
                boolean isFriendlyPlayer;
                Unit unit;
                boolean isOwnedOrFriendlyUnit = le instanceof Unit && ((unit = (Unit)le).getOwnerName().equals(this.ownerName) || AlliancesServerEvents.isAllied(this.ownerName, unit.getOwnerName()));
                boolean bl = isFriendlyPlayer = le instanceof Player && !(player = (Player)le).m_7500_() && !player.m_5833_() && (player.m_7755_().getString().equals(this.ownerName) || AlliancesServerEvents.isAllied(player.m_7755_().getString(), this.ownerName));
                if (!isOwnedOrFriendlyUnit && !isFriendlyPlayer || !isFriendlyPlayer && this.auraEffect == MobEffects.f_19621_ || this.getBeaconBlockEntity() == null) continue;
                if (this.auraEffect != MobEffects.f_19605_) {
                    if (!(le instanceof WorkerUnit) && this.auraEffect == MobEffects.f_19598_) continue;
                    le.m_7292_(new MobEffectInstance(this.auraEffect, 25, 0));
                    continue;
                }
                if (this.tickAgeAfterBuilt % 80L != 0L) continue;
                le.m_7292_(new MobEffectInstance(this.auraEffect, 60, 0));
            }
            if (this.tickAgeAfterBuilt % 20L == 0L && this.getAuraEffect() == MobEffects.f_19621_ && this.isBeaconActive()) {
                ResourcesServerEvents.addSubtractResources(new Resources(this.ownerName, 1, 1, 1));
            }
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.sendWarning("completed_warning");
    }

    public void sendWarning(String msg) {
        if (!this.level.f_46443_) {
            PlayerServerEvents.sendMessageToAllPlayersNoNewlines("");
            Beacon beacon = BuildingUtils.getBeacon(this.level.f_46443_);
            if (beacon != null && msg.equals("upgraded_warning")) {
                String upgradeName = "";
                if (beacon.getUpgradeLevel() == 1) {
                    upgradeName = "Iron";
                } else if (beacon.getUpgradeLevel() == 2) {
                    upgradeName = "Gold";
                } else if (beacon.getUpgradeLevel() == 3) {
                    upgradeName = "Emerald";
                } else if (beacon.getUpgradeLevel() == 4) {
                    upgradeName = "Diamond";
                } else if (beacon.getUpgradeLevel() == 5) {
                    upgradeName = "Netherite";
                }
                PlayerServerEvents.sendMessageToAllPlayersNoNewlines("buildings.neutral.reignofnether.beacon.upgrade_warning", true, this.ownerName, upgradeName, beacon.getUpgradeLevel(), 5);
            } else {
                PlayerServerEvents.sendMessageToAllPlayersNoNewlines("buildings.neutral.reignofnether.beacon." + msg, true, this.ownerName);
            }
            if (beacon != null && beacon.getUpgradeLevel() >= 5 && !msg.equals("destroy_warning")) {
                PlayerServerEvents.sendMessageToAllPlayersNoNewlines("buildings.neutral.reignofnether.beacon.time_to_win", false, this.ownerName, PlayerServerEvents.getBeaconWinTime(this.ownerName));
            }
            PlayerServerEvents.sendMessageToAllPlayersNoNewlines("");
            if (SurvivalServerEvents.isEnabled() && !msg.equals("destroy_warning")) {
                SoundClientboundPacket.playSoundForAllPlayers(SoundAction.ALLY);
            } else {
                SoundClientboundPacket.playSoundForAllPlayers(SoundAction.ENEMY);
            }
        }
    }

    private int getBorderRange() {
        return this.isBuilt && this.getUpgradeLevel() > 0 ? 40 : 0;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.borderBps.clear();
        this.borderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getBorderRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.borderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return true;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        BlockPos worldBp = relativeBp.m_121955_((Vec3i)this.originPos);
        Block block = this.getLevel().m_8055_(worldBp).m_60734_();
        Block blockAbove = this.getLevel().m_8055_(worldBp).m_60734_();
        return block != Blocks.f_50273_ && blockAbove != Blocks.f_50273_;
    }

    public void changeStructure(int structureLevel) {
        String newStructureName = switch (structureLevel) {
            case 1 -> structureNameT1;
            case 2 -> structureNameT2;
            case 3 -> structureNameT3;
            case 4 -> structureNameT4;
            case 5 -> structureNameT5;
            default -> structureName;
        };
        ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocks(newStructureName, (LevelAccessor)this.getLevel());
        this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
        super.refreshBlocks();
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/item/nether_star.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Beacon.class, () -> TutorialClientEvents.isEnabled() || !GameruleClient.allowBeacons, () -> BuildingClientEvents.getBuildings().stream().filter(b -> b instanceof Beacon).toList().isEmpty() && (BuildingClientEvents.hasFinishedBuilding("Castle") || BuildingClientEvents.hasFinishedBuilding("Stronghold") || BuildingClientEvents.hasFinishedBuilding("Fortress") || ResearchClient.hasCheat("modifythephasevariance")), () -> BuildingClientEvents.setBuildingToPlace(Beacon.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public int getUpgradeLevel() {
        for (BuildingBlock block : this.blocks) {
            if (block.getBlockState().m_60734_() == Blocks.f_50721_) {
                return 5;
            }
            if (block.getBlockState().m_60734_() == Blocks.f_50090_) {
                return 4;
            }
            if (block.getBlockState().m_60734_() == Blocks.f_50268_) {
                return 3;
            }
            if (block.getBlockState().m_60734_() == Blocks.f_50074_) {
                return 2;
            }
            if (block.getBlockState().m_60734_() != Blocks.f_50075_) continue;
            return 1;
        }
        return 0;
    }
}

