/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class CapturableBeacon
extends Beacon {
    public static final String buildingName = "The Beacon";
    public static final String structureName = "beacon_t5";
    public static final ResourceCost cost = ResourceCost.Building(0, 0, 0, 0);

    public CapturableBeacon(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName);
        this.blocks = BuildingUtils.getAbsoluteBlockData(CapturableBeacon.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50273_;
        this.icon = new ResourceLocation("minecraft", "textures/item/nether_star.png");
        this.foodCost = CapturableBeacon.cost.food;
        this.woodCost = CapturableBeacon.cost.wood;
        this.oreCost = CapturableBeacon.cost.ore;
        this.popSupply = CapturableBeacon.cost.population;
        this.buildTimeModifier = 1.0f;
        this.capturable = true;
        this.invulnerable = true;
        this.shouldDestroyOnReset = false;
        this.selfBuilding = true;
        this.startingBlockTypes.add(Blocks.f_50721_);
        this.explodeChance = 0.2f;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/item/nether_star.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == CapturableBeacon.class, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.getBuildings().stream().filter(b -> b instanceof CapturableBeacon).toList().isEmpty(), () -> BuildingClientEvents.setBuildingToPlace(CapturableBeacon.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.upgraded_beacon", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.upgraded_beacon.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.upgraded_beacon.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.upgraded_beacon.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

