/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.unit.units.neutral.EndermanProd;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class EndPortal
extends ProductionBuilding {
    public static final String buildingName = "End Portal";
    public static final String structureName = "end_portal";
    public static final ResourceCost cost = ResourceCost.Building(0, 0, 0, 0);

    public EndPortal(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(EndPortal.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50258_;
        this.icon = new ResourceLocation("minecraft", "textures/block/end_portal_frame_top.png");
        this.foodCost = EndPortal.cost.food;
        this.woodCost = EndPortal.cost.wood;
        this.oreCost = EndPortal.cost.ore;
        this.popSupply = EndPortal.cost.population;
        this.selfBuilding = true;
        this.capturable = true;
        this.invulnerable = true;
        this.shouldDestroyOnReset = false;
        this.startingBlockTypes.add(Blocks.f_50382_);
        this.explodeChance = 0.2f;
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(EndermanProd.getStartButton(this, Keybindings.keyQ));
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        if (!this.level.m_5776_()) {
            this.level.m_46597_(this.centrePos.m_7494_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122012_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122019_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122029_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122024_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122012_().m_122029_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122012_().m_122024_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122019_().m_122029_(), Blocks.f_50257_.m_49966_());
            this.level.m_46597_(this.centrePos.m_7494_().m_122019_().m_122024_(), Blocks.f_50257_.m_49966_());
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/end_portal_frame_top.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == EndPortal.class, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(EndPortal.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.end_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.end_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.end_portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

