/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import org.joml.Vector3d;

public class HealingFountain
extends Building
implements RangeIndicator {
    public static final String buildingName = "Healing Fountain";
    public static final String structureName = "healing_fountain";
    public static final ResourceCost cost = ResourceCost.Building(0, 0, 0, 0);
    private final ArrayList<BuildingBlock> waterBlocks;
    public static final int RANGE = 20;
    private final Set<BlockPos> borderBps = new HashSet<BlockPos>();

    public HealingFountain(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(HealingFountain.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50357_;
        this.icon = new ResourceLocation("minecraft", "textures/block/rose_bush_bottom.png");
        this.foodCost = HealingFountain.cost.food;
        this.woodCost = HealingFountain.cost.wood;
        this.oreCost = HealingFountain.cost.ore;
        this.popSupply = HealingFountain.cost.population;
        this.buildTimeModifier = 0.8f;
        this.startingBlockTypes.add(Blocks.f_50387_);
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.startingBlockTypes.add(Blocks.f_50440_);
        this.startingBlockTypes.add(Blocks.f_50217_);
        this.selfBuilding = true;
        this.capturable = false;
        this.invulnerable = true;
        this.shouldDestroyOnReset = false;
        List<BuildingBlock> wbs = this.blocks.stream().filter(b -> b.getBlockPos().m_123342_() < this.centrePos.m_123342_() && b.getBlockState().m_60734_() == Blocks.f_49990_).toList();
        this.waterBlocks = new ArrayList<BuildingBlock>(wbs);
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        List<LivingEntity> nearbyEntities = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.centrePos.m_123342_(), (double)this.centrePos.m_123343_()), 20.0f, LivingEntity.class, this.level);
        for (LivingEntity le : nearbyEntities) {
            if (!this.isBuilt || this.tickAgeAfterBuilt % 20L != 0L) continue;
            le.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 20, 0));
            le.m_5634_(Math.min(1.0f, le.m_21233_() / 100.0f));
        }
        if (!this.waterBlocks.isEmpty() && this.isBuilt) {
            Collections.shuffle(this.waterBlocks);
            int col = 16262179;
            BlockPos bp = this.waterBlocks.get(0).getBlockPos();
            double d0 = (double)(col >> 16 & 0xFF) / 255.0;
            double d1 = (double)(col >> 8 & 0xFF) / 255.0;
            double d2 = (double)(col >> 0 & 0xFF) / 255.0;
            this.level.m_7106_((ParticleOptions)ParticleTypes.f_123811_, (double)bp.m_123341_(), (double)(bp.m_123342_() + 1), (double)bp.m_123343_(), d0, d1, d2);
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/rose_bush_bottom.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == HealingFountain.class, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(HealingFountain.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.healing_fountain", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.healing_fountain.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.healing_fountain.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.borderBps.clear();
        this.borderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, 18, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.borderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return true;
    }
}

