/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class NeutralTransportPortal
extends Portal {
    public static final String buildingName = "Neutral Transport Portal";
    public static final String structureName = "neutral_transport_portal";
    public static final ResourceCost cost = ResourceCost.Building(0, 0, 0, 0);
    public BlockPos destination;
    public NetherZone netherConversionZone = null;

    public NeutralTransportPortal(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, true);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50537_;
        this.icon = new ResourceLocation("minecraft", "textures/block/blue_glazed_terracotta.png");
        this.startingBlockTypes.add(Blocks.f_50060_);
        this.portalType = Portal.PortalType.TRANSPORT;
        this.invulnerable = true;
        this.shouldDestroyOnReset = false;
        this.selfBuilding = true;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    @Override
    public double getMaxRange() {
        return 0.0;
    }

    @Override
    public double getStartingRange() {
        return 0.0;
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/blue_glazed_terracotta.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == NeutralTransportPortal.class, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(NeutralTransportPortal.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.neutral_transport_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.neutral_transport_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.neutral_transport_portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

