/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchCubeMagma;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class BasaltSprings
extends ProductionBuilding {
    public static final String buildingName = "Basalt Springs";
    public static final String structureName = "basalt_springs";
    public static final ResourceCost cost = ResourceCosts.BASALT_SPRINGS;

    public BasaltSprings(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(BasaltSprings.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50138_;
        this.icon = new ResourceLocation("minecraft", "textures/block/polished_basalt_top.png");
        this.canSetRallyPoint = false;
        this.foodCost = BasaltSprings.cost.food;
        this.woodCost = BasaltSprings.cost.wood;
        this.oreCost = BasaltSprings.cost.ore;
        this.popSupply = BasaltSprings.cost.population;
        this.startingBlockTypes.add(Blocks.f_50137_);
        this.startingBlockTypes.add(Blocks.f_50734_);
        this.explodeChance = 0.2f;
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ResearchCubeMagma.getStartButton(this, Keybindings.keyQ));
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/polished_basalt_top.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == BasaltSprings.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Bastion") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(BasaltSprings.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.basalt_springs", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.basalt_springs.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.basalt_springs.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.basalt_springs.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

