/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchBruteShields;
import com.solegendary.reignofnether.research.researchItems.ResearchHeavyTridents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Bastion
extends ProductionBuilding
implements GarrisonableBuilding {
    public static final String buildingName = "Bastion";
    public static final String structureName = "bastion";
    public static final ResourceCost cost = ResourceCosts.BASTION;
    private static final int MAX_OCCUPANTS = 4;

    public Bastion(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Bastion.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50737_;
        this.icon = new ResourceLocation("minecraft", "textures/block/chiseled_polished_blackstone.png");
        this.canSetRallyPoint = false;
        this.foodCost = Bastion.cost.food;
        this.woodCost = Bastion.cost.wood;
        this.oreCost = Bastion.cost.ore;
        this.popSupply = Bastion.cost.population;
        this.buildTimeModifier = 0.72f;
        this.startingBlockTypes.add(Blocks.f_50734_);
        this.startingBlockTypes.add(Blocks.f_50735_);
        this.startingBlockTypes.add(Blocks.f_50736_);
        this.explodeChance = 0.2f;
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ResearchBruteShields.getStartButton(this, Keybindings.keyQ), ResearchHeavyTridents.getStartButton(this, Keybindings.keyW));
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public int getAttackRange() {
        return 24;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 10;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 10 && relativeBp.m_123342_() != 11;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/chiseled_polished_blackstone.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Bastion.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Basic Portal") || BuildingClientEvents.hasFinishedBuilding("Civilian Portal") || BuildingClientEvents.hasFinishedBuilding("Military Portal") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Bastion.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.bastion", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.bastion.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.bastion.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.bastion.tooltip3", (Object[])new Object[]{4}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.bastion.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(2, 11, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-2, 11, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-2, 11, -2);
        }
        return new BlockPos(2, 11, -2);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(2, 1, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-2, 1, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-2, 1, -2);
        }
        return new BlockPos(2, 1, -2);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 4;
    }
}

