/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.units.piglins.GruntProd;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class CentralPortal
extends ProductionBuilding
implements NetherConvertingBuilding {
    public static final String buildingName = "Central Portal";
    public static final String structureName = "central_portal";
    public static final ResourceCost cost = ResourceCosts.CENTRAL_PORTAL;
    public NetherZone netherConversionZone = null;

    @Override
    public double getMaxRange() {
        return 30.0;
    }

    @Override
    public double getStartingRange() {
        return 6.0;
    }

    @Override
    public NetherZone getZone() {
        return this.netherConversionZone;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (!this.getLevel().m_5776_() && this.getBlocksPlaced() >= this.getBlocksTotal()) {
            BlockPos bp = this.rotation == Rotation.CLOCKWISE_90 || this.rotation == Rotation.COUNTERCLOCKWISE_90 ? this.centrePos.m_7918_(0, -1, 0) : this.centrePos.m_7918_(-1, 0, 0);
            if (this.getLevel().m_8055_(bp).m_60795_()) {
                this.getLevel().m_46597_(bp, Blocks.f_50083_.m_49966_());
            }
        }
    }

    public CentralPortal(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(CentralPortal.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), true);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50080_;
        this.icon = new ResourceLocation("minecraft", "textures/block/obsidian.png");
        this.foodCost = CentralPortal.cost.food;
        this.woodCost = CentralPortal.cost.wood;
        this.oreCost = CentralPortal.cost.ore;
        this.popSupply = CentralPortal.cost.population;
        this.buildTimeModifier = 0.32f;
        this.canAcceptResources = true;
        this.startingBlockTypes.add(Blocks.f_50197_);
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(GruntProd.getStartButton(this, Keybindings.keyQ));
        }
    }

    @Override
    public void setNetherZone(NetherZone nz) {
        if (this.netherConversionZone == null) {
            this.netherConversionZone = nz;
            if (!this.level.m_5776_()) {
                BuildingServerEvents.netherZones.add(this.netherConversionZone);
                BuildingServerEvents.saveNetherZones((ServerLevel)this.level);
            }
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        if (this.getMaxRange() > 0.0) {
            this.setNetherZone(new NetherZone(this.centrePos.m_7918_(0, -6, 0), this.getMaxRange(), this.getStartingRange()));
        }
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        BlockPos worldBp = relativeBp.m_121955_((Vec3i)this.originPos);
        Block block = this.getLevel().m_8055_(worldBp).m_60734_();
        return block != Blocks.f_50080_ && block != Blocks.f_50142_;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/obsidian.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == CentralPortal.class, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(CentralPortal.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.central_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPop(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.central_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        return super.getIndoorSpawnPoint(level).m_7918_(0, -5, 0);
    }
}

