/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchBlazeFirewall;
import com.solegendary.reignofnether.research.researchItems.ResearchFireResistance;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class FlameSanctuary
extends ProductionBuilding {
    public static final String buildingName = "Flame Sanctuary";
    public static final String structureName = "flame_sanctuary";
    public static final ResourceCost cost = ResourceCosts.FLAME_SANCTUARY;

    public FlameSanctuary(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(FlameSanctuary.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50450_;
        this.icon = new ResourceLocation("reignofnether", "textures/icons/blocks/magma.png");
        this.canSetRallyPoint = false;
        this.foodCost = FlameSanctuary.cost.food;
        this.woodCost = FlameSanctuary.cost.wood;
        this.oreCost = FlameSanctuary.cost.ore;
        this.popSupply = FlameSanctuary.cost.population;
        this.startingBlockTypes.add(Blocks.f_50640_);
        this.explodeChance = 0.2f;
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ResearchBlazeFirewall.getStartButton(this, Keybindings.keyQ), ResearchFireResistance.getStartButton(this, Keybindings.keyW));
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("reignofnether", "textures/icons/blocks/magma.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == FlameSanctuary.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Hoglin Stables") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(FlameSanctuary.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.flame_sanctuary", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.flame_sanctuary.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.flame_sanctuary.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.flame_sanctuary.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public void onBlockBuilt(BlockPos bp, BlockState bs) {
        BlockEntity be;
        if (!this.getLevel().m_5776_() && bs.m_155947_() && (be = this.getLevel().m_7702_(bp)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity sbe = (SpawnerBlockEntity)be;
            sbe.m_59801_().m_253197_(EntityType.f_20551_, this.getLevel(), this.getLevel().f_46441_, bp);
        }
    }
}

