/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchAdvancedPortals;
import com.solegendary.reignofnether.research.researchItems.ResearchBloodlust;
import com.solegendary.reignofnether.research.researchItems.ResearchSoulFireballs;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Fortress
extends ProductionBuilding
implements GarrisonableBuilding {
    public static final String buildingName = "Fortress";
    public static final String structureName = "fortress";
    public static final ResourceCost cost = ResourceCosts.FORTRESS;
    private static final int MAX_OCCUPANTS = 7;

    public Fortress(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Fortress.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50712_;
        this.icon = new ResourceLocation("minecraft", "textures/block/chiseled_nether_bricks.png");
        this.foodCost = Fortress.cost.food;
        this.woodCost = Fortress.cost.wood;
        this.oreCost = Fortress.cost.ore;
        this.popSupply = Fortress.cost.population;
        this.buildTimeModifier = 0.5f;
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50134_);
        this.startingBlockTypes.add(Blocks.f_50197_);
        this.startingBlockTypes.add(Blocks.f_50138_);
        this.startingBlockTypes.add(Blocks.f_50199_);
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(ResearchAdvancedPortals.getStartButton(this, Keybindings.keyQ), ResearchBloodlust.getStartButton(this, Keybindings.keyW), ResearchSoulFireballs.getStartButton(this, Keybindings.keyE));
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public int getAttackRange() {
        return 30;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 15;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 16 && relativeBp.m_123342_() != 17;
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/chiseled_nether_bricks.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Fortress.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Flame Sanctuary") && BuildingClientEvents.hasFinishedBuilding("Wither Shrine") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Fortress.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress.tooltip2", (Object[])new Object[]{7}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.fortress.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        return this.originPos.m_121955_((Vec3i)this.getExitPosition());
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 17, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 17, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 17, -5);
        }
        return new BlockPos(5, 17, -5);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 1, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 1, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 1, -5);
        }
        return new BlockPos(5, 1, -5);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 7;
    }
}

