/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.piglins;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.ConnectPortal;
import com.solegendary.reignofnether.ability.abilities.DisconnectPortal;
import com.solegendary.reignofnether.ability.abilities.GotoPortal;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchPortalForCivilian;
import com.solegendary.reignofnether.research.researchItems.ResearchPortalForMilitary;
import com.solegendary.reignofnether.research.researchItems.ResearchPortalForTransport;
import com.solegendary.reignofnether.research.researchItems.ResearchResourceCapacity;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.units.piglins.BlazeProd;
import com.solegendary.reignofnether.unit.units.piglins.BruteProd;
import com.solegendary.reignofnether.unit.units.piglins.GhastProd;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterProd;
import com.solegendary.reignofnether.unit.units.piglins.HoglinProd;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeProd;
import com.solegendary.reignofnether.unit.units.piglins.WitherSkeletonProd;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Portal
extends ProductionBuilding
implements NetherConvertingBuilding {
    public static final int CIVILIIAN_PORTAL_POPULATION_SUPPLY = 15;
    public static final float NON_NETHER_BUILD_TIME_MODIFIER = 2.0f;
    public static final String buildingName = "Basic Portal";
    public static final String structureName = "portal_basic";
    public static final String buildingNameCivilian = "Civilian Portal";
    public static final String structureNameCivilian = "portal_civilian";
    public static final String buildingNameMilitary = "Military Portal";
    public static final String structureNameMilitary = "portal_military";
    public static final String buildingNameTransport = "Transport Portal";
    public static final String structureNameTransport = "portal_transport";
    public static final ResourceCost cost = ResourceCosts.BASIC_PORTAL;
    public PortalType portalType = PortalType.BASIC;
    public BlockPos destination;
    public NetherZone netherConversionZone = null;

    public boolean hasDestination() {
        return this.isBuilt && this.portalType == PortalType.TRANSPORT && this.destination != null && !this.destination.equals((Object)new BlockPos(0, 0, 0));
    }

    @Override
    public double getMaxRange() {
        return 20.0;
    }

    @Override
    public double getStartingRange() {
        return 3.0;
    }

    @Override
    public NetherZone getZone() {
        return this.netherConversionZone;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (!this.getLevel().m_5776_() && this.getBlocksPlaced() >= this.getBlocksTotal() && this.getLevel().m_8055_(this.centrePos).m_60795_()) {
            this.getLevel().m_46597_(this.centrePos, Blocks.f_50083_.m_49966_());
        }
    }

    @Override
    public boolean shouldBeDestroyed() {
        boolean shouldBeDestroyed = super.shouldBeDestroyed();
        if (shouldBeDestroyed) {
            this.disconnectPortal();
        }
        return shouldBeDestroyed;
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        this.disconnectPortal();
        super.destroy(serverLevel);
    }

    public Portal(Level level, BlockPos originPos, Rotation rotation, String ownerName, boolean neutralTransport) {
        super(level, originPos, rotation, ownerName, neutralTransport ? BuildingUtils.getAbsoluteBlockData(NeutralTransportPortal.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation) : BuildingUtils.getAbsoluteBlockData(Portal.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50533_;
        this.icon = new ResourceLocation("minecraft", "textures/block/gray_glazed_terracotta.png");
        this.foodCost = Portal.cost.food;
        this.woodCost = Portal.cost.wood;
        this.oreCost = Portal.cost.ore;
        this.popSupply = Portal.cost.population;
        this.buildTimeModifier = 2.0f;
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_50197_);
        this.abilities.add(new ConnectPortal(this));
        this.abilities.add(new GotoPortal(this));
        this.abilities.add(new DisconnectPortal(this));
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyQ));
            this.abilityButtons.add(((Ability)this.abilities.get(1)).getButton(Keybindings.keyW));
            this.abilityButtons.add(((Ability)this.abilities.get(2)).getButton(Keybindings.keyE));
            this.productionButtons = Arrays.asList(ResearchPortalForCivilian.getStartButton(this, Keybindings.keyQ), ResearchPortalForMilitary.getStartButton(this, Keybindings.keyW), ResearchPortalForTransport.getStartButton(this, Keybindings.keyE));
        }
    }

    @Override
    public float getMagicDamageMult() {
        return 0.5f;
    }

    @Override
    public void setNetherZone(NetherZone nz) {
        if (this.netherConversionZone == null) {
            this.netherConversionZone = nz;
            if (!this.level.m_5776_()) {
                BuildingServerEvents.netherZones.add(this.netherConversionZone);
                BuildingServerEvents.saveNetherZones((ServerLevel)this.level);
            }
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        if (this.getMaxRange() > 0.0) {
            this.setNetherZone(new NetherZone(this.centrePos.m_7918_(0, -2, 0), this.getMaxRange(), this.getStartingRange()));
        }
    }

    public void disconnectPortal() {
        Building targetBuilding;
        if (this.destination != null && (targetBuilding = BuildingUtils.findBuilding(this.getLevel().m_5776_(), this.destination)) instanceof Portal) {
            Portal targetPortal = (Portal)targetBuilding;
            if (this.portalType == PortalType.TRANSPORT) {
                targetPortal.destination = null;
            }
        }
        this.destination = null;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        BlockPos worldBp = relativeBp.m_121955_((Vec3i)this.originPos);
        Block block = this.getLevel().m_8055_(worldBp).m_60734_();
        return block != Blocks.f_50080_ && block != Blocks.f_50142_;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    public void changeStructure(PortalType portalType) {
        String newStructureName = "";
        switch (portalType) {
            case CIVILIAN: {
                this.name = buildingNameCivilian;
                this.portraitBlock = Blocks.f_50535_;
                this.icon = new ResourceLocation("minecraft", "textures/block/cyan_glazed_terracotta.png");
                newStructureName = structureNameCivilian;
                this.canAcceptResources = true;
                this.popSupply = 15;
                if (!this.getLevel().m_5776_()) break;
                this.productionButtons = List.of(ResearchResourceCapacity.getStartButton(this, Keybindings.keyQ));
                break;
            }
            case MILITARY: {
                this.name = buildingNameMilitary;
                this.portraitBlock = Blocks.f_50540_;
                this.icon = new ResourceLocation("minecraft", "textures/block/red_glazed_terracotta.png");
                newStructureName = structureNameMilitary;
                this.canSetRallyPoint = true;
                if (!this.getLevel().m_5776_()) break;
                this.productionButtons = Arrays.asList(BruteProd.getStartButton(this, Keybindings.keyQ), HeadhunterProd.getStartButton(this, Keybindings.keyW), HoglinProd.getStartButton(this, Keybindings.keyE), BlazeProd.getStartButton(this, Keybindings.keyR), WitherSkeletonProd.getStartButton(this, Keybindings.keyT), MagmaCubeProd.getStartButton(this, Keybindings.keyY), GhastProd.getStartButton(this, Keybindings.keyU));
                break;
            }
            case TRANSPORT: {
                this.name = buildingNameTransport;
                this.portraitBlock = Blocks.f_50537_;
                this.icon = new ResourceLocation("minecraft", "textures/block/blue_glazed_terracotta.png");
                newStructureName = structureNameTransport;
            }
        }
        if (!newStructureName.isEmpty()) {
            ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocks(newStructureName, (LevelAccessor)this.getLevel());
            this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
            super.refreshBlocks();
            this.portalType = portalType;
        }
    }

    @Override
    public int getUpgradeLevel() {
        return this.portalType != PortalType.BASIC ? 1 : 0;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("reignofnether", "textures/icons/blocks/portal.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Portal.class, () -> false, () -> BuildingClientEvents.hasFinishedBuilding("Central Portal") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Portal.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.piglins.reignofnether.portal.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    public static enum PortalType {
        BASIC,
        CIVILIAN,
        MILITARY,
        TRANSPORT;

    }
}

