/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.shared;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractBridge
extends Building {
    public final float MELEE_DAMAGE_MULTIPLIER = 0.05f;

    public AbstractBridge(Level level, BlockPos originPos, Rotation rotation, String ownerName, boolean isDiagonalBridge, ArrayList<BuildingBlock> culledBlocks) {
        super(level, originPos, rotation, ownerName, culledBlocks, false);
        this.isDiagonalBridge = isDiagonalBridge;
    }

    @Override
    public float getMeleeDamageMult() {
        return 0.05f;
    }

    public static boolean shouldCullBlock(BlockPos originPos, BuildingBlock b, Level level) {
        BlockState bs = b.getBlockState();
        boolean isFenceOrAir = b.getBlockState().m_60734_() instanceof AirBlock || b.getBlockState().m_60734_() instanceof FenceBlock;
        BlockPos bp = b.getBlockPos().m_121955_((Vec3i)originPos);
        BlockState bsWorld = level.m_8055_(bp);
        if (bsWorld.m_60734_() == Blocks.f_50080_) {
            return false;
        }
        if (bsWorld.equals(bs)) {
            return false;
        }
        if (!(!bsWorld.m_60795_() && bsWorld.m_60819_().m_76178_() || isFenceOrAir)) {
            return false;
        }
        if (BuildingUtils.isPosInsideAnyBuilding(level.f_46443_, bp)) {
            return true;
        }
        for (BlockPos bpAdj : List.of(bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
            BlockState bsWorldAdj = level.m_8055_(bpAdj);
            if (!isFenceOrAir || bsWorldAdj.m_60795_() || !BuildingUtils.isPosInsideAnyBuilding(level.f_46443_, bpAdj)) continue;
            return true;
        }
        return MiscUtil.isSolidBlocking(level, bp) || isFenceOrAir && MiscUtil.isSolidBlocking(level, bp.m_7495_());
    }

    protected static ArrayList<BuildingBlock> getCulledBlocks(ArrayList<BuildingBlock> blocks, Level level) {
        blocks.removeIf(b -> AbstractBridge.shouldCullBlock(new BlockPos(0, 0, 0), b, level));
        return blocks;
    }

    private void replaceWithLiquidBelow(BlockPos bp, BlockState bs) {
        if (!(bs.m_60734_() instanceof FenceBlock)) {
            for (BlockPos bpAdj : List.of(bp.m_7495_(), bp.m_122012_(), bp.m_122019_(), bp.m_122029_(), bp.m_122024_())) {
                BlockState bsAdj = this.level.m_8055_(bpAdj);
                if (bsAdj.m_60819_().m_76178_()) continue;
                this.level.m_46597_(bp, bsAdj);
            }
        }
    }

    @Override
    public void onBlockBreak(ServerLevel level, BlockPos pos, boolean breakBlocks) {
        BlockState bs = level.m_8055_(pos);
        super.onBlockBreak(level, pos, breakBlocks);
        this.replaceWithLiquidBelow(pos, bs);
    }

    @Override
    public void destroy(ServerLevel serverLevel) {
        super.destroy(serverLevel);
        for (BuildingBlock bb : this.blocks) {
            if (bb.getBlockState().m_60734_() instanceof FenceBlock || bb.getBlockState().m_60734_() instanceof AirBlock) continue;
            this.replaceWithLiquidBelow(bb.getBlockPos(), bb.getBlockState());
        }
    }
}

