/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchCastleFlag;
import com.solegendary.reignofnether.research.researchItems.ResearchRavagerCavalry;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.unit.units.villagers.RavagerProd;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Castle
extends ProductionBuilding
implements GarrisonableBuilding {
    public static final String buildingName = "Castle";
    public static final String structureName = "castle";
    public static final String upgradedStructureName = "castle_with_flag";
    public static final ResourceCost cost = ResourceCosts.CASTLE;
    private static final int MAX_OCCUPANTS = 7;

    public Castle(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Castle.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50652_;
        this.icon = new ResourceLocation("minecraft", "textures/block/cobblestone.png");
        this.foodCost = Castle.cost.food;
        this.woodCost = Castle.cost.wood;
        this.oreCost = Castle.cost.ore;
        this.popSupply = Castle.cost.population;
        this.buildTimeModifier = 0.5f;
        this.startingBlockTypes.add(Blocks.f_50222_);
        this.startingBlockTypes.add(Blocks.f_50609_);
        this.startingBlockTypes.add(Blocks.f_50399_);
        this.startingBlockTypes.add(Blocks.f_50741_);
        this.startingBlockTypes.add(Blocks.f_50745_);
        this.abilities.add(new PromoteIllager(this));
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = Arrays.asList(RavagerProd.getStartButton(this, Keybindings.keyQ), ResearchRavagerCavalry.getStartButton(this, Keybindings.keyW), ResearchCastleFlag.getStartButton(this, Keybindings.keyE));
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyE));
        }
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public int getAttackRange() {
        return 30;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 15;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 15 && relativeBp.m_123342_() != 17;
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/cobblestone.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Castle.class, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.hasFinishedBuilding("Barracks") && BuildingClientEvents.hasFinishedBuilding("Blacksmith") && BuildingClientEvents.hasFinishedBuilding("Arcane Tower") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Castle.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle.tooltip2", (Object[])new Object[]{7}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    public void changeStructure(String newStructureName) {
        ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocks(newStructureName, (LevelAccessor)this.getLevel());
        this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
        super.refreshBlocks();
    }

    @Override
    public int getUpgradeLevel() {
        for (BuildingBlock block : this.blocks) {
            if (block.getBlockState().m_60734_() != Blocks.f_50041_ && block.getBlockState().m_60734_() != Blocks.f_50108_ && block.getBlockState().m_60734_() != Blocks.f_50102_) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        return this.originPos.m_121955_((Vec3i)this.getExitPosition());
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 16, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 16, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 16, -5);
        }
        return new BlockPos(5, 16, -5);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(5, 2, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-5, 2, 5);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-5, 2, -5);
        }
        return new BlockPos(5, 2, -5);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 7;
    }
}

