/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.IronGolemProd;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class IronGolemBuilding
extends Building {
    public static final String buildingName = "Iron Golem";
    public static final String structureName = "iron_golem";
    public static final ResourceCost cost = ResourceCosts.IRON_GOLEM_BUILDING;

    public IronGolemBuilding(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(IronGolemBuilding.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50075_;
        this.icon = new ResourceLocation("minecraft", "textures/block/iron_block.png");
        this.foodCost = IronGolemBuilding.cost.food;
        this.woodCost = IronGolemBuilding.cost.wood;
        this.oreCost = IronGolemBuilding.cost.ore;
        this.popSupply = IronGolemBuilding.cost.population;
        this.buildTimeModifier = 3.4f;
        this.startingBlockTypes.add(Blocks.f_50481_);
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        if (!this.getLevel().m_5776_()) {
            this.destroy((ServerLevel)this.getLevel());
            Entity entity = ((EntityType)EntityRegistrar.IRON_GOLEM_UNIT.get()).m_262455_((ServerLevel)this.getLevel(), (CompoundTag)null, null, this.centrePos.m_7918_(0, -1, 0), MobSpawnType.SPAWNER, true, false);
            if (entity instanceof Unit) {
                Unit unit = (Unit)entity;
                unit.setOwnerName(this.ownerName);
            }
        }
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/iron_block.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == IronGolemBuilding.class, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.hasFinishedBuilding("Blacksmith") && ResearchClient.hasResearch("Golem Smithing") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(IronGolemBuilding.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.iron_golem", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPopAndTime(IronGolemProd.cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.iron_golem.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.iron_golem.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

