/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.EnchantAbility;
import com.solegendary.reignofnether.ability.abilities.EnchantMaiming;
import com.solegendary.reignofnether.ability.abilities.EnchantMultishot;
import com.solegendary.reignofnether.ability.abilities.EnchantQuickCharge;
import com.solegendary.reignofnether.ability.abilities.EnchantSharpness;
import com.solegendary.reignofnether.ability.abilities.EnchantVigor;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.researchItems.ResearchEvokerVexes;
import com.solegendary.reignofnether.research.researchItems.ResearchGrandLibrary;
import com.solegendary.reignofnether.research.researchItems.ResearchHealingPotions;
import com.solegendary.reignofnether.research.researchItems.ResearchLingeringPotions;
import com.solegendary.reignofnether.research.researchItems.ResearchWaterPotions;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import org.joml.Vector3d;

public class Library
extends ProductionBuilding
implements RangeIndicator {
    public static final String buildingName = "Library";
    public static final String structureName = "library";
    public static final String upgradedStructureName = "library_grand";
    public static final ResourceCost cost = ResourceCosts.LIBRARY;
    public EnchantAbility autoCastEnchant = null;
    public static final int RANGE = 12;
    private final Set<BlockPos> borderBps = new HashSet<BlockPos>();

    public Library(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Library.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50201_;
        this.icon = new ResourceLocation("minecraft", "textures/block/enchanting_table_top.png");
        this.foodCost = Library.cost.food;
        this.woodCost = Library.cost.wood;
        this.oreCost = Library.cost.ore;
        this.popSupply = Library.cost.population;
        this.buildTimeModifier = 1.1f;
        this.canSetRallyPoint = false;
        this.startingBlockTypes.add(Blocks.f_49999_);
        this.startingBlockTypes.add(Blocks.f_50269_);
        this.explodeChance = 0.2f;
        this.abilities.add(new EnchantSharpness(this));
        this.abilities.add(new EnchantQuickCharge(this));
        this.abilities.add(new EnchantMaiming(this));
        this.abilities.add(new EnchantMultishot(this));
        this.abilities.add(new EnchantVigor(this));
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyQ));
            this.abilityButtons.add(((Ability)this.abilities.get(1)).getButton(Keybindings.keyW));
            this.abilityButtons.add(((Ability)this.abilities.get(2)).getButton(Keybindings.keyE));
            this.abilityButtons.add(((Ability)this.abilities.get(3)).getButton(Keybindings.keyR));
            this.abilityButtons.add(((Ability)this.abilities.get(4)).getButton(Keybindings.keyT));
            this.productionButtons = Arrays.asList(ResearchLingeringPotions.getStartButton(this, Keybindings.keyY), ResearchHealingPotions.getStartButton(this, Keybindings.keyU), ResearchWaterPotions.getStartButton(this, Keybindings.keyI), ResearchEvokerVexes.getStartButton(this, Keybindings.keyO), ResearchGrandLibrary.getStartButton(this, Keybindings.keyP));
        }
    }

    @Override
    public void tick(Level tickLevel) {
        List<Mob> mobs;
        super.tick(tickLevel);
        if (this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 8L == 0L && this.isBuilt && this.autoCastEnchant != null && this.autoCastEnchant.isOffCooldown() && !(mobs = MiscUtil.getEntitiesWithinRange(new Vector3d((double)this.centrePos.m_123341_(), (double)this.centrePos.m_123342_(), (double)this.centrePos.m_123343_()), this.autoCastEnchant.range - 1.0f, Mob.class, tickLevel).stream().filter(e -> this.autoCastEnchant.isCorrectUnitAndEquipment((LivingEntity)e) && this.autoCastEnchant.canAfford(this) && !this.autoCastEnchant.hasAnyEnchant((LivingEntity)e)).toList()).isEmpty()) {
            this.autoCastEnchant.use(tickLevel, (Building)this, (LivingEntity)mobs.get(0));
        }
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
    }

    private int getBorderRange() {
        return this.isBuilt ? 12 : 0;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.borderBps.clear();
        this.borderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getBorderRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.borderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return true;
    }

    @Override
    public String getUpgradedName() {
        return I18n.m_118938_((String)"buildings.villagers.reignofnether.library.upgraded", (Object[])new Object[0]);
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/enchanting_table_top.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Library.class, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.hasFinishedBuilding("Barracks") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Library.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.library", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.library.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.library.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.library.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }

    public void changeStructure(String newStructureName) {
        ArrayList<BuildingBlock> newBlocks = BuildingBlockData.getBuildingBlocks(newStructureName, (LevelAccessor)this.getLevel());
        this.blocks = BuildingUtils.getAbsoluteBlockData(newBlocks, (LevelAccessor)this.getLevel(), this.originPos, this.rotation);
        super.refreshBlocks();
    }

    @Override
    public int getUpgradeLevel() {
        for (BuildingBlock block : this.blocks) {
            if (block.getBlockState().m_60734_() != Blocks.f_50141_) continue;
            return 1;
        }
        return 0;
    }
}

