/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class OakBridge
extends AbstractBridge {
    public static final String buildingName = "Oak Bridge";
    public static final String structureNameOrthogonal = "bridge_oak_orthogonal";
    public static final String structureNameDiagonal = "bridge_oak_diagonal";
    public static final ResourceCost cost = ResourceCosts.OAK_BRIDGE;

    public OakBridge(Level level, BlockPos originPos, Rotation rotation, String ownerName, boolean diagonal) {
        super(level, originPos, rotation, ownerName, diagonal, OakBridge.getCulledBlocks(BuildingUtils.getAbsoluteBlockData(OakBridge.getRelativeBlockData((LevelAccessor)level, diagonal), (LevelAccessor)level, originPos, rotation), level));
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50132_;
        this.icon = new ResourceLocation("reignofnether", "textures/icons/blocks/oak_fence.png");
        this.foodCost = OakBridge.cost.food;
        this.woodCost = OakBridge.cost.wood;
        this.oreCost = OakBridge.cost.ore;
        this.popSupply = OakBridge.cost.population;
        this.buildTimeModifier = 1.0f;
        this.startingBlockTypes.add(Blocks.f_49999_);
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level, boolean diagonal) {
        return BuildingBlockData.getBuildingBlocks(diagonal ? structureNameDiagonal : structureNameOrthogonal, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        Minecraft MC = Minecraft.m_91087_();
        return new AbilityButton(buildingName, new ResourceLocation("reignofnether", "textures/icons/blocks/oak_fence.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == OakBridge.class, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.BUILD_BRIDGE), () -> TutorialClientEvents.isAtOrPastStage(TutorialStage.BUILD_BRIDGE) && (BuildingClientEvents.hasFinishedBuilding("Town Centre") || BuildingClientEvents.hasFinishedBuilding("Mausoleum") || ResearchClient.hasCheat("modifythephasevariance")), () -> BuildingClientEvents.setBuildingToPlace(OakBridge.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.oak_bridge.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

