/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.BackToWorkBuilding;
import com.solegendary.reignofnether.ability.abilities.CallToArmsBuilding;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.units.villagers.VillagerProd;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class TownCentre
extends ProductionBuilding
implements RangeIndicator {
    public static final String buildingName = "Town Centre";
    public static final String structureName = "town_centre";
    public static final ResourceCost cost = ResourceCosts.TOWN_CENTRE;
    public static final int MILITIA_RANGE = 60;
    private final Set<BlockPos> militiaBorderBps = new HashSet<BlockPos>();

    public TownCentre(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(TownCentre.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), true);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50175_;
        this.icon = new ResourceLocation("minecraft", "textures/block/polished_granite.png");
        this.foodCost = TownCentre.cost.food;
        this.woodCost = TownCentre.cost.wood;
        this.oreCost = TownCentre.cost.ore;
        this.popSupply = TownCentre.cost.population;
        this.buildTimeModifier = 0.331f;
        this.canAcceptResources = true;
        this.startingBlockTypes.add(Blocks.f_50194_);
        this.startingBlockTypes.add(Blocks.f_50440_);
        this.startingBlockTypes.add(Blocks.f_50641_);
        this.abilities.add(new CallToArmsBuilding(level));
        this.abilities.add(new BackToWorkBuilding(this.level));
        this.updateButtons();
    }

    @Override
    public void updateButtons() {
        if (this.level.m_5776_()) {
            this.productionButtons = List.of(VillagerProd.getStartButton(this, Keybindings.keyQ));
            this.abilityButtons.clear();
            this.abilityButtons.add(((Ability)this.abilities.get(0)).getButton(Keybindings.keyV));
            this.abilityButtons.add(((Ability)this.abilities.get(1)).getButton(Keybindings.build));
        }
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (tickLevel.f_46443_ && this.tickAgeAfterBuilt > 0L && this.tickAgeAfterBuilt % 100L == 0L) {
            this.updateBorderBps();
        }
    }

    private int getBorderRange() {
        return this.isBuilt ? 60 : 0;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_()) {
            return;
        }
        this.militiaBorderBps.clear();
        this.militiaBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getBorderRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.militiaBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return true;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/polished_granite.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == TownCentre.class, () -> false, () -> true, () -> BuildingClientEvents.setBuildingToPlace(TownCentre.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.town_centre", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPop(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.town_centre.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_)), null);
    }
}

