/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Watchtower
extends Building
implements GarrisonableBuilding {
    public static final String buildingName = "Watchtower";
    public static final String structureName = "watchtower";
    public static final ResourceCost cost = ResourceCosts.WATCHTOWER;
    private static final int MAX_OCCUPANTS = 3;

    public Watchtower(Level level, BlockPos originPos, Rotation rotation, String ownerName) {
        super(level, originPos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(Watchtower.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, originPos, rotation), false);
        this.name = buildingName;
        this.ownerName = ownerName;
        this.portraitBlock = Blocks.f_50222_;
        this.icon = new ResourceLocation("minecraft", "textures/block/stone_bricks.png");
        this.foodCost = Watchtower.cost.food;
        this.woodCost = Watchtower.cost.wood;
        this.oreCost = Watchtower.cost.ore;
        this.popSupply = Watchtower.cost.population;
        this.buildTimeModifier = 1.0f;
        this.startingBlockTypes.add(Blocks.f_50222_);
        this.startingBlockTypes.add(Blocks.f_50411_);
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public int getAttackRange() {
        return 24;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 10;
    }

    public static ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocks(structureName, level);
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 10 && relativeBp.m_123342_() != 11;
    }

    public static AbilityButton getBuildButton(Keybinding hotkey) {
        return new AbilityButton(buildingName, new ResourceLocation("minecraft", "textures/block/stone_bricks.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Watchtower.class, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.hasFinishedBuilding("Town Centre") || ResearchClient.hasCheat("modifythephasevariance"), () -> BuildingClientEvents.setBuildingToPlace(Watchtower.class), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.watchtower", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.watchtower.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.watchtower.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.watchtower.tooltip3", (Object[])new Object[]{3}), (Style)Style.f_131099_)), null);
    }

    @Override
    public BlockPos getEntryPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(2, 11, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-2, 11, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-2, 11, -2);
        }
        return new BlockPos(2, 11, -2);
    }

    @Override
    public BlockPos getExitPosition() {
        if (this.rotation == Rotation.NONE) {
            return new BlockPos(2, 1, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_90) {
            return new BlockPos(-2, 1, 2);
        }
        if (this.rotation == Rotation.CLOCKWISE_180) {
            return new BlockPos(-2, 1, -2);
        }
        return new BlockPos(2, 1, -2);
    }

    @Override
    public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants(this) >= 3;
    }
}

