/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.fogofwar.FrozenChunkServerboundPacket;
import com.solegendary.reignofnether.nether.NetherBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FrozenChunk {
    public BlockPos origin;
    public Map<BlockPos, BlockState> blocks = new HashMap<BlockPos, BlockState>();
    public Building building;
    public boolean removeOnExplore = false;
    public boolean hasFakeBlocks = false;
    public boolean unsaved = true;
    private static final Minecraft MC = Minecraft.m_91087_();

    public FrozenChunk(BlockPos origin, Building building, boolean forceFakeChunks) {
        this.origin = origin;
        this.building = building;
        if (this.isFullyLoaded()) {
            if (forceFakeChunks) {
                this.saveFakeBlocks();
            } else {
                this.saveBlocks();
            }
        }
    }

    public FrozenChunk(BlockPos origin, Building building, FrozenChunk frozenChunkToCopy) {
        this.origin = origin;
        this.building = building;
        this.hasFakeBlocks = frozenChunkToCopy.hasFakeBlocks;
        for (BlockPos pos : frozenChunkToCopy.blocks.keySet()) {
            this.blocks.put(pos, frozenChunkToCopy.blocks.get(pos));
        }
        this.unsaved = frozenChunkToCopy.unsaved;
    }

    public void saveBlocks() {
        if (FrozenChunk.MC.f_91073_ == null) {
            return;
        }
        ArrayList<BuildingBlock> bbs = new ArrayList<BuildingBlock>();
        for (BuildingBlock bb : this.building.getBlocks()) {
            if (!this.isPosInside(bb.getBlockPos()) || bb.getBlockState().m_60795_()) continue;
            bbs.add(bb);
        }
        for (int x = 0; x <= 16; ++x) {
            for (int y = 0; y <= 16; ++y) {
                for (int z = 0; z <= 16; ++z) {
                    BlockPos bp = this.origin.m_7918_(x, y, z);
                    BlockState bs = FrozenChunk.MC.f_91073_.m_8055_(bp);
                    this.saveBlock(bp, bs, new ArrayList<BuildingBlock>());
                }
            }
        }
        this.hasFakeBlocks = false;
        this.unsaved = false;
    }

    public void saveFakeBlocks() {
        if (FrozenChunk.MC.f_91073_ == null) {
            return;
        }
        ArrayList<BuildingBlock> bbs = new ArrayList<BuildingBlock>();
        for (BuildingBlock bb : this.building.getBlocks()) {
            if (!this.isPosInside(bb.getBlockPos()) || bb.getBlockState().m_60795_()) continue;
            bbs.add(bb);
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                block3: for (int z = 0; z < 16; ++z) {
                    BlockState overworldBs;
                    BlockPos bp = this.origin.m_7918_(x, y, z);
                    BlockState bs = FrozenChunk.MC.f_91073_.m_8055_(bp);
                    for (BuildingBlock bb : bbs) {
                        if (!bb.getBlockPos().equals((Object)bp)) continue;
                        if (this.building instanceof AbstractBridge && !(bb.getBlockState().m_60734_() instanceof WallBlock) && !(bb.getBlockState().m_60734_() instanceof FenceBlock)) {
                            this.saveBlock(bb.getBlockPos(), Blocks.f_49990_.m_49966_(), bbs);
                            continue block3;
                        }
                        this.saveBlock(bb.getBlockPos(), Blocks.f_50016_.m_49966_(), bbs);
                        continue block3;
                    }
                    String blockName = bs.m_60734_().m_49954_().getString().toLowerCase();
                    if (blockName.equals("scaffolding")) {
                        this.saveBlock(bp, Blocks.f_50016_.m_49966_(), bbs);
                        continue;
                    }
                    if (blockName.contains("magma_block") || blockName.equals("cobblestone")) {
                        this.saveBlock(bp, Blocks.f_49997_.m_49966_(), bbs);
                        continue;
                    }
                    if (blockName.equals("dirt") || blockName.equals("netherrack")) {
                        this.saveBlock(bp, Blocks.f_50440_.m_49966_(), bbs);
                        continue;
                    }
                    if (blockName.equals("obsidian")) {
                        this.saveBlock(bp, Blocks.f_49990_.m_49966_(), bbs);
                        continue;
                    }
                    if (blockName.equals("nether portal")) {
                        this.saveBlock(bp, Blocks.f_50016_.m_49966_(), bbs);
                        continue;
                    }
                    if (NetherBlocks.isNetherBlock((Level)FrozenChunk.MC.f_91073_, bp)) {
                        overworldBs = NetherBlocks.getOverworldBlock((Level)FrozenChunk.MC.f_91073_, bp);
                        if (overworldBs == null) continue;
                        this.saveBlock(bp, overworldBs, bbs);
                        continue;
                    }
                    if (NetherBlocks.isNetherPlantBlock((Level)FrozenChunk.MC.f_91073_, bp)) {
                        overworldBs = NetherBlocks.getOverworldPlantBlock((Level)FrozenChunk.MC.f_91073_, bp, false);
                        if (overworldBs == null) continue;
                        this.saveBlock(bp, overworldBs, bbs);
                        continue;
                    }
                    this.saveBlock(bp, FrozenChunk.MC.f_91073_.m_8055_(bp), bbs);
                }
            }
        }
        this.hasFakeBlocks = true;
        this.unsaved = false;
    }

    public boolean isPosInside(BlockPos bp) {
        return bp.m_123341_() >= this.origin.m_123341_() && bp.m_123341_() < this.origin.m_123341_() + 16 && bp.m_123342_() >= this.origin.m_123342_() && bp.m_123342_() < this.origin.m_123342_() + 16 && bp.m_123343_() >= this.origin.m_123343_() && bp.m_123343_() < this.origin.m_123343_() + 16;
    }

    public void loadBlocks() {
        if (FrozenChunk.MC.f_91073_ == null) {
            return;
        }
        for (BlockPos bp : this.blocks.keySet()) {
            FrozenChunk.MC.f_91073_.m_46597_(bp, this.blocks.get(bp));
        }
    }

    public void unloadBlocks() {
        FrozenChunkServerboundPacket.syncServerBlocks(this.origin);
    }

    private boolean isFullyLoaded() {
        if (FrozenChunk.MC.f_91073_ == null) {
            return false;
        }
        for (int x = 0; x <= 16; ++x) {
            for (int y = 0; y <= 16; ++y) {
                for (int z = 0; z <= 16; ++z) {
                    if (FrozenChunk.MC.f_91073_.m_46749_(this.origin.m_7918_(x, y, z))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void saveBlock(BlockPos bp, BlockState bs, ArrayList<BuildingBlock> bbs) {
        this.blocks.put(bp, bs);
    }
}

