/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.healthbars;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BarState {
    public final int entityId;
    public float health;
    public float previousHealth;
    public float previousHealthDisplay;
    public float previousHealthDelay;
    public int lastDmg;
    public int lastDmgCumulative;
    public float lastHealth;
    public float lastDmgDelay;
    private float animationSpeed = 0.0f;
    private static final float HEALTH_INDICATOR_DELAY = 10.0f;

    public BarState(int entityId) {
        this.entityId = entityId;
    }

    public void tick() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.health = Math.min(livingEntity.m_21223_(), livingEntity.m_21233_());
            this.incrementTimers();
            if ((double)this.lastHealth < 0.1) {
                this.reset();
            } else if (this.lastHealth != this.health) {
                this.handleHealthChange();
            } else if (this.lastDmgDelay == 0.0f) {
                this.reset();
            }
            this.updateAnimations();
        }
    }

    private void reset() {
        this.lastHealth = this.health;
        this.lastDmg = 0;
        this.lastDmgCumulative = 0;
    }

    private void incrementTimers() {
        if (this.lastDmgDelay > 0.0f) {
            this.lastDmgDelay -= 1.0f;
        }
        if (this.previousHealthDelay > 0.0f) {
            this.previousHealthDelay -= 1.0f;
        }
    }

    private void handleHealthChange() {
        this.lastDmg = Mth.m_14167_((float)this.lastHealth) - Mth.m_14167_((float)this.health);
        this.lastDmgCumulative += this.lastDmg;
        this.lastDmgDelay = 20.0f;
        this.lastHealth = this.health;
    }

    private void updateAnimations() {
        if (this.previousHealthDelay > 0.0f) {
            float diff = this.previousHealthDisplay - this.health;
            if (diff > 0.0f) {
                this.animationSpeed = diff / 10.0f;
            }
        } else if (this.previousHealthDelay < 1.0f && this.previousHealthDisplay > this.health && this.animationSpeed > 0.0f) {
            this.previousHealthDisplay -= this.animationSpeed;
        } else {
            this.previousHealthDisplay = this.health;
            this.previousHealth = this.health;
            this.previousHealthDelay = 10.0f;
        }
    }
}

