/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class AbilityButton
extends Button {
    public Ability ability;
    public String extraLabel = "";
    public int extraLabelColour = 0xFFFFFF;

    public AbilityButton(String name, ResourceLocation rl, Keybinding hotkey, Supplier<Boolean> isSelected, Supplier<Boolean> isHidden, Supplier<Boolean> isEnabled, Runnable onLeftClick, Runnable onRightClick, List<FormattedCharSequence> tooltipLines, @Nullable Ability ability) {
        super(name, Button.itemIconSize, rl, hotkey, isSelected, isHidden, isEnabled, onLeftClick, onRightClick, tooltipLines);
        this.ability = ability;
        Runnable originalOnLeftClick = this.onLeftClick;
        this.onLeftClick = () -> {
            if (this.ability != null && this.ability.getCooldown() > 0.0f && !this.ability.canBypassCooldown()) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.buttons.reignofnether.on_cooldown", (Object[])new Object[0]));
            } else if (originalOnLeftClick != null) {
                originalOnLeftClick.run();
            }
        };
    }

    @Override
    protected void renderHotkey(GuiGraphics guiGraphics, int x, int y) {
        if (this.ability == null || !this.ability.usesCharges()) {
            super.renderHotkey(guiGraphics, x, y);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
        if (this.ability != null && this.ability.cooldownMax > 0.0f) {
            this.greyPercent = 1.0f - this.ability.getCooldown() / this.ability.cooldownMax;
        }
        super.render(guiGraphics, x, y, mouseX, mouseY);
        if (this.ability != null && this.ability.usesCharges()) {
            String chargeStr = String.valueOf(this.ability.charges);
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
            int colour = 0xFFFFFF;
            if (this.ability.charges >= this.ability.maxCharges) {
                colour = 65280;
            } else if (this.ability.charges <= 0) {
                colour = 0xFF0000;
            } else if (this.ability.charges == 1) {
                colour = 0xFFFF00;
            }
            guiGraphics.m_280137_(this.MC.f_91062_, chargeStr, x + this.iconSize - 5 - chargeStr.length() * 4, y + this.iconSize - 1, colour);
            super.renderHotkey(guiGraphics, x, y);
        } else if (this.ability != null && !this.extraLabel.isBlank()) {
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
            guiGraphics.m_280137_(this.MC.f_91062_, this.extraLabel, x + this.iconSize - 7 - (this.extraLabel.length() >= 1 ? 0 : 5), y + this.iconSize - 1, this.extraLabelColour);
        }
    }
}

