/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.ability.abilities.CallToArmsUnit;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.attackwarnings.AttackWarningClientEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.config.ConfigClientEvents;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.ControlGroup;
import com.solegendary.reignofnether.hud.PortraitRendererBuilding;
import com.solegendary.reignofnether.hud.PortraitRendererUnit;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.hud.buttons.ActionButtons;
import com.solegendary.reignofnether.hud.buttons.HelperButtons;
import com.solegendary.reignofnether.hud.buttons.StartButtons;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxActionButtons;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxMenuType;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.survival.SurvivalClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.NonUnitClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.PhantomSummon;
import com.solegendary.reignofnether.unit.units.monsters.PoisonSpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.StrayUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.Model;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HudClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static String tempMsg = "";
    private static int tempMsgTicksLeft = 0;
    private static final int TEMP_MSG_TICKS_FADE = 50;
    private static final int TEMP_MSG_TICKS_MAX = 150;
    private static final int MAX_BUTTONS_PER_ROW = 6;
    public static final ArrayList<ControlGroup> controlGroups = new ArrayList(10);
    public static int lastSelCtrlGroupKey = -1;
    private static final ArrayList<Button> buildingButtons = new ArrayList();
    private static final ArrayList<Button> unitButtons = new ArrayList();
    private static final ArrayList<Button> productionButtons = new ArrayList();
    private static final ArrayList<Button> renderedButtons = new ArrayList();
    public static LivingEntity hudSelectedEntity = null;
    public static Building hudSelectedBuilding = null;
    public static PortraitRendererUnit portraitRendererUnit = new PortraitRendererUnit();
    public static PortraitRendererBuilding portraitRendererBuilding = new PortraitRendererBuilding();
    private static RectZone unitPortraitZone = null;
    private static RectZone buildingPortraitZone = null;
    public static int mouseX = 0;
    public static int mouseY = 0;
    private static int mouseLeftDownX = 0;
    private static int mouseLeftDownY = 0;
    private static final int iconBgColour = 0x64000000;
    private static final int frameBgColour = -1610612736;
    private static final ArrayList<RectZone> hudZones = new ArrayList();

    public static void setLowestCdHudEntity() {
        if (UnitClientEvents.getSelectedUnits().isEmpty() || hudSelectedEntity == null) {
            return;
        }
        List<Pair> pairs = UnitClientEvents.getSelectedUnits().stream().map(le -> {
            float totalCd = 0.0f;
            if (le instanceof Unit) {
                Unit unit = (Unit)le;
                for (Ability ability : unit.getAbilities()) {
                    totalCd += ability.getCooldown();
                    if (!ability.isChanneling()) continue;
                    totalCd += 10.0f;
                }
            }
            return new Pair(le, (Object)Float.valueOf(totalCd));
        }).filter(p -> {
            String str1 = HudClientEvents.getModifiedEntityName((LivingEntity)p.getFirst());
            String str2 = HudClientEvents.getModifiedEntityName(hudSelectedEntity);
            return str1.equals(str2);
        }).sorted(Comparator.comparing(Pair::getSecond)).toList();
        if (!pairs.isEmpty()) {
            HudClientEvents.setHudSelectedEntity((LivingEntity)pairs.get(0).getFirst());
        }
    }

    public static void setHudSelectedEntity(LivingEntity entity) {
        hudSelectedEntity = entity;
    }

    public static String getSimpleEntityName(Entity entity) {
        if (entity instanceof PhantomSummon) {
            return "Phantom";
        }
        if (entity instanceof Unit) {
            if (entity.m_8077_()) {
                return entity.m_6095_().m_20676_().getString().replace(" ", "").replace("entity.reignofnether.", "").replace("_unit", "").replace(".none", "");
            }
            return entity.m_7755_().getString().replace(" ", "").replace("entity.reignofnether.", "").replace("_unit", "").replace(".none", "");
        }
        return entity.m_7755_().getString().toLowerCase();
    }

    public static String getModifiedEntityName(LivingEntity entity) {
        CreeperUnit cUnit;
        Object name = HudClientEvents.getSimpleEntityName((Entity)entity);
        if (entity.m_6162_()) {
            name = I18n.m_118938_((String)"units.neutral.reignofnether.baby", (Object[])new Object[0]) + " " + (String)name;
        }
        if (!(entity instanceof Unit)) {
            return ((String)name).toLowerCase();
        }
        ItemStack itemStack = entity.m_6844_(EquipmentSlot.HEAD);
        if (itemStack.m_41720_() instanceof BannerItem) {
            name = (String)name + " " + I18n.m_118938_((String)"units.villagers.reignofnether.captain", (Object[])new Object[0]);
        }
        if (entity.m_20197_().size() == 1) {
            Entity passenger = (Entity)entity.m_20197_().get(0);
            if (entity instanceof RavagerUnit && passenger instanceof PillagerUnit) {
                name = I18n.m_118938_((String)"units.villagers.reignofnether.ravager_artillery", (Object[])new Object[0]);
            } else if (entity instanceof PoisonSpiderUnit && (passenger instanceof SkeletonUnit || passenger instanceof StrayUnit)) {
                name = I18n.m_118938_((String)"units.monsters.reignofnether.poison_spider_jockey", (Object[])new Object[0]);
            } else if (entity instanceof SpiderUnit && (passenger instanceof SkeletonUnit || passenger instanceof StrayUnit)) {
                name = I18n.m_118938_((String)"units.monsters.reignofnether.spider_jockey", (Object[])new Object[0]);
            } else if (entity instanceof HoglinUnit && passenger instanceof HeadhunterUnit) {
                name = I18n.m_118938_((String)"units.piglins.reignofnether.hoglin_rider", (Object[])new Object[0]);
            } else {
                String pName = HudClientEvents.getSimpleEntityName((Entity)entity.m_20197_().get(0)).replace("_", " ");
                String nameCap = pName.substring(0, 1).toUpperCase() + pName.substring(1);
                name = (String)name + " & " + nameCap;
            }
        }
        if (entity instanceof VillagerUnit) {
            VillagerUnit vUnit = (VillagerUnit)entity;
            switch (vUnit.getUnitProfession()) {
                case FARMER: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_farmer", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.farmer", (Object[])new Object[0]);
                    break;
                }
                case LUMBERJACK: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_lumberjack", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.lumberjack", (Object[])new Object[0]);
                    break;
                }
                case MINER: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_miner", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.miner", (Object[])new Object[0]);
                    break;
                }
                case MASON: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_mason", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.mason", (Object[])new Object[0]);
                    break;
                }
                case HUNTER: {
                    if (vUnit.isVeteran()) {
                        name = I18n.m_118938_((String)"units.reignofnether.veteran_hunter", (Object[])new Object[0]);
                        break;
                    }
                    name = I18n.m_118938_((String)"units.reignofnether.hunter", (Object[])new Object[0]);
                    break;
                }
                default: {
                    name = I18n.m_118938_((String)"units.villagers.reignofnether.villager", (Object[])new Object[0]);
                }
            }
        }
        if (entity instanceof CreeperUnit && (cUnit = (CreeperUnit)entity).m_7090_()) {
            name = I18n.m_118938_((String)"units.monsters.reignofnether.charged_creeper", (Object[])new Object[0]);
        }
        return name;
    }

    public static void showTemporaryMessage(String msg) {
        HudClientEvents.showTemporaryMessage(msg, 150);
    }

    public static void showTemporaryMessage(String msg, int ticks) {
        tempMsgTicksLeft = ticks;
        tempMsg = msg;
    }

    public static void removeFromControlGroups(int entityId) {
        for (ControlGroup controlGroup : controlGroups) {
            controlGroup.entityIds.removeIf(id -> id == entityId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render.Post evt) {
        void var13_46;
        boolean bl;
        boolean bl2;
        void var13_44;
        LivingEntity livingEntity;
        LivingEntity livingEntity2;
        Object plusUnitsZone;
        if (!OrthoviewClientEvents.isEnabled() || !(evt.getScreen() instanceof TopdownGui)) {
            return;
        }
        if (HudClientEvents.MC.f_91073_ == null) {
            return;
        }
        mouseX = evt.getMouseX();
        mouseY = evt.getMouseY();
        int hudStartingXPos = Button.DEFAULT_ICON_FRAME_SIZE * 6 + Button.DEFAULT_ICON_FRAME_SIZE / 2;
        ArrayList<LivingEntity> selUnits = UnitClientEvents.getSelectedUnits();
        ArrayList<Building> selBuildings = BuildingClientEvents.getSelectedBuildings();
        int screenWidth = MC.m_91268_().m_85445_();
        int screenHeight = MC.m_91268_().m_85446_();
        int iconSize = 14;
        int iconFrameSize = Button.DEFAULT_ICON_FRAME_SIZE;
        int buttonsPerRow = (int)Math.ceil((float)(screenWidth - 340) / (float)iconFrameSize);
        buttonsPerRow = Math.min(buttonsPerRow, 8);
        buttonsPerRow = Math.max(buttonsPerRow, 4);
        buildingButtons.clear();
        unitButtons.clear();
        productionButtons.clear();
        renderedButtons.clear();
        hudZones.clear();
        unitPortraitZone = null;
        buildingPortraitZone = null;
        int blitX = hudStartingXPos;
        int blitY = MC.m_91268_().m_85446_();
        int blitXStart = blitX;
        if (selBuildings.size() <= 0) {
            hudSelectedBuilding = null;
        } else if (hudSelectedBuilding == null || selBuildings.size() == 1 || !selBuildings.contains(hudSelectedBuilding)) {
            hudSelectedBuilding = selBuildings.get(0);
        }
        if (hudSelectedBuilding != null) {
            Building buttonsRendered22;
            boolean hudSelBuildingOwned = BuildingClientEvents.getPlayerToBuildingRelationship(hudSelectedBuilding) == Relationship.OWNED || SandboxClientEvents.isSandboxPlayer();
            buildingPortraitZone = portraitRendererBuilding.render(evt.getGuiGraphics(), blitX, blitY -= HudClientEvents.portraitRendererBuilding.frameHeight, hudSelectedBuilding);
            hudZones.add(buildingPortraitZone);
            blitXStart = (blitX += HudClientEvents.portraitRendererBuilding.frameWidth + 10) + 20;
            for (Building building : selBuildings) {
                if (!hudSelBuildingOwned || buildingButtons.size() >= buttonsPerRow * 2) continue;
                buildingButtons.add(new Button(building.name, iconSize, building.icon, building, () -> HudClientEvents.hudSelectedBuilding.name.equals(building.name), () -> false, () -> true, () -> {
                    if (HudClientEvents.hudSelectedBuilding.name.equals(building.name)) {
                        BuildingClientEvents.clearSelectedBuildings();
                        BuildingClientEvents.addSelectedBuilding(building);
                    } else {
                        hudSelectedBuilding = building;
                    }
                }, null, null));
            }
            if (buildingButtons.size() >= 2) {
                hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), (blitX += 20) - 5, (blitY += 6) - 10, iconFrameSize * buttonsPerRow + 10, iconFrameSize * 2 + 20, -1610612736));
                int buttonsRendered22 = 0;
                for (Button buildingButton : buildingButtons) {
                    if (buttonsRendered22 >= buttonsPerRow * 2 - 1 && selBuildings.size() > buttonsPerRow * 2) {
                        int numExtraBuildings = selBuildings.size() - buttonsPerRow * 2 + 1;
                        RectZone plusBuildingsZone = MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), buildingButton.frameResource, blitX, blitY, iconFrameSize, 0x64000000);
                        evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, "+" + numExtraBuildings, blitX + iconFrameSize / 2, blitY + 8, 0xFFFFFF);
                        if (!plusBuildingsZone.isMouseOver(mouseX, mouseY)) break;
                        ArrayList<FormattedCharSequence> tooltipLines = new ArrayList<FormattedCharSequence>();
                        int numBuildings = 0;
                        for (int i = selBuildings.size() - numExtraBuildings; i < selBuildings.size(); ++i) {
                            Building building = selBuildings.get(i);
                            Building nextBuilding = null;
                            String buildingName = building.name;
                            String nextBuildingName = null;
                            ++numBuildings;
                            if (i < selBuildings.size() - 1) {
                                nextBuilding = selBuildings.get(i + 1);
                                nextBuildingName = nextBuilding.name;
                            }
                            if (buildingName.equals(nextBuildingName)) continue;
                            tooltipLines.add(FormattedCharSequence.m_13714_((String)("x" + numBuildings + " " + I18n.m_118938_((String)buildingName, (Object[])new Object[0])), (Style)Style.f_131099_));
                            numBuildings = 0;
                        }
                        MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltipLines, mouseX, mouseY);
                        break;
                    }
                    buildingButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                    renderedButtons.add(buildingButton);
                    buildingButton.renderHealthBar(evt.getGuiGraphics().m_280168_());
                    blitX += iconFrameSize;
                    if (buttonsRendered22 == buttonsPerRow - 1) {
                        blitX = blitXStart;
                        blitY += iconFrameSize + 6;
                    }
                    ++buttonsRendered22;
                }
            } else if ((hudSelBuildingOwned || !PlayerClientEvents.isRTSPlayer) && (buttonsRendered22 = hudSelectedBuilding) instanceof ProductionBuilding) {
                ProductionBuilding productionBuilding = (ProductionBuilding)buttonsRendered22;
                blitY = screenHeight - iconFrameSize * 2 - 5;
                for (int i = 0; i < productionBuilding.productionQueue.size(); ++i) {
                    Button button = productionBuilding.productionQueue.get(i).getCancelButton(productionBuilding, i == 0);
                    if (!hudSelBuildingOwned) {
                        button.onLeftClick = () -> {};
                        button.onRightClick = () -> {};
                    }
                    productionButtons.add(button);
                }
                if (productionButtons.size() >= 1) {
                    hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX - 5, blitY - 10, iconFrameSize * buttonsPerRow + 10, iconFrameSize * 2 + 15, -1610612736));
                    ProductionItem firstProdItem = productionBuilding.productionQueue.get(0);
                    float f = firstProdItem.ticksLeft / firstProdItem.ticksToProduce;
                    int colour = 0xFFFFFF;
                    if (!firstProdItem.isBelowPopulationSupply()) {
                        colour = 0xFF0000;
                        if (f <= 0.0f) {
                            f = 0.01f;
                        }
                    }
                    evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, Math.round(100.0f - f * 100.0f) + "% " + HudClientEvents.productionButtons.get((int)0).name, blitX + iconFrameSize + 5, blitY + 2, colour);
                    int buttonsRendered3 = 0;
                    for (Button prodButton : productionButtons) {
                        if (buttonsRendered3 == 0) {
                            prodButton.greyPercent = 1.0f - f;
                            prodButton.render(evt.getGuiGraphics(), blitX, blitY - 5, mouseX, mouseY);
                            renderedButtons.add(prodButton);
                        } else {
                            if (buttonsRendered3 >= buttonsPerRow && productionButtons.size() > buttonsPerRow + 1) {
                                int numExtraItems = productionButtons.size() - buttonsPerRow;
                                MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), prodButton.frameResource, blitX, blitY + iconFrameSize, iconFrameSize, 0x64000000);
                                evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, "+" + numExtraItems, blitX + iconFrameSize / 2, blitY + iconFrameSize + 8, 0xFFFFFF);
                                break;
                            }
                            prodButton.render(evt.getGuiGraphics(), blitX, blitY + iconFrameSize, mouseX, mouseY);
                            renderedButtons.add(prodButton);
                            blitX += iconFrameSize;
                        }
                        ++buttonsRendered3;
                    }
                }
            }
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            if (hudSelectedBuilding != null && hudSelBuildingOwned && !HudClientEvents.hudSelectedBuilding.isBuilt) {
                if (!HelperButtons.buildingCancelButton.isHidden.get().booleanValue()) {
                    HelperButtons.buildingCancelButton.render(evt.getGuiGraphics(), 0, screenHeight - iconFrameSize, mouseX, mouseY);
                    renderedButtons.add(HelperButtons.buildingCancelButton);
                }
            } else if (hudSelBuildingOwned) {
                Building building;
                void var13_24;
                List list = List.of();
                if (hudSelectedBuilding != null) {
                    List<AbilityButton> list2 = hudSelectedBuilding.getAbilityButtons().stream().filter(b -> (Boolean)b.isHidden.get() == false).toList();
                }
                if (var13_24.size() > 0) {
                    blitY -= Button.DEFAULT_ICON_FRAME_SIZE;
                }
                if ((building = hudSelectedBuilding) instanceof ProductionBuilding) {
                    ProductionBuilding selProdBuilding = (ProductionBuilding)building;
                    List<Button> list3 = selProdBuilding.productionButtons.stream().filter(b -> b.isHidden.get() == false).toList();
                    if (list3.size() > 6) {
                        blitY -= Button.DEFAULT_ICON_FRAME_SIZE;
                    }
                    int rowButtons = 0;
                    for (Button prodButton : list3) {
                        if (++rowButtons > 6) {
                            rowButtons = 0;
                            blitX = 0;
                            blitY += Button.DEFAULT_ICON_FRAME_SIZE;
                        }
                        prodButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                        productionButtons.add(prodButton);
                        renderedButtons.add(prodButton);
                        blitX += iconFrameSize;
                    }
                }
                blitY += Button.DEFAULT_ICON_FRAME_SIZE;
                blitX = 0;
                for (AbilityButton abilityButton : var13_24) {
                    if (((Boolean)abilityButton.isHidden.get()).booleanValue()) continue;
                    abilityButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                    renderedButtons.add(abilityButton);
                    blitX += iconFrameSize;
                }
            }
        } else if (hudSelectedEntity != null && HudClientEvents.portraitRendererUnit.model != null && HudClientEvents.portraitRendererUnit.renderer != null) {
            Unit unit;
            Objects.requireNonNull(portraitRendererUnit);
            blitY -= 60;
            String name = HudClientEvents.getModifiedEntityName(hudSelectedEntity).replace("_", " ");
            if (hudSelectedEntity.m_8077_()) {
                name = hudSelectedEntity.m_7770_().getString();
            }
            String string = name.substring(0, 1).toUpperCase() + name.substring(1);
            unitPortraitZone = portraitRendererUnit.render(evt.getGuiGraphics(), string, blitX, blitY, hudSelectedEntity);
            hudZones.add(unitPortraitZone);
            LivingEntity livingEntity3 = hudSelectedEntity;
            if (livingEntity3 instanceof HeroUnit) {
                HeroUnit heroUnit = (HeroUnit)livingEntity3;
                RectZone rectZone = portraitRendererUnit.renderHeroLevelAndExp(evt.getGuiGraphics(), blitX + 1, blitY - 5, mouseX, mouseY, heroUnit);
                hudZones.add(rectZone);
                if (rectZone.isMouseOver(mouseX, mouseY)) {
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), heroUnit.getHeroLevel() >= 10 ? List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.hero.reignofnether.max_level", (Object[])new Object[0]))) : List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.hero.reignofnether.experience", (Object[])new Object[]{heroUnit.getExpOnCurrentLevel(), heroUnit.getExpToNextlevel()}))), mouseX, mouseY);
                }
            }
            Objects.requireNonNull(portraitRendererUnit);
            blitX += 60;
            LivingEntity livingEntity4 = hudSelectedEntity;
            if (livingEntity4 instanceof Unit) {
                Mob mob;
                Unit unit2 = (Unit)livingEntity4;
                hudZones.add(portraitRendererUnit.renderStats(evt.getGuiGraphics(), string, blitX, blitY, unit2));
                blitX += HudClientEvents.portraitRendererUnit.statsWidth;
                int n = Resources.getTotalResourcesFromItems(unit2.getItems()).getTotalValue();
                LivingEntity buttonsRendered3 = hudSelectedEntity;
                if (buttonsRendered3 instanceof Mob && (mob = (Mob)buttonsRendered3).m_21531_() && n > 0) {
                    hudZones.add(portraitRendererUnit.renderResourcesHeld(evt.getGuiGraphics(), blitX, blitY, unit2));
                    if (UnitClientEvents.getPlayerToEntityRelationship(hudSelectedEntity) == Relationship.OWNED) {
                        Button returnButton = new Button("Return resources", Button.itemIconSize, new ResourceLocation("reignofnether", "textures/icons/items/chest.png"), Keybindings.keyD, () -> unit2.getReturnResourcesGoal().getBuildingTarget() != null, () -> false, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.RETURN_RESOURCES_TO_CLOSEST), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.drop_off_resources", (Object[])new Object[0]), (Style)Style.f_131099_)));
                        returnButton.render(evt.getGuiGraphics(), blitX + 10, blitY + 38, mouseX, mouseY);
                        renderedButtons.add(returnButton);
                    }
                }
            } else if (ResourceSources.isHuntableAnimal(hudSelectedEntity)) {
                hudZones.add(portraitRendererUnit.renderResourcesHeld(evt.getGuiGraphics(), blitX, blitY, (Animal)hudSelectedEntity));
                blitX += HudClientEvents.portraitRendererUnit.statsWidth;
            }
            LivingEntity livingEntity5 = hudSelectedEntity;
            blitX = livingEntity5 instanceof Unit && Resources.getTotalResourcesFromItems((unit = (Unit)livingEntity5).getItems()).getTotalValue() > 0 ? (blitX += HudClientEvents.portraitRendererUnit.statsWidth + 5) : (blitX += 15);
        }
        blitXStart = blitX;
        blitY = screenHeight - iconFrameSize * 2 - 10;
        for (LivingEntity livingEntity6 : selUnits) {
            void var15_82;
            if (UnitClientEvents.getPlayerToEntityRelationship(livingEntity6) != Relationship.OWNED && !NonUnitClientEvents.canControlNonUnits() || unitButtons.size() >= buttonsPerRow * 2) continue;
            String unitName = HudClientEvents.getSimpleEntityName((Entity)livingEntity6);
            if (livingEntity6.m_20160_()) {
                String string = "textures/mobheads/" + unitName + "_half.png";
            } else {
                String string = "textures/mobheads/" + unitName + ".png";
            }
            Button button = new Button(unitName, iconSize, livingEntity6 instanceof Unit ? new ResourceLocation("reignofnether", (String)var15_82) : null, livingEntity6, () -> hudSelectedEntity == null || HudClientEvents.getModifiedEntityName(hudSelectedEntity).equals(HudClientEvents.getModifiedEntityName(livingEntity6)), () -> false, () -> true, () -> {
                if (HudClientEvents.getModifiedEntityName(hudSelectedEntity).equals(HudClientEvents.getModifiedEntityName(livingEntity6))) {
                    UnitClientEvents.clearSelectedUnits();
                    UnitClientEvents.addSelectedUnit(livingEntity6);
                } else {
                    HudClientEvents.setHudSelectedEntity(livingEntity6);
                }
            }, null, List.of(MiscUtil.fcs(MiscUtil.capitaliseAndSpace(HudClientEvents.getModifiedEntityName(livingEntity6)))));
            if (livingEntity6.m_20160_() && livingEntity6 instanceof Unit) {
                String passengerName = HudClientEvents.getSimpleEntityName(livingEntity6.m_146895_());
                button.bgIconResource = new ResourceLocation("reignofnether", "textures/mobheads/" + passengerName + ".png");
            }
            unitButtons.add(button);
        }
        if (unitButtons.size() >= 2) {
            hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX - 5, blitY - 10, iconFrameSize * buttonsPerRow + 10, iconFrameSize * 2 + 20, -1610612736));
            int buttonsRendered = 0;
            for (Button unitButton : unitButtons) {
                if (buttonsRendered >= buttonsPerRow * 2 - 1 && selUnits.size() > buttonsPerRow * 2) {
                    int n = selUnits.size() - buttonsPerRow * 2 + 1;
                    plusUnitsZone = MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), unitButton.frameResource, blitX, blitY, iconFrameSize, 0x64000000);
                    evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, "+" + n, blitX + iconFrameSize / 2, blitY + 8, 0xFFFFFF);
                    if (!((RectZone)plusUnitsZone).isMouseOver(mouseX, mouseY)) break;
                    ArrayList<FormattedCharSequence> tooltipLines = new ArrayList<FormattedCharSequence>();
                    int numUnits = 0;
                    for (int i = selUnits.size() - n; i < selUnits.size(); ++i) {
                        LivingEntity unit4 = selUnits.get(i);
                        String unitName = HudClientEvents.getModifiedEntityName(unit4);
                        String nextUnitName = null;
                        ++numUnits;
                        if (i < selUnits.size() - 1) {
                            LivingEntity nextUnit = selUnits.get(i + 1);
                            nextUnitName = HudClientEvents.getModifiedEntityName(nextUnit);
                        }
                        if (unitName.equals(nextUnitName)) continue;
                        tooltipLines.add(FormattedCharSequence.m_13714_((String)("x" + numUnits + " " + MiscUtil.capitaliseAndSpace(unitName)), (Style)Style.f_131099_));
                        numUnits = 0;
                    }
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltipLines, mouseX, mouseY);
                    break;
                }
                unitButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(unitButton);
                if (unitButton.iconResource == null) {
                    void var15_87;
                    String string = unitButton.name.substring(0, 1).toUpperCase();
                    if (unitButton.name.length() > 1) {
                        String string2 = string + unitButton.name.substring(1, 2);
                    }
                    evt.getGuiGraphics().m_280364_(HudClientEvents.MC.f_91062_, MiscUtil.fcs((String)var15_87, true), blitX + unitButton.iconSize / 2 + 4, blitY + unitButton.iconSize / 2, 0xFFFFFF);
                }
                unitButton.renderHealthBar(evt.getGuiGraphics().m_280168_());
                blitX += iconFrameSize;
                if (buttonsRendered == buttonsPerRow - 1) {
                    blitX = blitXStart;
                    blitY += iconFrameSize + 6;
                }
                ++buttonsRendered;
            }
        }
        if (selUnits.size() > 0 && SandboxClientEvents.isSandboxPlayer() && hudSelectedEntity instanceof Unit && UnitClientEvents.getPlayerToEntityRelationship(selUnits.get(0)) != Relationship.OWNED) {
            blitX = 0;
            blitY = screenHeight - iconFrameSize * 2;
            ArrayList<Button> actionButtons = new ArrayList<Button>();
            if (hudSelectedEntity instanceof AttackerUnit) {
                actionButtons.add(SandboxActionButtons.setAnchor);
                actionButtons.add(SandboxActionButtons.resetToAnchor);
                actionButtons.add(SandboxActionButtons.removeAnchor);
            }
            for (Button actionButton2 : actionButtons) {
                if (actionButton2.isHidden.get().booleanValue()) continue;
                actionButton2.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(actionButton2);
                blitX += iconFrameSize;
            }
        }
        if (selUnits.size() > 0 && UnitClientEvents.getPlayerToEntityRelationship(selUnits.get(0)) == Relationship.OWNED && (livingEntity2 = hudSelectedEntity) instanceof Unit) {
            Unit unit5 = (Unit)livingEntity2;
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            ArrayList<Button> arrayList = new ArrayList<Button>();
            if (hudSelectedEntity instanceof AttackerUnit) {
                arrayList.add(ActionButtons.attack);
            }
            if (hudSelectedEntity instanceof WorkerUnit) {
                arrayList.add(ActionButtons.buildRepair);
                arrayList.add(ActionButtons.gather);
            }
            if (unit5.canGarrison() && GarrisonableBuilding.getGarrison(unit5) == null) {
                arrayList.add(ActionButtons.garrison);
            } else if (GarrisonableBuilding.getGarrison(unit5) != null) {
                arrayList.add(ActionButtons.ungarrison);
            }
            if (!(hudSelectedEntity instanceof WorkerUnit)) {
                arrayList.add(ActionButtons.hold);
            }
            arrayList.add(ActionButtons.stop);
            plusUnitsZone = hudSelectedEntity;
            if (plusUnitsZone instanceof VillagerUnit) {
                VillagerUnit vUnit = (VillagerUnit)plusUnitsZone;
                for (Ability ability : vUnit.getAbilities()) {
                    if (!(ability instanceof CallToArmsUnit)) continue;
                    CallToArmsUnit callToArmsUnit = (CallToArmsUnit)ability;
                    arrayList.add(callToArmsUnit.getButton(Keybindings.keyV));
                }
            }
            for (Button button : arrayList) {
                LivingEntity ability;
                if (button == ActionButtons.gather && (ability = hudSelectedEntity) instanceof WorkerUnit) {
                    WorkerUnit workerUnit = (WorkerUnit)ability;
                    switch (workerUnit.getGatherResourceGoal().getTargetResourceName()) {
                        case NONE: {
                            button.iconResource = new ResourceLocation("reignofnether", "textures/icons/items/no_gather.png");
                            break;
                        }
                        case FOOD: {
                            button.iconResource = new ResourceLocation("reignofnether", "textures/icons/items/hoe.png");
                            break;
                        }
                        case WOOD: {
                            button.iconResource = new ResourceLocation("reignofnether", "textures/icons/items/axe.png");
                            break;
                        }
                        case ORE: {
                            button.iconResource = new ResourceLocation("reignofnether", "textures/icons/items/pickaxe.png");
                        }
                    }
                    String resourceName = UnitClientEvents.getSelectedUnitResourceTarget().toString();
                    String key = String.format("resources.reignofnether.%s", resourceName.toLowerCase(Locale.ENGLISH));
                    button.tooltipLines = List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.gather_resources", (Object[])new Object[]{I18n.m_118938_((String)key, (Object[])new Object[0])}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.change_target_resource", (Object[])new Object[0]), (Style)Style.f_131099_));
                }
                button.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(button);
                blitX += iconFrameSize;
            }
            blitX = 0;
            blitY = screenHeight - iconFrameSize * 2 - 4;
            if (TutorialClientEvents.isAtOrPastStage(TutorialStage.BUILD_INTRO)) {
                List<Object> abilityButtons = List.of();
                for (LivingEntity livingEntity7 : selUnits) {
                    if (livingEntity7 != hudSelectedEntity) continue;
                    abilityButtons = ((Unit)livingEntity7).getAbilityButtons();
                    break;
                }
                List<AbilityButton> list = abilityButtons.stream().filter(ab -> !(ab.ability instanceof CallToArmsUnit)).toList();
                int rowsUp = (int)Math.floor((float)(list.size() - 1) / 6.0f);
                rowsUp = Math.max(0, rowsUp);
                blitY -= iconFrameSize * rowsUp;
                int i = 0;
                for (AbilityButton abilityButton : list) {
                    Ability nextUnit = abilityButton.ability;
                    if (nextUnit instanceof HeroAbility) {
                        HeroAbility heroAbility = (HeroAbility)nextUnit;
                        if (heroAbility.hero.isRankUpMenuOpen()) {
                            Button rankUpButton = heroAbility.getRankUpButton();
                            if (rankUpButton.isHidden.get().booleanValue()) continue;
                            rankUpButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                            renderedButtons.add(rankUpButton);
                            blitX += iconFrameSize;
                            if (++i % 6 != 0) continue;
                            blitX = 0;
                            blitY += iconFrameSize;
                            continue;
                        }
                    }
                    if (((Boolean)abilityButton.isHidden.get()).booleanValue()) continue;
                    abilityButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                    renderedButtons.add(abilityButton);
                    blitX += iconFrameSize;
                    if (++i % 6 != 0) continue;
                    blitX = 0;
                    blitY += iconFrameSize;
                }
                LivingEntity abilityButton = hudSelectedEntity;
                if (abilityButton instanceof HeroUnit) {
                    HeroUnit hero = (HeroUnit)abilityButton;
                    Button rankUpMenuButton = HeroAbility.getRankUpMenuButton(hero);
                    if (!rankUpMenuButton.isHidden.get().booleanValue()) {
                        rankUpMenuButton.render(evt.getGuiGraphics(), 0, blitY - iconFrameSize, mouseX, mouseY);
                        renderedButtons.add(rankUpMenuButton);
                    }
                }
            }
        } else if (HudClientEvents.MC.f_91074_ != null && SandboxClientEvents.isSandboxPlayer(HudClientEvents.MC.f_91074_.m_7755_().getString()) && selUnits.isEmpty() && selBuildings.isEmpty()) {
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            ArrayList<Button> arrayList = new ArrayList<Button>();
            arrayList.add(SandboxClientEvents.getToggleBuildingOrUnitsButton());
            arrayList.add(SandboxClientEvents.getToggleFactionButton());
            arrayList.add(SandboxClientEvents.getToggleRelationshipButton());
            if (SandboxClientEvents.sandboxMenuType == SandboxMenuType.BUILDINGS) {
                arrayList.add(SandboxClientEvents.getToggleBuildingCheatsButton());
            } else {
                arrayList.add(SandboxClientEvents.getToggleUnitCheatsButton());
            }
            for (Button button : arrayList) {
                button.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(button);
                blitX += iconFrameSize;
            }
            blitX = 0;
            blitY = screenHeight - iconFrameSize * 2 - 4;
            List<AbilityButton> abilityButtons = switch (SandboxClientEvents.sandboxMenuType) {
                case SandboxMenuType.BUILDINGS -> SandboxClientEvents.getBuildingButtons();
                default -> SandboxClientEvents.getUnitButtons();
            };
            List<AbilityButton> list = abilityButtons.stream().filter(ab -> (Boolean)ab.isHidden.get() == false && !(ab.ability instanceof CallToArmsUnit)).toList();
            int rowsUp = (int)Math.floor((float)(list.size() - 1) / 6.0f);
            rowsUp = Math.max(0, rowsUp);
            blitY -= iconFrameSize * rowsUp;
            int i = 0;
            for (AbilityButton abilityButton : list) {
                if (((Boolean)abilityButton.isHidden.get()).booleanValue()) continue;
                abilityButton.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(abilityButton);
                blitX += iconFrameSize;
                if (++i % 6 != 0) continue;
                blitX = 0;
                blitY += iconFrameSize;
            }
        } else if (!UnitClientEvents.getSelectedUnits().isEmpty() && NonUnitClientEvents.canControlNonUnits()) {
            blitX = 0;
            blitY = screenHeight - iconFrameSize;
            ArrayList<Button> arrayList = new ArrayList<Button>();
            if (NonUnitClientEvents.canAttack(UnitClientEvents.getSelectedUnits().get(0))) {
                arrayList.add(ActionButtons.attack);
            }
            arrayList.add(ActionButtons.stop);
            for (Button button : arrayList) {
                button.render(evt.getGuiGraphics(), blitX, blitY, mouseX, mouseY);
                renderedButtons.add(button);
                blitX += iconFrameSize;
            }
        }
        Resources resources = null;
        Object var13_40 = null;
        if (!UnitClientEvents.getSelectedUnits().isEmpty() && (livingEntity = UnitClientEvents.getSelectedUnits().get(0)) instanceof Unit) {
            Unit unit6 = (Unit)livingEntity;
            String string = unit6.getOwnerName();
        }
        if (!BuildingClientEvents.getSelectedBuildings().isEmpty()) {
            String string = BuildingClientEvents.getSelectedBuildings().get((int)0).ownerName;
        }
        boolean alliedWithSelPlayer = HudClientEvents.MC.f_91074_ != null && AlliancesClient.isAllied(HudClientEvents.MC.f_91074_.m_7755_().getString(), (String)var13_44);
        boolean bl3 = bl2 = HudClientEvents.MC.f_91074_ != null && HudClientEvents.MC.f_91074_.m_7755_().getString().equals(var13_44);
        if (HudClientEvents.MC.f_91074_ != null && !bl2 && PlayerClientEvents.isRTSPlayer) {
            String string = HudClientEvents.MC.f_91074_.m_7755_().getString();
            bl = true;
        }
        if (var13_46 != null && (bl || alliedWithSelPlayer || !PlayerClientEvents.isRTSPlayer || SandboxClientEvents.isSandboxPlayer())) {
            resources = ResourcesClientEvents.getResources((String)var13_46);
        }
        blitX = 0;
        blitY = 0;
        if ((!PlayerClientEvents.isRTSPlayer || alliedWithSelPlayer || SandboxClientEvents.isSandboxPlayer()) && !bl) {
            if (resources != null) {
                evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, I18n.m_118938_((String)"hud.reignofnether.players_resources", (Object[])new Object[]{var13_46}), blitX + 5, blitY + 5, 0xFFFFFF);
            } else if (!TutorialClientEvents.isEnabled()) {
                evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, I18n.m_118938_((String)"hud.reignofnether.you_are_spectator", (Object[])new Object[0]), blitX + 5, blitY + 5, 0xFFFFFF);
                blitY += 10;
            }
            blitY += 20;
        }
        int resourceBlitYStart = blitY;
        if (resources != null) {
            for (String resourceName : new String[]{"food", "wood", "ore", "pop"}) {
                String rlPath = "";
                Object resValueStr = "";
                ResourceName resName = switch (resourceName) {
                    case "food" -> {
                        rlPath = "textures/icons/items/wheat.png";
                        resValueStr = String.valueOf(resources.food);
                        yield ResourceName.FOOD;
                    }
                    case "wood" -> {
                        rlPath = "textures/icons/items/wood.png";
                        resValueStr = String.valueOf(resources.wood);
                        yield ResourceName.WOOD;
                    }
                    case "ore" -> {
                        rlPath = "textures/icons/items/iron_ore.png";
                        resValueStr = String.valueOf(resources.ore);
                        yield ResourceName.ORE;
                    }
                    default -> {
                        rlPath = "textures/icons/items/bed.png";
                        resValueStr = UnitClientEvents.getCurrentPopulation((String)var13_46) + "/" + BuildingClientEvents.getTotalPopulationSupply((String)var13_46);
                        yield ResourceName.NONE;
                    }
                };
                hudZones.add(MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX + iconFrameSize - 1, blitY, 49, iconFrameSize, -1610612736));
                hudZones.add(MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), blitX, blitY, iconFrameSize, 0x64000000));
                MyRenderer.renderIcon(evt.getGuiGraphics(), new ResourceLocation("reignofnether", rlPath), blitX + 4, blitY + 4, iconSize);
                evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, (String)resValueStr, blitX + iconFrameSize + 24, blitY + iconSize / 2 + 1, 0xFFFFFF);
                void finalSelPlayerName = var13_46;
                int numWorkersHunting = UnitClientEvents.getAllUnits().stream().filter(arg_0 -> HudClientEvents.lambda$onDrawScreen$21((String)finalSelPlayerName, arg_0)).toList().size();
                int numWorkersAssigned = 0;
                if (resName == ResourceName.NONE) {
                    numWorkersAssigned = UnitClientEvents.getAllUnits().stream().filter(u -> u instanceof WorkerUnit && UnitClientEvents.getPlayerToEntityRelationship(u) == Relationship.OWNED).toList().size();
                } else {
                    for (LivingEntity le2 : UnitClientEvents.getAllUnits()) {
                        if (!(le2 instanceof Unit)) continue;
                        Unit u2 = (Unit)le2;
                        if (!(le2 instanceof WorkerUnit)) continue;
                        WorkerUnit wu = (WorkerUnit)le2;
                        if (!u2.getOwnerName().equals(finalSelPlayerName) || UnitClientEvents.idleWorkerIds.contains(le2.m_19879_())) continue;
                        boolean alreadyAssigned = false;
                        if (u2.getReturnResourcesGoal() != null) {
                            Resources res = Resources.getTotalResourcesFromItems(u2.getItems());
                            if (resName == ResourceName.FOOD && res.food > 0 || resName == ResourceName.WOOD && res.wood > 0 || resName == ResourceName.ORE && res.ore > 0) {
                                ++numWorkersAssigned;
                                alreadyAssigned = true;
                            }
                        }
                        if (alreadyAssigned || !wu.getGatherResourceGoal().getTargetResourceName().equals((Object)resName)) continue;
                        ++numWorkersAssigned;
                    }
                }
                if (resName == ResourceName.FOOD) {
                    numWorkersAssigned += numWorkersHunting;
                }
                hudZones.add(MyRenderer.renderIconFrameWithBg(evt.getGuiGraphics(), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), blitX + 69, blitY, iconFrameSize, 0x64000000));
                evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, String.valueOf(numWorkersAssigned), blitX + 69 + iconFrameSize / 2, blitY + iconSize / 2 + 1, 0xFFFFFF);
                blitY += iconFrameSize - 1;
            }
            blitY = resourceBlitYStart;
            for (String resourceName : new String[]{"food", "wood", "ore", "population"}) {
                String locName = I18n.m_118938_((String)("resources.reignofnether." + resourceName), (Object[])new Object[0]);
                String key = String.format("resources.reignofnether.%s", resourceName);
                List<FormattedCharSequence> tooltip = resourceName.equals("population") ? List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.max_resources", (Object[])new Object[]{I18n.m_118938_((String)key, (Object[])new Object[0]), GameruleClient.maxPopulation}), (Style)Style.f_131099_)) : List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)key, (Object[])new Object[0]), (Style)Style.f_131099_));
                if (mouseX >= blitX && mouseY >= blitY && mouseX < blitX + iconFrameSize && mouseY < blitY + iconFrameSize) {
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltip, mouseX + 5, mouseY);
                }
                if (mouseX >= blitX + 69 && mouseY >= blitY && mouseX < blitX + 69 + iconFrameSize && mouseY < blitY + iconFrameSize) {
                    List<FormattedCharSequence> tooltipWorkersAssigned;
                    if (resourceName.equals("population")) {
                        int numWorkers = UnitClientEvents.getAllUnits().stream().filter(u -> u instanceof WorkerUnit && UnitClientEvents.getPlayerToEntityRelationship(u) == Relationship.OWNED).toList().size();
                        tooltipWorkersAssigned = List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.reignofnether.total_workers", (Object[])new Object[]{numWorkers}), (Style)Style.f_131099_));
                    } else {
                        tooltipWorkersAssigned = List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)("hud.reignofnether.workers_on_" + resourceName), (Object[])new Object[0]), (Style)Style.f_131099_));
                    }
                    MyRenderer.renderTooltip(evt.getGuiGraphics(), tooltipWorkersAssigned, mouseX + 5, mouseY);
                }
                blitY += iconFrameSize - 1;
            }
        }
        if (tempMsgTicksLeft > 0 && tempMsg.length() > 0) {
            int ticksUnderFade = Math.min(tempMsgTicksLeft, 50);
            int alpha = (int)(255.0f * ((float)ticksUnderFade / 50.0f));
            evt.getGuiGraphics().m_280137_(HudClientEvents.MC.f_91062_, tempMsg, screenWidth / 2, screenHeight - iconFrameSize * 2 - 50, 0xFFFFFF + (alpha << 24));
        }
        if (tempMsgTicksLeft > 0) {
            --tempMsgTicksLeft;
        }
        blitX = 100;
        for (ControlGroup controlGroup : controlGroups) {
            controlGroup.clean();
            if (controlGroup.isEmpty()) continue;
            Button ctrlGroupButton = controlGroup.getButton();
            ctrlGroupButton.render(evt.getGuiGraphics(), blitX, 0, mouseX, mouseY);
            renderedButtons.add(ctrlGroupButton);
            blitX += iconFrameSize;
        }
        Button attackWarningButton = AttackWarningClientEvents.getWarningButton();
        if (!attackWarningButton.isHidden.get().booleanValue()) {
            attackWarningButton.render(evt.getGuiGraphics(), screenWidth - MinimapClientEvents.getMapGuiRadius() * 2 - 20 - 14, screenHeight - MinimapClientEvents.getMapGuiRadius() - 20 - 2, mouseX, mouseY);
            renderedButtons.add(attackWarningButton);
        }
        Button toggleMapSizeButton = MinimapClientEvents.getToggleSizeButton();
        if (!toggleMapSizeButton.isHidden.get().booleanValue()) {
            toggleMapSizeButton.render(evt.getGuiGraphics(), screenWidth - toggleMapSizeButton.iconSize * 2, screenHeight - toggleMapSizeButton.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(toggleMapSizeButton);
        }
        Button camSensitivityButton = MinimapClientEvents.getCamSensitivityButton();
        if (!camSensitivityButton.isHidden.get().booleanValue()) {
            camSensitivityButton.render(evt.getGuiGraphics(), screenWidth - camSensitivityButton.iconSize * 4, screenHeight - camSensitivityButton.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(camSensitivityButton);
        }
        Button mapLockButton = MinimapClientEvents.getMapLockButton();
        if (!mapLockButton.isHidden.get().booleanValue()) {
            mapLockButton.render(evt.getGuiGraphics(), screenWidth - mapLockButton.iconSize * 2, screenHeight - mapLockButton.iconSize * 4, mouseX, mouseY);
            renderedButtons.add(mapLockButton);
        }
        Button nightCirclesButton = MinimapClientEvents.getNightCirclesModeButton();
        if (!nightCirclesButton.isHidden.get().booleanValue()) {
            nightCirclesButton.render(evt.getGuiGraphics(), screenWidth - nightCirclesButton.iconSize * 4, screenHeight - nightCirclesButton.iconSize * 4, mouseX, mouseY);
            renderedButtons.add(nightCirclesButton);
        }
        Button leavesHidingButton = OrthoviewClientEvents.getLeavesHidingButton();
        if (!leavesHidingButton.isHidden.get().booleanValue()) {
            leavesHidingButton.render(evt.getGuiGraphics(), screenWidth - camSensitivityButton.iconSize * 6, screenHeight - camSensitivityButton.iconSize * 2, mouseX, mouseY);
            renderedButtons.add(leavesHidingButton);
        }
        if (!PlayerClientEvents.isRTSPlayer && !PlayerClientEvents.rtsLocked) {
            Button gamemodeButton;
            Button startPosButton = StartPosClientEvents.getPositionsButton();
            if (!startPosButton.isHidden.get().booleanValue()) {
                startPosButton.render(evt.getGuiGraphics(), screenWidth - 84, 40, mouseX, mouseY);
                renderedButtons.add(startPosButton);
            }
            Button startButton = StartPosClientEvents.getStartButton();
            if (!startButton.isHidden.get().booleanValue()) {
                startButton.render(evt.getGuiGraphics(), screenWidth - 56, 40, mouseX, mouseY);
                renderedButtons.add(startButton);
            }
            Button cancelStartButton = StartPosClientEvents.getCancelStartButton();
            if (!cancelStartButton.isHidden.get().booleanValue()) {
                cancelStartButton.render(evt.getGuiGraphics(), screenWidth - 56, 40, mouseX, mouseY);
                renderedButtons.add(cancelStartButton);
            }
            Button diffsButton = ConfigClientEvents.getDiffsButton();
            if (!diffsButton.isHidden.get().booleanValue()) {
                diffsButton.render(evt.getGuiGraphics(), screenWidth - 140, 7, mouseX, mouseY);
                renderedButtons.add(diffsButton);
            }
            if ((gamemodeButton = ClientGameModeHelper.getButton()) != null && !gamemodeButton.isHidden.get().booleanValue() && !TutorialClientEvents.isEnabled()) {
                gamemodeButton.render(evt.getGuiGraphics(), screenWidth - 112, 7, mouseX, mouseY);
                renderedButtons.add(gamemodeButton);
            }
            Button gamerulesButton = GameruleClient.getGamerulesButton();
            if (HudClientEvents.MC.f_91074_ != null && !gamerulesButton.isHidden.get().booleanValue() && !TutorialClientEvents.isEnabled()) {
                int xr = screenWidth - 112;
                int yr = 40;
                gamerulesButton.render(evt.getGuiGraphics(), xr, yr, mouseX, mouseY);
                renderedButtons.add(gamerulesButton);
                if (GameruleClient.gamerulesMenuOpen) {
                    List<Button> gameruleButtons = GameruleClient.renderGamerulesGUI(evt.getGuiGraphics(), xr, yr, mouseX, mouseY);
                    renderedButtons.addAll(gameruleButtons);
                }
            }
            if (ClientGameModeHelper.gameMode != GameMode.SANDBOX) {
                if (!StartPosClientEvents.isEnabled()) {
                    if (!StartButtons.villagerStartButton.isHidden.get().booleanValue()) {
                        StartButtons.villagerStartButton.render(evt.getGuiGraphics(), screenWidth - 84, 7, mouseX, mouseY);
                        renderedButtons.add(StartButtons.villagerStartButton);
                    }
                    if (!StartButtons.monsterStartButton.isHidden.get().booleanValue()) {
                        StartButtons.monsterStartButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 56.0f), 7, mouseX, mouseY);
                        renderedButtons.add(StartButtons.monsterStartButton);
                    }
                    if (!StartButtons.piglinStartButton.isHidden.get().booleanValue()) {
                        StartButtons.piglinStartButton.render(evt.getGuiGraphics(), screenWidth - 28, 7, mouseX, mouseY);
                        renderedButtons.add(StartButtons.piglinStartButton);
                    }
                } else {
                    if (!StartPosClientEvents.villagerReadyButton.isHidden.get().booleanValue()) {
                        StartPosClientEvents.villagerReadyButton.render(evt.getGuiGraphics(), screenWidth - 84, 7, mouseX, mouseY);
                        renderedButtons.add(StartPosClientEvents.villagerReadyButton);
                    }
                    if (!StartPosClientEvents.monsterReadyButton.isHidden.get().booleanValue()) {
                        StartPosClientEvents.monsterReadyButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 56.0f), 7, mouseX, mouseY);
                        renderedButtons.add(StartPosClientEvents.monsterReadyButton);
                    }
                    if (!StartPosClientEvents.piglinReadyButton.isHidden.get().booleanValue()) {
                        StartPosClientEvents.piglinReadyButton.render(evt.getGuiGraphics(), screenWidth - 28, 7, mouseX, mouseY);
                        renderedButtons.add(StartPosClientEvents.piglinReadyButton);
                    }
                }
            } else if (!StartButtons.sandboxStartButton.isHidden.get().booleanValue()) {
                StartButtons.sandboxStartButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 56.0f), 7, mouseX, mouseY);
                renderedButtons.add(StartButtons.sandboxStartButton);
            }
        } else if (SurvivalClientEvents.isEnabled) {
            Button nextWaveButton = SurvivalClientEvents.getNextWaveButton();
            if (!nextWaveButton.isHidden.get().booleanValue()) {
                nextWaveButton.tooltipOffsetY = 15;
                nextWaveButton.render(evt.getGuiGraphics(), screenWidth - 28, 7, mouseX, mouseY);
                renderedButtons.add(nextWaveButton);
            }
        } else if (SandboxClientEvents.isSandboxPlayer(HudClientEvents.MC.f_91074_.m_7755_().getString())) {
            Button exitButton = SandboxClientEvents.getExitSandboxButton();
            if (!exitButton.isHidden.get().booleanValue()) {
                exitButton.render(evt.getGuiGraphics(), (int)((float)screenWidth - 28.0f), 7, mouseX, mouseY);
                renderedButtons.add(exitButton);
            }
        }
        Beacon beacon = BuildingUtils.getBeacon(true);
        if (beacon != null) {
            Button beaconButton = HelperButtons.getBeaconButton(beacon.ownerName);
            if (!beaconButton.isHidden.get().booleanValue()) {
                beaconButton.tooltipOffsetY = 15;
                beaconButton.render(evt.getGuiGraphics(), screenWidth - 28, 40, mouseX, mouseY);
                renderedButtons.add(beaconButton);
            }
        }
        if (!TutorialClientEvents.helpButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.chatButton.iconSize * 2;
            int yi = 40;
            TutorialClientEvents.helpButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(TutorialClientEvents.helpButton);
        }
        if (!HelperButtons.chatButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.chatButton.iconSize * 2;
            int yi = 70;
            HelperButtons.chatButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(HelperButtons.chatButton);
        }
        if (!HelperButtons.armyButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.armyButton.iconSize * 2;
            int yi = 100;
            HelperButtons.armyButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            renderedButtons.add(HelperButtons.armyButton);
        }
        if (!HelperButtons.idleWorkerButton.isHidden.get().booleanValue()) {
            int xi = screenWidth - HelperButtons.idleWorkerButton.iconSize * 2;
            int yi = 130;
            HelperButtons.idleWorkerButton.render(evt.getGuiGraphics(), xi, yi, mouseX, mouseY);
            evt.getGuiGraphics().m_280488_(HudClientEvents.MC.f_91062_, String.valueOf(UnitClientEvents.idleWorkerIds.size()), xi + 2, yi + HelperButtons.idleWorkerButton.iconSize - 1, 0xFFFFFF);
            renderedButtons.add(HelperButtons.idleWorkerButton);
        }
        for (Button button : renderedButtons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            button.renderTooltip(evt.getGuiGraphics(), mouseX, mouseY);
        }
        TutorialClientEvents.checkAndRenderNextAction(evt.getGuiGraphics(), renderedButtons);
    }

    public static boolean isMouseOverAnyButton() {
        for (Button button : renderedButtons) {
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseOverAnyButtonOrHud() {
        for (RectZone hudZone : hudZones) {
            if (!hudZone.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        if (MinimapClientEvents.isPointInsideMinimap(mouseX, mouseY)) {
            return true;
        }
        return HudClientEvents.isMouseOverAnyButton();
    }

    @SubscribeEvent
    public static void onMousePress(ScreenEvent.MouseButtonPressed.Post evt) {
        for (Button button : renderedButtons) {
            if (evt.getButton() == 0) {
                button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), true);
                continue;
            }
            if (evt.getButton() != 1) continue;
            button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), false);
        }
        if (evt.getButton() == 0) {
            mouseLeftDownX = (int)evt.getMouseX();
            mouseLeftDownY = (int)evt.getMouseY();
        }
    }

    @SubscribeEvent
    public static void onKeyRelease(ScreenEvent.KeyReleased.Post evt) {
        if (HudClientEvents.MC.f_91080_ == null || !HudClientEvents.MC.f_91080_.m_96636_().getString().contains("topdowngui_container")) {
            return;
        }
        for (Button button : renderedButtons) {
            button.checkPressed(evt.getKeyCode());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled()) {
            portraitRendererUnit.tickAnimation();
        }
        if (MiscUtil.isLeftClickDown(MC)) {
            if (buildingPortraitZone != null && buildingPortraitZone.isMouseOver(mouseX, mouseY) && buildingPortraitZone.isMouseOver(mouseLeftDownX, mouseLeftDownY) && HudClientEvents.MC.f_91074_ != null && hudSelectedBuilding != null) {
                BlockPos pos = HudClientEvents.hudSelectedBuilding.centrePos;
                OrthoviewClientEvents.centreCameraOnPos(pos);
            } else if (unitPortraitZone != null && unitPortraitZone.isMouseOver(mouseX, mouseY) && unitPortraitZone.isMouseOver(mouseLeftDownX, mouseLeftDownY) && HudClientEvents.MC.f_91074_ != null) {
                OrthoviewClientEvents.centreCameraOnPos(hudSelectedEntity.m_20182_());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderLivingEntity(RenderLivingEvent.Post<? extends LivingEntity, ? extends Model> evt) {
        if (hudSelectedEntity != null && hudSelectedEntity.m_213877_()) {
            hudSelectedEntity = null;
        }
        ArrayList<LivingEntity> units = UnitClientEvents.getSelectedUnits();
        units.sort(Comparator.comparing(HudClientEvents::getSimpleEntityName));
        if (units.size() <= 0) {
            HudClientEvents.setHudSelectedEntity(null);
        } else if (hudSelectedEntity == null || units.size() == 1 || !units.contains(hudSelectedEntity)) {
            HudClientEvents.setHudSelectedEntity(units.get(0));
        }
        if (hudSelectedEntity == null) {
            HudClientEvents.portraitRendererUnit.model = null;
            HudClientEvents.portraitRendererUnit.renderer = null;
        } else if (evt.getEntity() == hudSelectedEntity) {
            HudClientEvents.portraitRendererUnit.model = evt.getRenderer().m_7200_();
            HudClientEvents.portraitRendererUnit.renderer = evt.getRenderer();
        }
    }

    @SubscribeEvent
    public static void onRenderNamePlate(RenderNameTagEvent evt) {
    }

    @SubscribeEvent
    public static void onKeyPress(ScreenEvent.KeyPressed.Pre evt) {
        if (!(HudClientEvents.MC.f_91080_ instanceof TopdownGui)) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled()) {
            for (Keybinding numKey : Keybindings.nums) {
                if (numKey.key != evt.getKeyCode()) continue;
                evt.setCanceled(true);
            }
        }
        if (evt.getKeyCode() == Keybindings.deselect.key) {
            UnitClientEvents.clearSelectedUnits();
            BuildingClientEvents.clearSelectedBuildings();
            BuildingClientEvents.setBuildingToPlace(null);
        }
        if (controlGroups.size() < Keybindings.nums.length) {
            controlGroups.clear();
            for (Keybinding keybinding : Keybindings.nums) {
                controlGroups.add(new ControlGroup());
            }
        }
        for (Keybinding keybinding : Keybindings.nums) {
            int index = Integer.parseInt(keybinding.buttonLabel);
            if (index < 0 || index >= controlGroups.size() || !Keybindings.ctrlMod.isDown() || evt.getKeyCode() != keybinding.key) continue;
            controlGroups.get(index).saveFromSelected(keybinding);
        }
        if (OrthoviewClientEvents.isEnabled() && evt.getKeyCode() == Keybindings.chat.key) {
            MC.m_91152_((Screen)new ChatScreen(""));
        }
        if (evt.getKeyCode() == Keybindings.tab.key) {
            HudClientEvents.cycleUnitSubgroups();
            HudClientEvents.cycleBuildingSubgroups();
        }
    }

    private static void cycleUnitSubgroups() {
        ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>(UnitClientEvents.getSelectedUnits().stream().filter(e -> e instanceof Unit).sorted(Comparator.comparing(HudClientEvents::getSimpleEntityName)).toList());
        if (entities.isEmpty()) {
            return;
        }
        if (Keybindings.shiftMod.isDown()) {
            Collections.reverse(entities);
        }
        if (hudSelectedEntity != null) {
            String hudSelectedEntityName = HudClientEvents.getModifiedEntityName(hudSelectedEntity);
            String lastEntityName = "";
            boolean cycled = false;
            for (LivingEntity entity : entities) {
                String currentEntityName = HudClientEvents.getModifiedEntityName(entity);
                if (lastEntityName.equals(hudSelectedEntityName) && !currentEntityName.equals(lastEntityName)) {
                    HudClientEvents.setHudSelectedEntity(entity);
                    cycled = true;
                    break;
                }
                lastEntityName = currentEntityName;
            }
            if (!cycled) {
                HudClientEvents.setHudSelectedEntity((LivingEntity)entities.get(0));
            } else {
                HudClientEvents.setLowestCdHudEntity();
            }
        }
    }

    private static void cycleBuildingSubgroups() {
        ArrayList<Building> buildings = new ArrayList<Building>(BuildingClientEvents.getSelectedBuildings().stream().sorted(Comparator.comparing(b -> b.name)).toList());
        if (buildings.isEmpty()) {
            return;
        }
        if (Keybindings.shiftMod.isDown()) {
            Collections.reverse(buildings);
        }
        if (hudSelectedBuilding != null) {
            String hudSelectedBuildingName = HudClientEvents.hudSelectedBuilding.name;
            String lastBuildingName = "";
            boolean cycled = false;
            for (Building building : buildings) {
                String currentBuildingName = building.name;
                if (lastBuildingName.equals(hudSelectedBuildingName) && !currentBuildingName.equals(lastBuildingName)) {
                    hudSelectedBuilding = building;
                    cycled = true;
                    break;
                }
                lastBuildingName = currentBuildingName;
            }
            if (!cycled) {
                hudSelectedBuilding = (Building)buildings.get(0);
            }
        }
    }

    public static void convertControlGroups(int[] oldUnitIds, int[] newUnitIds) {
        if (HudClientEvents.MC.f_91073_ == null) {
            return;
        }
        for (ControlGroup group : controlGroups) {
            int j;
            int i;
            block1: for (i = 0; i < oldUnitIds.length; ++i) {
                for (j = 0; j < group.entityIds.size(); ++j) {
                    if (group.entityIds.get(j) != oldUnitIds[i]) continue;
                    group.entityIds.add(j, newUnitIds[i]);
                    continue block1;
                }
            }
            for (i = 0; i < oldUnitIds.length; ++i) {
                j = 0;
                while (j < oldUnitIds.length) {
                    int k = j++;
                    group.entityIds.removeIf(id -> id == oldUnitIds[k]);
                }
            }
        }
    }
}

