/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin;

import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    public LivingEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")}, cancellable=true)
    protected void onChangedBlock(BlockPos pPos, CallbackInfo ci) {
        Entity entity = this.m_9236_().m_6815_(this.m_19879_());
        if (!this.m_9236_().m_5776_() && entity instanceof Unit) {
            Unit unit = (Unit)entity;
            if (SurvivalServerEvents.isEnabled() && "Enemy".equals(unit.getOwnerName())) {
                ci.cancel();
                this.FrostWalkerOnEntityMoved((LivingEntity)entity, this.m_9236_(), pPos, 1);
            }
        }
    }

    private void FrostWalkerOnEntityMoved(LivingEntity pLiving, Level pLevel, BlockPos pPos, int pLevelConflicting) {
        if (pLiving.m_20096_()) {
            float f = Math.min(16, 2 + pLevelConflicting);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            Iterator var7 = BlockPos.m_121940_((BlockPos)pPos.m_7918_((int)(-f), -1, (int)(-f)), (BlockPos)pPos.m_7918_((int)f, -1, (int)f)).iterator();
            while (true) {
                if (!var7.hasNext()) {
                    return;
                }
                BlockPos blockpos = (BlockPos)var7.next();
                if (!blockpos.m_203195_((Position)pLiving.m_20182_(), (double)f)) continue;
                blockpos$mutableblockpos.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
                BlockState blockstate1 = pLevel.m_8055_((BlockPos)blockpos$mutableblockpos);
                if (!blockstate1.m_60795_()) continue;
                BlockState blockstate2 = pLevel.m_8055_(blockpos);
                boolean isFull = blockstate2.m_60734_() == Blocks.f_49990_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
                BlockState iceState = Blocks.f_50449_.m_49966_();
                if (blockstate2.m_60819_().m_205070_(FluidTags.f_13131_) && isFull && iceState.m_60710_((LevelReader)pLevel, blockpos) && pLevel.m_45752_(iceState, blockpos, CollisionContext.m_82749_()) && !ForgeEventFactory.onBlockPlace((Entity)pLiving, (BlockSnapshot)BlockSnapshot.create((ResourceKey)pLevel.m_46472_(), (LevelAccessor)pLevel, (BlockPos)blockpos), (Direction)Direction.UP)) {
                    pLevel.m_46597_(blockpos, iceState);
                    pLevel.m_186460_(blockpos, Blocks.f_50449_, Mth.m_216271_((RandomSource)pLiving.m_217043_(), (int)60, (int)120));
                }
                isFull = blockstate2.m_60734_() == Blocks.f_49991_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
                BlockState magmaState = Blocks.f_50134_.m_49966_();
                if (!blockstate2.m_60819_().m_205070_(FluidTags.f_13132_) || !isFull || !magmaState.m_60710_((LevelReader)pLevel, blockpos) || !pLevel.m_45752_(magmaState, blockpos, CollisionContext.m_82749_()) || ForgeEventFactory.onBlockPlace((Entity)pLiving, (BlockSnapshot)BlockSnapshot.create((ResourceKey)pLevel.m_46472_(), (LevelAccessor)pLevel, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
                pLevel.m_46597_(blockpos, magmaState);
                pLevel.m_186460_(blockpos, Blocks.f_50134_, Mth.m_216271_((RandomSource)pLiving.m_217043_(), (int)60, (int)120));
            }
        }
    }
}

