/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.research.ResearchClientboundPacket;
import com.solegendary.reignofnether.research.ResearchSaveData;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ResearchServerEvents {
    private static final ArrayList<Pair<String, String>> researchItems = new ArrayList();
    private static ServerLevel serverLevel = null;
    private static final ArrayList<Pair<String, String>> cheatItems = new ArrayList();

    public static void saveResearch() {
        if (serverLevel != null) {
            ResearchSaveData researchData = ResearchSaveData.getInstance((LevelAccessor)serverLevel);
            researchData.researchItems.clear();
            researchData.researchItems.addAll(researchItems);
            researchData.save();
            serverLevel.m_8895_().m_78151_();
        }
    }

    @SubscribeEvent
    public static void loadResearch(ServerStartedEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            serverLevel = level;
            ResearchSaveData researchData = ResearchSaveData.getInstance((LevelAccessor)level);
            researchItems.clear();
            researchItems.addAll(researchData.researchItems);
            for (Pair<String, String> researchItem : researchItems) {
                ResearchServerEvents.syncResearch((String)researchItem.getFirst());
            }
            ReignOfNether.LOGGER.info("loaded " + researchItems.size() + " researchItems in serverevents");
        }
    }

    public static void removeAllResearch() {
        researchItems.clear();
        ResearchServerEvents.saveResearch();
    }

    public static void removeAllResearchFor(String playerName) {
        researchItems.removeIf(r -> ((String)r.getFirst()).equals(playerName));
        ResearchServerEvents.saveResearch();
    }

    public static void syncResearch(String playerName) {
        for (Pair<String, String> researchItem : researchItems) {
            if (!playerName.equals(researchItem.getFirst())) continue;
            ResearchClientboundPacket.addResearch((String)researchItem.getFirst(), (String)researchItem.getSecond());
        }
    }

    public static void addResearch(String playerName, String researchItemName) {
        researchItems.add((Pair<String, String>)new Pair((Object)playerName, (Object)researchItemName));
        ResearchServerEvents.saveResearch();
    }

    public static void removeResearch(String playerName, String researchItemName) {
        researchItems.removeIf(p -> ((String)p.getFirst()).equals(playerName) && ((String)p.getSecond()).equals(researchItemName));
        ResearchServerEvents.saveResearch();
    }

    public static boolean playerHasResearch(String playerName, String researchItemName) {
        if (ResearchServerEvents.playerHasCheat(playerName, "medievalman")) {
            return true;
        }
        for (Pair<String, String> researchItem : researchItems) {
            if (!((String)researchItem.getFirst()).equals(playerName) || !((String)researchItem.getSecond()).equals(researchItemName)) continue;
            return true;
        }
        return false;
    }

    public static void removeAllCheats() {
        cheatItems.clear();
    }

    public static void removeAllCheatsFor(String playerName) {
        cheatItems.removeIf(r -> ((String)r.getFirst()).equals(playerName));
    }

    public static void syncCheats(String playerName) {
        for (Pair<String, String> cheatItem : cheatItems) {
            if (!playerName.equals(cheatItem.getFirst())) continue;
            ResearchClientboundPacket.addCheat((String)cheatItem.getFirst(), (String)cheatItem.getSecond());
        }
    }

    public static void addCheat(String playerName, String cheatItemName) {
        cheatItems.add((Pair<String, String>)new Pair((Object)playerName, (Object)cheatItemName));
    }

    public static void removeCheat(String playerName, String cheatItemName) {
        cheatItems.removeIf(p -> ((String)p.getFirst()).equals(playerName) && ((String)p.getSecond()).equals(cheatItemName));
    }

    public static boolean playerHasCheat(String playerName, String cheatItemName) {
        for (Pair<String, String> cheatItem : cheatItems) {
            if (!((String)cheatItem.getFirst()).equals(playerName) || !((String)cheatItem.getSecond()).equals(cheatItemName)) continue;
            return true;
        }
        return false;
    }
}

