/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchBeaconLevel2
extends ProductionItem {
    public static final String itemName = "Gold Beacon";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_BEACON_LEVEL2;

    public ResearchBeaconLevel2(ProductionBuilding building) {
        super(building, ResearchBeaconLevel2.cost.ticks);
        this.onComplete = level -> {
            ProductionBuilding patt1277$temp = this.building;
            if (patt1277$temp instanceof Beacon) {
                Beacon beacon = (Beacon)patt1277$temp;
                beacon.changeStructure(2);
                if (!level.m_5776_()) {
                    beacon.sendWarning("upgraded_warning");
                }
            }
        };
        this.foodCost = ResearchBeaconLevel2.cost.food;
        this.woodCost = ResearchBeaconLevel2.cost.wood;
        this.oreCost = ResearchBeaconLevel2.cost.ore;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public static Button getStartButton(ProductionBuilding prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/gold_block.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> {
            Beacon beacon;
            return ProductionItem.itemIsBeingProduced(itemName, prodBuilding.ownerName) || prodBuilding instanceof Beacon && (beacon = (Beacon)prodBuilding).getUpgradeLevel() != 1;
        }, () -> true, () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, itemName), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.beacon_level2", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.beacon_level2.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.beacon_level_win", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/gold_block.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, itemName, first), null, null);
    }
}

