/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.building.buildings.monsters.Laboratory;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchLabLightningRod
extends ProductionItem {
    public static final String itemName = "Lightning Rod";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_LAB_LIGHTNING_ROD;

    public ResearchLabLightningRod(ProductionBuilding building) {
        super(building, ResearchLabLightningRod.cost.ticks);
        this.onComplete = level -> {
            ProductionBuilding patt1438$temp = this.building;
            if (patt1438$temp instanceof Laboratory) {
                Laboratory lab = (Laboratory)patt1438$temp;
                lab.changeStructure("laboratory_lightning");
            }
        };
        this.foodCost = ResearchLabLightningRod.cost.food;
        this.woodCost = ResearchLabLightningRod.cost.wood;
        this.oreCost = ResearchLabLightningRod.cost.ore;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public static Button getStartButton(ProductionBuilding prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("reignofnether", "textures/icons/items/lightbulb_off.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> {
            Laboratory lab;
            return ProductionItem.itemIsBeingProduced(itemName, prodBuilding) || prodBuilding instanceof Laboratory && (lab = (Laboratory)prodBuilding).getUpgradeLevel() > 0;
        }, () -> BuildingClientEvents.hasFinishedBuilding("Dungeon"), () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, itemName), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.lightning_rod", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.lightning_rod.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.lightning_rod.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.lightning_rod.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("reignofnether", "textures/icons/items/lightbulb_off.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, itemName, first), null, null);
    }
}

