/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class ResearchPoisonSpiders
extends ProductionItem {
    public static final String itemName = "Poison Spiders";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_POISON_SPIDERS;

    public ResearchPoisonSpiders(ProductionBuilding building) {
        super(building, ResearchPoisonSpiders.cost.ticks);
        this.onComplete = level -> {
            if (level.m_5776_()) {
                ResearchClient.addResearch(this.building.ownerName, itemName);
            } else {
                ResearchServerEvents.addResearch(this.building.ownerName, itemName);
                UnitServerEvents.convertAllToUnit(this.building.ownerName, (ServerLevel)level, entity -> {
                    SpiderUnit zUnit;
                    return entity instanceof SpiderUnit && (zUnit = (SpiderUnit)entity).getOwnerName().equals(building.ownerName);
                }, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get()));
            }
        };
        this.foodCost = ResearchPoisonSpiders.cost.food;
        this.woodCost = ResearchPoisonSpiders.cost.wood;
        this.oreCost = ResearchPoisonSpiders.cost.ore;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public static Button getStartButton(ProductionBuilding prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("reignofnether", "textures/mobheads/cave_spider.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> ProductionItem.itemIsBeingProduced(itemName, prodBuilding.ownerName) || ResearchClient.hasResearch(itemName), () -> BuildingClientEvents.hasFinishedBuilding("Spider Lair"), () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, itemName), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.poison_spiders", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.poison_spiders.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.poison_spiders.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.poison_spiders.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("reignofnether", "textures/mobheads/cave_spider.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, itemName, first), null, null);
    }
}

