/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingClientboundPacket;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchPortalForCivilian
extends ProductionItem {
    public static final String itemName = "Civilian Portal";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_CIVILIAN_PORTAL;

    public ResearchPortalForCivilian(ProductionBuilding building) {
        super(building, ResearchPortalForCivilian.cost.ticks);
        this.onComplete = level -> {
            ProductionBuilding patt1367$temp = this.building;
            if (patt1367$temp instanceof Portal) {
                Portal portal = (Portal)patt1367$temp;
                if (!level.m_5776_()) {
                    portal.changeStructure(Portal.PortalType.CIVILIAN);
                    BuildingClientboundPacket.changePortal(this.building.originPos, Portal.PortalType.CIVILIAN.name());
                }
            }
        };
        this.foodCost = ResearchPortalForCivilian.cost.food;
        this.woodCost = ResearchPortalForCivilian.cost.wood;
        this.oreCost = ResearchPortalForCivilian.cost.ore;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public static Button getStartButton(ProductionBuilding prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/cyan_glazed_terracotta.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> {
            Portal portal;
            return prodBuilding.productionQueue.size() > 0 || prodBuilding instanceof Portal && (portal = (Portal)prodBuilding).getUpgradeLevel() > 0;
        }, () -> true, () -> {
            if (prodBuilding.productionQueue.isEmpty()) {
                BuildingServerboundPacket.startProduction(prodBuilding.originPos, itemName);
            }
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.civilian_portal", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.civilian_portal.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.civilian_portal.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/cyan_glazed_terracotta.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, itemName, first), null, null);
    }
}

