/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.ProductionBuilding;
import com.solegendary.reignofnether.building.ProductionItem;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public class ResearchSpiderWebs
extends ProductionItem {
    public static final String itemName = "Sticky Webbing";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_SPIDER_JOCKEYS;

    public ResearchSpiderWebs(ProductionBuilding building) {
        super(building, ResourceCosts.RESEARCH_SPIDER_JOCKEYS.ticks);
        this.onComplete = level -> {
            if (level.m_5776_()) {
                ResearchClient.addResearch(this.building.ownerName, itemName);
            } else {
                ResearchServerEvents.addResearch(this.building.ownerName, itemName);
            }
        };
        this.foodCost = ResearchSpiderWebs.cost.food;
        this.woodCost = ResearchSpiderWebs.cost.wood;
        this.oreCost = ResearchSpiderWebs.cost.ore;
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    public static Button getStartButton(ProductionBuilding prodBuilding, Keybinding hotkey) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/cobweb.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), hotkey, () -> false, () -> ProductionItem.itemIsBeingProduced(itemName, prodBuilding.ownerName) || ResearchClient.hasResearch(itemName), () -> true, () -> BuildingServerboundPacket.startProduction(prodBuilding.originPos, itemName), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.sticky_webbing", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.sticky_webbing.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.sticky_webbing.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.sticky_webbing.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public Button getCancelButton(ProductionBuilding prodBuilding, boolean first) {
        return new Button(itemName, 14, new ResourceLocation("minecraft", "textures/block/cobweb.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame_bronze.png"), null, () -> false, () -> false, () -> true, () -> BuildingServerboundPacket.cancelProduction(prodBuilding.minCorner, itemName, first), null, null);
    }
}

