/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sandbox;

import com.solegendary.reignofnether.building.buildings.neutral.CapturableBeacon;
import com.solegendary.reignofnether.building.buildings.neutral.EndPortal;
import com.solegendary.reignofnether.building.buildings.neutral.HealingFountain;
import com.solegendary.reignofnether.building.buildings.neutral.NeutralTransportPortal;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerboundPacket;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxMenuType;
import com.solegendary.reignofnether.sandbox.SandboxServerboundPacket;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.units.monsters.CreeperProd;
import com.solegendary.reignofnether.unit.units.monsters.DrownedProd;
import com.solegendary.reignofnether.unit.units.monsters.HuskProd;
import com.solegendary.reignofnether.unit.units.monsters.NecromancerProd;
import com.solegendary.reignofnether.unit.units.monsters.PoisonSpiderProd;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonProd;
import com.solegendary.reignofnether.unit.units.monsters.SlimeProd;
import com.solegendary.reignofnether.unit.units.monsters.SpiderProd;
import com.solegendary.reignofnether.unit.units.monsters.StrayProd;
import com.solegendary.reignofnether.unit.units.monsters.WardenProd;
import com.solegendary.reignofnether.unit.units.monsters.ZoglinProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombiePiglinProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombieProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerProd;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerUnit;
import com.solegendary.reignofnether.unit.units.neutral.EndermanProd;
import com.solegendary.reignofnether.unit.units.neutral.GrizzlyBearProd;
import com.solegendary.reignofnether.unit.units.neutral.LlamaProd;
import com.solegendary.reignofnether.unit.units.neutral.PandaProd;
import com.solegendary.reignofnether.unit.units.neutral.PolarBearProd;
import com.solegendary.reignofnether.unit.units.neutral.WolfProd;
import com.solegendary.reignofnether.unit.units.piglins.BlazeProd;
import com.solegendary.reignofnether.unit.units.piglins.BruteProd;
import com.solegendary.reignofnether.unit.units.piglins.GhastProd;
import com.solegendary.reignofnether.unit.units.piglins.GruntProd;
import com.solegendary.reignofnether.unit.units.piglins.GruntUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterProd;
import com.solegendary.reignofnether.unit.units.piglins.HoglinProd;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeProd;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantProd;
import com.solegendary.reignofnether.unit.units.piglins.WitherSkeletonProd;
import com.solegendary.reignofnether.unit.units.villagers.EvokerProd;
import com.solegendary.reignofnether.unit.units.villagers.IronGolemProd;
import com.solegendary.reignofnether.unit.units.villagers.PillagerProd;
import com.solegendary.reignofnether.unit.units.villagers.RavagerProd;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardProd;
import com.solegendary.reignofnether.unit.units.villagers.VillagerProd;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.unit.units.villagers.VindicatorProd;
import com.solegendary.reignofnether.unit.units.villagers.WitchProd;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SandboxClientEvents {
    private static Faction faction = Faction.NONE;
    public static Relationship relationship = Relationship.OWNED;
    public static SandboxMenuType sandboxMenuType = SandboxMenuType.BUILDINGS;
    private static final Minecraft MC = Minecraft.m_91087_();
    public static String spawnUnitName = "";

    public static Faction getFaction() {
        return faction;
    }

    public static boolean isSandboxPlayer(String playerName) {
        return SandboxClientEvents.MC.f_91074_ != null && playerName.equals(SandboxClientEvents.MC.f_91074_.m_7755_().getString()) && PlayerClientEvents.isRTSPlayer && ClientGameModeHelper.gameMode == GameMode.SANDBOX;
    }

    public static boolean isSandboxPlayer() {
        return PlayerClientEvents.isRTSPlayer && ClientGameModeHelper.gameMode == GameMode.SANDBOX;
    }

    public static List<AbilityButton> getNeutralBuildingButtons() {
        return List.of(CapturableBeacon.getBuildButton(Keybindings.keyQ), HealingFountain.getBuildButton(Keybindings.keyW), EndPortal.getBuildButton(Keybindings.keyE), NeutralTransportPortal.getBuildButton(Keybindings.keyR));
    }

    public static List<AbilityButton> getBuildingButtons() {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> VillagerUnit.getBuildingButtons();
            case Faction.MONSTERS -> ZombieVillagerUnit.getBuildingButtons();
            case Faction.PIGLINS -> GruntUnit.getBuildingButtons();
            case Faction.NONE -> SandboxClientEvents.getNeutralBuildingButtons();
        };
    }

    public static List<AbilityButton> getUnitButtons() {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> List.of(VillagerProd.getPlaceButton(), VindicatorProd.getPlaceButton(), PillagerProd.getPlaceButton(), IronGolemProd.getPlaceButton(), WitchProd.getPlaceButton(), EvokerProd.getPlaceButton(), RavagerProd.getPlaceButton(), RoyalGuardProd.getPlaceButton());
            case Faction.MONSTERS -> List.of(ZombieVillagerProd.getPlaceButton(), ZombieProd.getPlaceButton(), DrownedProd.getPlaceButton(), HuskProd.getPlaceButton(), SkeletonProd.getPlaceButton(), StrayProd.getPlaceButton(), SpiderProd.getPlaceButton(), PoisonSpiderProd.getPlaceButton(), CreeperProd.getPlaceButton(), SlimeProd.getPlaceButton(), WardenProd.getPlaceButton(), NecromancerProd.getPlaceButton(), ZombiePiglinProd.getPlaceButton(), ZoglinProd.getPlaceButton());
            case Faction.PIGLINS -> List.of(GruntProd.getPlaceButton(), BruteProd.getPlaceButton(), HeadhunterProd.getPlaceButton(), HoglinProd.getPlaceButton(), BlazeProd.getPlaceButton(), WitherSkeletonProd.getPlaceButton(), MagmaCubeProd.getPlaceButton(), GhastProd.getPlaceButton(), PiglinMerchantProd.getPlaceButton());
            case Faction.NONE -> List.of(EndermanProd.getPlaceButton(), PolarBearProd.getPlaceButton(), GrizzlyBearProd.getPlaceButton(), PandaProd.getPlaceButton(), WolfProd.getPlaceButton(), LlamaProd.getPlaceButton());
        };
    }

    private static String getFactionName() {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> I18n.m_118938_((String)"hud.faction.reignofnether.villager", (Object[])new Object[0]);
            case Faction.MONSTERS -> I18n.m_118938_((String)"hud.faction.reignofnether.monster", (Object[])new Object[0]);
            case Faction.PIGLINS -> I18n.m_118938_((String)"hud.faction.reignofnether.piglin", (Object[])new Object[0]);
            case Faction.NONE -> I18n.m_118938_((String)"hud.faction.reignofnether.neutral", (Object[])new Object[0]);
        };
    }

    private static String getRelationshipName() {
        return switch (relationship) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> I18n.m_118938_((String)"hud.relationship.reignofnether.owned", (Object[])new Object[0]);
            case Relationship.FRIENDLY -> I18n.m_118938_((String)"hud.relationship.reignofnether.allied", (Object[])new Object[0]);
            case Relationship.NEUTRAL -> I18n.m_118938_((String)"hud.relationship.reignofnether.neutral", (Object[])new Object[0]);
            case Relationship.HOSTILE -> I18n.m_118938_((String)"hud.relationship.reignofnether.enemy", (Object[])new Object[0]);
        };
    }

    public static Button getToggleFactionButton() {
        return new Button("Toggle Faction", Button.itemIconSize, switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> new ResourceLocation("reignofnether", "textures/mobheads/villager.png");
            case Faction.MONSTERS -> new ResourceLocation("reignofnether", "textures/mobheads/creeper.png");
            case Faction.PIGLINS -> new ResourceLocation("reignofnether", "textures/mobheads/grunt.png");
            case Faction.NONE -> new ResourceLocation("reignofnether", "textures/mobheads/sheep.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            switch (faction) {
                case VILLAGERS: {
                    faction = Faction.MONSTERS;
                    break;
                }
                case MONSTERS: {
                    faction = Faction.PIGLINS;
                    break;
                }
                case PIGLINS: {
                    faction = Faction.NONE;
                    break;
                }
                case NONE: {
                    faction = Faction.VILLAGERS;
                }
            }
        }, () -> {
            switch (faction) {
                case VILLAGERS: {
                    faction = Faction.NONE;
                    break;
                }
                case MONSTERS: {
                    faction = Faction.VILLAGERS;
                    break;
                }
                case PIGLINS: {
                    faction = Faction.MONSTERS;
                    break;
                }
                case NONE: {
                    faction = Faction.PIGLINS;
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.villager", (Object[])new Object[0]), faction == Faction.VILLAGERS), MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.monster", (Object[])new Object[0]), faction == Faction.MONSTERS), MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.piglin", (Object[])new Object[0]), faction == Faction.PIGLINS), MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.neutral", (Object[])new Object[0]), faction == Faction.NONE), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.faction_button2", (Object[])new Object[0]))));
    }

    public static Button getToggleRelationshipButton() {
        return new Button("Toggle Relationship", Button.itemIconSize, switch (relationship) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> new ResourceLocation("minecraft", "textures/block/lime_wool.png");
            case Relationship.FRIENDLY -> new ResourceLocation("minecraft", "textures/block/blue_wool.png");
            case Relationship.NEUTRAL -> new ResourceLocation("minecraft", "textures/block/yellow_wool.png");
            case Relationship.HOSTILE -> new ResourceLocation("minecraft", "textures/block/red_wool.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            switch (relationship) {
                default: {
                    relationship = Relationship.NEUTRAL;
                    break;
                }
                case NEUTRAL: {
                    relationship = Relationship.HOSTILE;
                    break;
                }
                case HOSTILE: {
                    relationship = Relationship.OWNED;
                }
            }
        }, () -> {
            switch (relationship) {
                default: {
                    relationship = Relationship.HOSTILE;
                    break;
                }
                case NEUTRAL: {
                    relationship = Relationship.OWNED;
                    break;
                }
                case HOSTILE: {
                    relationship = Relationship.NEUTRAL;
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.relationship_button1", (Object[])new Object[]{SandboxClientEvents.getRelationshipName()})), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.relationship_button2", (Object[])new Object[0]))));
    }

    public static Button getToggleBuildingOrUnitsButton() {
        ResourceLocation resourceLocation = switch (sandboxMenuType) {
            default -> throw new IncompatibleClassChangeError();
            case SandboxMenuType.BUILDINGS -> new ResourceLocation("minecraft", "textures/block/crafting_table_front.png");
            case SandboxMenuType.UNITS -> new ResourceLocation("minecraft", "textures/item/spawn_egg.png");
            case SandboxMenuType.OTHER -> new ResourceLocation("minecraft", "textures/item/spawn_egg.png");
        };
        Keybinding keybinding = null;
        Supplier<Boolean> supplier = () -> false;
        Supplier<Boolean> supplier2 = () -> false;
        Supplier<Boolean> supplier3 = () -> true;
        Runnable runnable = () -> {
            switch (sandboxMenuType) {
                case BUILDINGS: {
                    sandboxMenuType = SandboxMenuType.UNITS;
                    break;
                }
                case UNITS: {
                    sandboxMenuType = SandboxMenuType.BUILDINGS;
                    break;
                }
                case OTHER: {
                    sandboxMenuType = SandboxMenuType.BUILDINGS;
                }
            }
        };
        return new Button("Toggle Building or Units", Button.itemIconSize, resourceLocation, keybinding, supplier, supplier2, supplier3, runnable, null, List.of(switch (sandboxMenuType) {
            default -> throw new IncompatibleClassChangeError();
            case SandboxMenuType.BUILDINGS -> MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button_buildings", (Object[])new Object[0]));
            case SandboxMenuType.UNITS -> MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button_units", (Object[])new Object[0]));
            case SandboxMenuType.OTHER -> MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button_other", (Object[])new Object[0]));
        }, MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button1", (Object[])new Object[0]))));
    }

    public static Button getToggleBuildingCheatsButton() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ == null) {
            return null;
        }
        boolean hasCheats = ResearchClient.hasCheat("warpten") && ResearchClient.hasCheat("modifythephasevariance");
        String playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        return new Button("Toggle Building Cheats", Button.itemIconSize, hasCheats ? new ResourceLocation("reignofnether", "textures/icons/blocks/command_block_side.png") : new ResourceLocation("reignofnether", "textures/icons/blocks/command_block_side_dark.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (hasCheats) {
                ResearchServerboundPacket.removeCheat(playerName, "warpten");
                ResearchServerboundPacket.removeCheat(playerName, "modifythephasevariance");
            } else {
                ResearchServerboundPacket.addCheat(playerName, "warpten");
                ResearchServerboundPacket.addCheat(playerName, "modifythephasevariance");
            }
        }, null, List.of(hasCheats ? MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats_off", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats2", (Object[])new Object[0]))));
    }

    public static Button getToggleUnitCheatsButton() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ == null) {
            return null;
        }
        boolean hasCheats = ResearchClient.hasCheat("operationcwal") && ResearchClient.hasCheat("medievalman") && ResearchClient.hasCheat("foodforthought") && ResearchClient.hasCheat("slipslopslap");
        String playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        return new Button("Toggle Unit Cheats", Button.itemIconSize, hasCheats ? new ResourceLocation("reignofnether", "textures/icons/blocks/chain_command_block_side.png") : new ResourceLocation("reignofnether", "textures/icons/blocks/chain_command_block_side_dark.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (hasCheats) {
                ResearchServerboundPacket.removeCheat(playerName, "operationcwal");
                ResearchServerboundPacket.removeCheat(playerName, "medievalman");
                ResearchServerboundPacket.removeCheat(playerName, "foodforthought");
                ResearchServerboundPacket.removeCheat(playerName, "slipslopslap");
            } else {
                ResearchServerboundPacket.addCheat(playerName, "operationcwal");
                ResearchServerboundPacket.addCheat(playerName, "medievalman");
                ResearchServerboundPacket.addCheat(playerName, "foodforthought");
                ResearchServerboundPacket.addCheat(playerName, "slipslopslap");
            }
        }, null, List.of(hasCheats ? MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats_off", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats3", (Object[])new Object[0]))));
    }

    public static Button getExitSandboxButton() {
        return new Button("Exit Sandbox Mode", Button.itemIconSize, new ResourceLocation("reignofnether", "textures/hud/cross.png"), (Keybinding)null, () -> false, () -> false, () -> true, PlayerServerboundPacket::resetRTS, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.exit1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.exit2", (Object[])new Object[0]))));
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (HudClientEvents.isMouseOverAnyButtonOrHud() || SandboxClientEvents.MC.f_91074_ == null) {
            CursorClientEvents.setLeftClickSandboxAction(null);
            return;
        }
        SandboxAction sandboxAction = CursorClientEvents.getLeftClickSandboxAction();
        if (evt.getButton() == 0 && sandboxAction != null) {
            String ownerName = switch (relationship) {
                case Relationship.NEUTRAL -> "";
                case Relationship.HOSTILE -> "Enemy";
                default -> SandboxClientEvents.MC.f_91074_.m_7755_().getString();
            };
            int entityId = 0;
            if (!UnitClientEvents.getSelectedUnits().isEmpty()) {
                entityId = UnitClientEvents.getSelectedUnits().get(0).m_19879_();
            }
            switch (sandboxAction) {
                case SPAWN_UNIT: {
                    SandboxServerboundPacket.spawnUnit(CursorClientEvents.getLeftClickSandboxAction(), ownerName, spawnUnitName, CursorClientEvents.getPreselectedBlockPos());
                    break;
                }
                case SET_ANCHOR: {
                    SandboxServerboundPacket.setAnchor(CursorClientEvents.getPreselectedBlockPos(), entityId);
                }
            }
            if (!Keybindings.shiftMod.isDown()) {
                spawnUnitName = "";
                CursorClientEvents.setLeftClickSandboxAction(null);
            }
        }
        if (evt.getButton() == 1) {
            spawnUnitName = "";
            CursorClientEvents.setLeftClickSandboxAction(null);
        }
    }
}

