/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sandbox;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class SandboxServerboundPacket {
    public SandboxAction sandboxAction;
    public String playerName;
    public String unitName;
    public BlockPos blockPos;
    public int entityId;

    public static void spawnUnit(SandboxAction sandboxAction, String playerName, String unitName, BlockPos blockPos) {
        if (!unitName.isBlank()) {
            PacketHandler.INSTANCE.sendToServer((Object)new SandboxServerboundPacket(sandboxAction, playerName, unitName, blockPos, 0));
        }
    }

    public static void setAnchor(BlockPos blockPos, int entityId) {
        PacketHandler.INSTANCE.sendToServer((Object)new SandboxServerboundPacket(SandboxAction.SET_ANCHOR, "", "", blockPos, entityId));
    }

    public static void resetToAnchor(int entityId) {
        PacketHandler.INSTANCE.sendToServer((Object)new SandboxServerboundPacket(SandboxAction.RESET_TO_ANCHOR, "", "", new BlockPos(0, 0, 0), entityId));
    }

    public static void removeAnchor(int entityId) {
        PacketHandler.INSTANCE.sendToServer((Object)new SandboxServerboundPacket(SandboxAction.REMOVE_ANCHOR, "", "", new BlockPos(0, 0, 0), entityId));
    }

    public SandboxServerboundPacket(SandboxAction sandboxAction, String playerName, String unitName, BlockPos blockPos, int entityId) {
        this.sandboxAction = sandboxAction;
        this.playerName = playerName;
        this.unitName = unitName;
        this.blockPos = blockPos;
        this.entityId = entityId;
    }

    public SandboxServerboundPacket(FriendlyByteBuf buffer) {
        this.sandboxAction = (SandboxAction)buffer.m_130066_(SandboxAction.class);
        this.playerName = buffer.m_130277_();
        this.unitName = buffer.m_130277_();
        this.blockPos = buffer.m_130135_();
        this.entityId = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.sandboxAction);
        buffer.m_130070_(this.playerName);
        buffer.m_130070_(this.unitName);
        buffer.m_130064_(this.blockPos);
        buffer.writeInt(this.entityId);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("SandboxServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            if (!SandboxServer.isAnyoneASandboxPlayer()) {
                ReignOfNether.LOGGER.warn("SandboxServerboundPacket: Tried to process packet from " + player.m_7755_() + " while sandbox is disabled");
                success.set(false);
                return;
            }
            switch (this.sandboxAction) {
                case SPAWN_UNIT: {
                    SandboxServer.spawnUnit(this.playerName, this.unitName, this.blockPos);
                    break;
                }
                case SET_ANCHOR: {
                    SandboxServer.setAnchor(this.entityId, this.blockPos);
                    break;
                }
                case RESET_TO_ANCHOR: {
                    SandboxServer.resetToAnchor(this.entityId);
                    break;
                }
                case REMOVE_ANCHOR: {
                    SandboxServer.removeAnchor(this.entityId);
                }
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

