/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.startpos;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.buildings.monsters.Mausoleum;
import com.solegendary.reignofnether.building.buildings.piglins.CentralPortal;
import com.solegendary.reignofnether.building.buildings.villagers.TownCentre;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.startpos.StartPos;
import com.solegendary.reignofnether.startpos.StartPosServerboundPacket;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StartPosClientEvents {
    public static ArrayList<StartPos> startPoses = new ArrayList();
    public static int startPosIndex = -1;
    public static Faction selectedFaction = Faction.NONE;
    public static boolean isStarting = false;
    private static final Minecraft MC = Minecraft.m_91087_();
    public static Button villagerReadyButton = new Button("Villagers", 14, new ResourceLocation("reignofnether", "textures/mobheads/villager.png"), (Keybinding)null, () -> selectedFaction == Faction.VILLAGERS, () -> TutorialClientEvents.isEnabled() || !PlayerClientEvents.canStartRTS || !StartPosClientEvents.isEnabled(), () -> !StartPosClientEvents.isSelectedPosReservedByOther() && StartPosClientEvents.getPos() != null && !isStarting, () -> {
        StartPos startPos = StartPosClientEvents.getPos();
        if (startPos != null && StartPosClientEvents.MC.f_91074_ != null) {
            if (selectedFaction != Faction.VILLAGERS) {
                selectedFaction = Faction.VILLAGERS;
                StartPosServerboundPacket.reservePos(startPos.pos, Faction.VILLAGERS, StartPosClientEvents.MC.f_91074_.m_7755_().getString());
            } else {
                selectedFaction = Faction.NONE;
                StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
            }
        }
    }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.startbuttons.villagers.reignofnether.first_startpos", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.startbuttons.villagers.reignofnether.second_startpos", (Object[])new Object[0]))));
    public static Button monsterReadyButton = new Button("Monsters", 14, new ResourceLocation("reignofnether", "textures/mobheads/creeper.png"), (Keybinding)null, () -> selectedFaction == Faction.MONSTERS, () -> TutorialClientEvents.isEnabled() || !PlayerClientEvents.canStartRTS || !StartPosClientEvents.isEnabled(), () -> !StartPosClientEvents.isSelectedPosReservedByOther() && StartPosClientEvents.getPos() != null && !isStarting, () -> {
        StartPos startPos = StartPosClientEvents.getPos();
        if (startPos != null && StartPosClientEvents.MC.f_91074_ != null) {
            if (selectedFaction != Faction.MONSTERS) {
                selectedFaction = Faction.MONSTERS;
                StartPosServerboundPacket.reservePos(startPos.pos, Faction.MONSTERS, StartPosClientEvents.MC.f_91074_.m_7755_().getString());
            } else {
                selectedFaction = Faction.NONE;
                StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
            }
        }
    }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.startbuttons.monsters.reignofnether.first_startpos", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.startbuttons.monsters.reignofnether.second_startpos", (Object[])new Object[0]))));
    public static Button piglinReadyButton = new Button("Piglins", 14, new ResourceLocation("reignofnether", "textures/mobheads/grunt.png"), (Keybinding)null, () -> selectedFaction == Faction.PIGLINS, () -> TutorialClientEvents.isEnabled() || !PlayerClientEvents.canStartRTS || !StartPosClientEvents.isEnabled(), () -> !StartPosClientEvents.isSelectedPosReservedByOther() && StartPosClientEvents.getPos() != null && !isStarting, () -> {
        StartPos startPos = StartPosClientEvents.getPos();
        if (startPos != null && StartPosClientEvents.MC.f_91074_ != null) {
            if (selectedFaction != Faction.PIGLINS) {
                selectedFaction = Faction.PIGLINS;
                StartPosServerboundPacket.reservePos(startPos.pos, Faction.PIGLINS, StartPosClientEvents.MC.f_91074_.m_7755_().getString());
            } else {
                selectedFaction = Faction.NONE;
                StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
            }
        }
    }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.startbuttons.piglins.reignofnether.first_startpos", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.startbuttons.piglins.reignofnether.second_startpos", (Object[])new Object[0]))));

    public static boolean isEnabled() {
        return ClientGameModeHelper.gameMode == GameMode.CLASSIC && !startPoses.isEmpty();
    }

    public static boolean isSelectedPosReservedByOther() {
        return StartPosClientEvents.getPos() != null && !StartPosClientEvents.getPos().playerName.isEmpty() && StartPosClientEvents.MC.f_91074_ != null && !StartPosClientEvents.getPos().playerName.equals(StartPosClientEvents.MC.f_91074_.m_7755_().getString()) && StartPosClientEvents.getPos().faction != Faction.NONE;
    }

    public static boolean hasReservedPos() {
        return StartPosClientEvents.getPos() != null && selectedFaction != Faction.NONE;
    }

    public static Button getPositionsButton() {
        return new Button("Starting Positions", 14, StartPosClientEvents.getIcon(), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), Keybindings.stop, () -> false, () -> !StartPosClientEvents.isEnabled(), () -> !isStarting, () -> {
            if (Keybindings.shiftMod.isDown()) {
                if (StartPosClientEvents.hasReservedPos()) {
                    OrthoviewClientEvents.centreCameraOnPos(StartPosClientEvents.getPos().pos);
                }
            } else {
                StartPosClientEvents.cycleStartBlock(true);
            }
        }, () -> StartPosClientEvents.cycleStartBlock(false), StartPosClientEvents.getPosButtonTooltip());
    }

    private static List<FormattedCharSequence> getPosButtonTooltip() {
        StartPos startPos = StartPosClientEvents.getPos();
        ArrayList<FormattedCharSequence> fcsList = new ArrayList<FormattedCharSequence>();
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.positions_button.tooltip1", (Object[])new Object[0]), true));
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.positions_button.tooltip2", (Object[])new Object[]{startPoses.stream().filter(sp -> sp.faction != Faction.NONE).toList().size(), startPoses.size()})));
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.positions_button.tooltip3", (Object[])new Object[0])));
        if (StartPosClientEvents.isSelectedPosReservedByOther() && startPos != null) {
            fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.positions_button.tooltip4", (Object[])new Object[]{startPos.playerName}), true));
        } else if (StartPosClientEvents.hasReservedPos()) {
            fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.positions_button.tooltip5", (Object[])new Object[0]), false));
        }
        return fcsList;
    }

    public static Button getStartButton() {
        return new Button("Start Game", 14, new ResourceLocation("reignofnether", "textures/hud/tick.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), null, () -> false, () -> !StartPosClientEvents.isEnabled() || isStarting, () -> !PlayerClientEvents.rtsLocked && startPoses.stream().filter(sp -> sp.faction != Faction.NONE).toList().size() > 0, PlayerServerboundPacket::startRTSEveryone, null, StartPosClientEvents.getStartButtonTooltip());
    }

    private static List<FormattedCharSequence> getStartButtonTooltip() {
        StartPos startPos = StartPosClientEvents.getPos();
        ArrayList<FormattedCharSequence> fcsList = new ArrayList<FormattedCharSequence>();
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.start_button.tooltip1", (Object[])new Object[0]), true));
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.start_button.tooltip2", (Object[])new Object[]{startPoses.stream().filter(sp -> sp.faction != Faction.NONE).toList().size(), startPoses.size()})));
        if (!StartPosClientEvents.hasReservedPos()) {
            fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.start_button.tooltip3", (Object[])new Object[0])));
        }
        return fcsList;
    }

    public static Button getCancelStartButton() {
        return new Button("Cancel Start Game", 14, new ResourceLocation("reignofnether", "textures/hud/cross.png"), new ResourceLocation("reignofnether", "textures/hud/icon_frame.png"), null, () -> false, () -> !StartPosClientEvents.isEnabled() || !isStarting, () -> startPoses.stream().filter(sp -> sp.faction != Faction.NONE).toList().size() > 0, PlayerServerboundPacket::cancelStartRTSEveryone, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"startpos.reignofnether.cancel_start_button", (Object[])new Object[0]), true)));
    }

    public static StartPos getPos() {
        if (startPosIndex < 0 || startPosIndex >= startPoses.size()) {
            return null;
        }
        return startPoses.get(startPosIndex);
    }

    private static ResourceLocation getIcon() {
        if (StartPosClientEvents.getPos() == null) {
            return new ResourceLocation("reignofnether", "textures/block/rts_start_block_white.png");
        }
        return StartPosClientEvents.getPos().getIcon();
    }

    private static void cycleStartBlock(boolean forward) {
        try {
            StartPos startPos;
            StartPos originalStartPos = StartPosClientEvents.getPos();
            if (selectedFaction != Faction.NONE && originalStartPos != null) {
                selectedFaction = Faction.NONE;
                StartPosServerboundPacket.unreservePos(originalStartPos.pos);
            }
            if (forward) {
                if (++startPosIndex >= startPoses.size()) {
                    startPosIndex = 0;
                }
            } else if (--startPosIndex < 0) {
                startPosIndex = startPoses.size() - 1;
            }
            if (!startPoses.isEmpty() && (startPos = StartPosClientEvents.getPos()) != null) {
                OrthoviewClientEvents.centreCameraOnPos(startPos.pos);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("IndexOutOfBoundsException in cycleStartBlock");
        }
    }

    @SubscribeEvent
    public static void onChangeGamemode(PlayerEvent.PlayerChangeGameModeEvent evt) {
        StartPos startPos = StartPosClientEvents.getPos();
        if (evt.getEntity() == StartPosClientEvents.MC.f_91074_ && startPos != null && StartPosClientEvents.MC.f_91074_ != null) {
            selectedFaction = Faction.NONE;
            StartPosServerboundPacket.unreservePos(startPos.pos);
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (!OrthoviewClientEvents.isEnabled() || StartPosClientEvents.MC.f_91074_ == null) {
            return;
        }
        for (StartPos startPos : startPoses) {
            if (startPos.faction == Faction.NONE) continue;
            switch (startPos.faction) {
                case VILLAGERS: {
                    BuildingClientEvents.setBuildingToPlace(TownCentre.class);
                    break;
                }
                case MONSTERS: {
                    BuildingClientEvents.setBuildingToPlace(Mausoleum.class);
                    break;
                }
                case PIGLINS: {
                    BuildingClientEvents.setBuildingToPlace(CentralPortal.class);
                }
            }
            int forceColour = 2;
            if (startPos.playerName.equals(StartPosClientEvents.MC.f_91074_.m_7755_().getString())) {
                forceColour = 1;
            }
            BuildingClientEvents.drawBuildingToPlace(evt.getPoseStack(), BuildingClientEvents.getBuildingOriginPos(startPos.pos), forceColour);
            BuildingClientEvents.setBuildingToPlace(null);
        }
    }

    public static void resetAll() {
        startPosIndex = -1;
        selectedFaction = Faction.NONE;
        isStarting = false;
        for (StartPos startPos : startPoses) {
            startPos.reset();
        }
    }

    @SubscribeEvent
    public static void onClientLogout(ClientPlayerNetworkEvent.LoggingOut evt) {
        if (StartPosClientEvents.MC.f_91074_ != null && evt.getPlayer() != null && evt.getPlayer().m_19879_() == StartPosClientEvents.MC.f_91074_.m_19879_()) {
            StartPosClientEvents.resetAll();
            startPoses.clear();
        }
    }

    @SubscribeEvent
    public static void onPlayerLogoutEvent(PlayerEvent.PlayerLoggedOutEvent evt) {
        if (StartPosClientEvents.MC.f_91074_ != null && evt.getEntity().m_19879_() == StartPosClientEvents.MC.f_91074_.m_19879_()) {
            StartPosClientEvents.resetAll();
            startPoses.clear();
        }
    }
}

