/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival;

import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.survival.Wave;
import com.solegendary.reignofnether.survival.WaveEnemy;
import com.solegendary.reignofnether.survival.spawners.PiglinWaveSpawner;
import com.solegendary.reignofnether.survival.spawners.WaveSpawner;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.MagmaCubeUnit;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;

public class WavePortal {
    private static final int SPAWN_TICKS_MAX = 600;
    private static int spawnTicks = 0;
    public final Portal portal;
    public final Wave wave;
    private int initialSpawnPop;
    private int numPlayers;
    private BlockPos lastOnPos;

    public WavePortal(Portal portal, Wave wave) {
        this.portal = portal;
        this.portal.selfBuilding = true;
        this.wave = wave;
        this.numPlayers = PlayerServerEvents.rtsPlayers.size();
        this.initialSpawnPop = wave.population / wave.getNumPortals() / 2 * this.numPlayers;
    }

    public Portal getPortal() {
        return this.portal;
    }

    public void tick(long ticksToAdd) {
        if (!this.portal.isBuilt) {
            return;
        }
        if (this.initialSpawnPop > 0) {
            this.doSpawn();
        } else {
            int pop = SurvivalServerEvents.getTotalEnemyPopulation();
            if ((float)pop > (float)this.wave.population * 2.0f) {
                return;
            }
            if (spawnTicks >= 600) {
                spawnTicks = 0;
                this.doSpawn();
            } else {
                spawnTicks = (int)((long)spawnTicks + ticksToAdd * (long)this.numPlayers);
            }
        }
    }

    public void doSpawn() {
        Random random = new Random();
        EntityType<? extends Mob> mobType = PiglinWaveSpawner.getRandomUnitOfTier(this.wave.highestUnitTier);
        ServerLevel level = (ServerLevel)this.portal.getLevel();
        Entity entity = this.portal.produceUnit(level, mobType, "Enemy", true);
        if (entity instanceof GhastUnit) {
            GhastUnit ghastUnit = (GhastUnit)entity;
            ghastUnit.m_6478_(MoverType.SELF, new Vec3(0.0, 10.0, 0.0));
        }
        if (entity instanceof Unit) {
            List<Unit> enemies;
            Unit unit = (Unit)entity;
            PiglinWaveSpawner.checkAndApplyArmour((LivingEntity)unit, this.wave.highestUnitTier);
            if (this.wave.highestUnitTier >= 3 && random.nextBoolean() && entity instanceof HoglinUnit) {
                HoglinUnit hoglinUnit = (HoglinUnit)entity;
                Entity entityPassenger = UnitServerEvents.spawnMob((EntityType<? extends Mob>)((EntityType)EntityRegistrar.HEADHUNTER_UNIT.get()), level, (Vec3i)hoglinUnit.m_20097_(), "Enemy");
                if (entityPassenger instanceof Unit) {
                    Unit pUnit = (Unit)entityPassenger;
                    entityPassenger.m_20329_((Entity)hoglinUnit);
                    if (this.initialSpawnPop > 0) {
                        this.initialSpawnPop -= WaveSpawner.getModifiedPopCost(unit);
                    }
                }
            }
            if (unit instanceof MagmaCubeUnit) {
                MagmaCubeUnit magmaCubeUnit = (MagmaCubeUnit)unit;
                magmaCubeUnit.m_7839_(this.wave.highestUnitTier, true);
            }
            if (!(enemies = SurvivalServerEvents.getCurrentEnemies().stream().map(e -> e.unit).toList()).contains(unit)) {
                SurvivalServerEvents.getCurrentEnemies().add(new WaveEnemy(unit));
            }
            if (this.initialSpawnPop > 0) {
                this.initialSpawnPop -= WaveSpawner.getModifiedPopCost(unit);
            }
        }
    }
}

