/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival.spawners;

import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.survival.Wave;
import com.solegendary.reignofnether.survival.spawners.WaveSpawner;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.CreeperUnit;
import com.solegendary.reignofnether.unit.units.monsters.DrownedUnit;
import com.solegendary.reignofnether.unit.units.monsters.HuskUnit;
import com.solegendary.reignofnether.unit.units.monsters.PoisonSpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.SlimeUnit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import com.solegendary.reignofnether.unit.units.monsters.StrayUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MonsterWaveSpawner {
    private static final Random random = new Random();
    private static final Map<Integer, List<EntityType<? extends Mob>>> MONSTER_UNITS = new HashMap<Integer, List<EntityType<? extends Mob>>>();

    public static void checkAndApplyUpgrades(int tier) {
        if (tier >= 4 && !ResearchServerEvents.playerHasResearch("Enemy", "Sticky Webbing")) {
            ResearchServerEvents.addResearch("Enemy", "Sticky Webbing");
        }
        if (tier >= 6 && !ResearchServerEvents.playerHasResearch("Enemy", "Cube Magma")) {
            ResearchServerEvents.addResearch("Enemy", "Cube Magma");
        }
    }

    public static void checkAndApplyArmour(LivingEntity entity, int tier) {
        if (entity instanceof ZombieUnit || entity instanceof HuskUnit || entity instanceof DrownedUnit || entity instanceof SkeletonUnit || entity instanceof StrayUnit) {
            if (tier >= 4) {
                entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
            }
            if (tier >= 5) {
                entity.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
                entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
            }
            if (tier >= 6) {
                entity.m_6844_(EquipmentSlot.CHEST).m_41663_(Enchantments.f_44965_, 1);
                entity.m_6844_(EquipmentSlot.LEGS).m_41663_(Enchantments.f_44965_, 1);
                entity.m_6844_(EquipmentSlot.FEET).m_41663_(Enchantments.f_44965_, 1);
            }
        }
    }

    public static EntityType<? extends Mob> getRandomUnitOfTier(int tier) {
        List<EntityType<? extends Mob>> units = MONSTER_UNITS.get(tier);
        return units.get(random.nextInt(units.size()));
    }

    public static void spawnMonsterWave(ServerLevel level, Wave wave) {
        MonsterWaveSpawner.checkAndApplyUpgrades(wave.highestUnitTier);
        int pop = wave.population * PlayerServerEvents.rtsPlayers.size();
        int remainingPop = wave.population * PlayerServerEvents.rtsPlayers.size();
        List<BlockPos> bps = WaveSpawner.getValidSpawnPoints(remainingPop, (Level)level, true, 4);
        for (BlockPos bp : bps) {
            Unit unit;
            Entity entityPassenger;
            BlockState bs = level.m_8055_(bp);
            EntityType<? extends Mob> mobType = MonsterWaveSpawner.getRandomUnitOfTier(wave.highestUnitTier);
            bp = bp.m_7918_(0, 2, 0);
            Entity entity = UnitServerEvents.spawnMob(mobType, level, (Vec3i)(mobType.m_20676_().getString().contains("spider") ? bp.m_7494_() : bp), "Enemy");
            if (wave.highestUnitTier >= 4 && entity instanceof SpiderUnit) {
                SpiderUnit spiderUnit = (SpiderUnit)entity;
                entityPassenger = UnitServerEvents.spawnMob((EntityType<? extends Mob>)((EntityType)EntityRegistrar.SKELETON_UNIT.get()), level, (Vec3i)bp.m_7494_(), "Enemy");
                if (entityPassenger instanceof Unit) {
                    unit = (Unit)entityPassenger;
                    entityPassenger.m_20329_((Entity)spiderUnit);
                    remainingPop -= WaveSpawner.getModifiedPopCost(unit);
                }
            }
            if (wave.highestUnitTier >= 5 && entity instanceof PoisonSpiderUnit) {
                PoisonSpiderUnit poisonSpiderUnit = (PoisonSpiderUnit)entity;
                entityPassenger = UnitServerEvents.spawnMob((EntityType<? extends Mob>)((EntityType)EntityRegistrar.STRAY_UNIT.get()), level, (Vec3i)bp.m_7494_(), "Enemy");
                if (entityPassenger instanceof Unit) {
                    unit = (Unit)entityPassenger;
                    entityPassenger.m_20329_((Entity)poisonSpiderUnit);
                    remainingPop -= WaveSpawner.getModifiedPopCost(unit);
                }
            }
            if (random.nextBoolean() && entity instanceof CreeperUnit) {
                CreeperUnit creeperUnit = (CreeperUnit)entity;
                creeperUnit.m_20088_().m_135381_(Creeper.f_32274_, (Object)true);
            }
            if (entity instanceof SlimeUnit) {
                SlimeUnit slimeUnit = (SlimeUnit)entity;
                slimeUnit.m_7839_(wave.highestUnitTier, true);
            }
            if (entity instanceof Unit) {
                Unit unit2 = (Unit)entity;
                MonsterWaveSpawner.checkAndApplyArmour((LivingEntity)unit2, wave.highestUnitTier);
                WaveSpawner.placeIceOrMagma(bp, (Level)level);
                remainingPop -= WaveSpawner.getModifiedPopCost(unit2);
            }
            if (remainingPop > 0) continue;
            break;
        }
        if (remainingPop > 0) {
            PlayerServerEvents.sendMessageToAllPlayers("Failed to spawn " + remainingPop + "/" + pop + " population worth of monster units");
        }
        SurvivalServerEvents.lastFaction = Faction.MONSTERS;
    }

    static {
        MONSTER_UNITS.put(1, List.of((EntityType)EntityRegistrar.ZOMBIE_PIGLIN_UNIT.get(), (EntityType)EntityRegistrar.ZOMBIE_UNIT.get(), (EntityType)EntityRegistrar.SKELETON_UNIT.get()));
        MONSTER_UNITS.put(2, List.of((EntityType)EntityRegistrar.ZOMBIE_UNIT.get(), (EntityType)EntityRegistrar.SKELETON_UNIT.get(), (EntityType)EntityRegistrar.HUSK_UNIT.get(), (EntityType)EntityRegistrar.STRAY_UNIT.get(), (EntityType)EntityRegistrar.SPIDER_UNIT.get(), (EntityType)EntityRegistrar.SLIME_UNIT.get()));
        MONSTER_UNITS.put(3, List.of((EntityType)EntityRegistrar.SKELETON_UNIT.get(), (EntityType)EntityRegistrar.HUSK_UNIT.get(), (EntityType)EntityRegistrar.STRAY_UNIT.get(), (EntityType)EntityRegistrar.SPIDER_UNIT.get(), (EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get(), (EntityType)EntityRegistrar.SLIME_UNIT.get(), (EntityType)EntityRegistrar.DROWNED_UNIT.get(), (EntityType)EntityRegistrar.CREEPER_UNIT.get()));
        MONSTER_UNITS.put(4, List.of((EntityType)EntityRegistrar.STRAY_UNIT.get(), (EntityType)EntityRegistrar.SPIDER_UNIT.get(), (EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get(), (EntityType)EntityRegistrar.SLIME_UNIT.get(), (EntityType)EntityRegistrar.HUSK_UNIT.get(), (EntityType)EntityRegistrar.DROWNED_UNIT.get(), (EntityType)EntityRegistrar.CREEPER_UNIT.get(), (EntityType)EntityRegistrar.ENDERMAN_UNIT.get()));
        MONSTER_UNITS.put(5, List.of((EntityType)EntityRegistrar.STRAY_UNIT.get(), (EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get(), (EntityType)EntityRegistrar.SLIME_UNIT.get(), (EntityType)EntityRegistrar.DROWNED_UNIT.get(), (EntityType)EntityRegistrar.CREEPER_UNIT.get(), (EntityType)EntityRegistrar.ENDERMAN_UNIT.get(), (EntityType)EntityRegistrar.WARDEN_UNIT.get()));
        MONSTER_UNITS.put(6, List.of((EntityType)EntityRegistrar.STRAY_UNIT.get(), (EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get(), (EntityType)EntityRegistrar.SLIME_UNIT.get(), (EntityType)EntityRegistrar.DROWNED_UNIT.get(), (EntityType)EntityRegistrar.CREEPER_UNIT.get(), (EntityType)EntityRegistrar.ENDERMAN_UNIT.get(), (EntityType)EntityRegistrar.WARDEN_UNIT.get()));
    }
}

