/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival.spawners;

import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.survival.SurvivalServerEvents;
import com.solegendary.reignofnether.survival.Wave;
import com.solegendary.reignofnether.survival.spawners.WaveSpawner;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class PiglinWaveSpawner {
    private static final Random random = new Random();
    private static final Map<Integer, List<EntityType<? extends Mob>>> PIGLIN_UNITS = new HashMap<Integer, List<EntityType<? extends Mob>>>();

    public static EntityType<? extends Mob> getRandomUnitOfTier(int tier) {
        List<EntityType<? extends Mob>> units = PIGLIN_UNITS.get(tier);
        return units.get(random.nextInt(units.size()));
    }

    public static void checkAndApplyArmour(LivingEntity entity, int tier) {
        if (entity instanceof HeadhunterUnit || entity instanceof BruteUnit) {
            if (tier >= 4) {
                entity.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42477_));
            }
            if (tier >= 5) {
                entity.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42478_));
                entity.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42479_));
            }
            if (tier >= 6) {
                entity.m_6844_(EquipmentSlot.CHEST).m_41663_(Enchantments.f_44965_, 1);
                entity.m_6844_(EquipmentSlot.LEGS).m_41663_(Enchantments.f_44965_, 1);
                entity.m_6844_(EquipmentSlot.FEET).m_41663_(Enchantments.f_44965_, 1);
            }
        }
    }

    public static void checkAndApplyUpgrades(int tier) {
        if (tier >= 4 && !ResearchServerEvents.playerHasResearch("Enemy", "Shield Tactics")) {
            ResearchServerEvents.addResearch("Enemy", "Shield Tactics");
        }
        if (tier >= 4 && !ResearchServerEvents.playerHasResearch("Enemy", "Heavy Tridents")) {
            ResearchServerEvents.addResearch("Enemy", "Heavy Tridents");
        }
        if (tier >= 6 && !ResearchServerEvents.playerHasResearch("Enemy", "Soul Fireballs")) {
            ResearchServerEvents.addResearch("Enemy", "Soul Fireballs");
        }
        if (tier >= 6 && !ResearchServerEvents.playerHasResearch("Enemy", "Cube Magma")) {
            ResearchServerEvents.addResearch("Enemy", "Cube Magma");
        }
    }

    public static void spawnPiglinWave(ServerLevel level, Wave wave) {
        PiglinWaveSpawner.checkAndApplyUpgrades(wave.highestUnitTier);
        int numPortals = wave.getNumPortals();
        int failedPortalPlacements = 0;
        ArrayList<BlockPos> portalBps = new ArrayList<BlockPos>();
        for (int i = 0; i < numPortals; ++i) {
            boolean tooCloseToAnotherPortal;
            BlockPos spawnBp = null;
            int attempts = 0;
            do {
                tooCloseToAnotherPortal = false;
                List<BlockPos> spawnBps = WaveSpawner.getValidSpawnPoints(1, (Level)level, false, 8);
                if (!spawnBps.isEmpty()) {
                    spawnBp = spawnBps.get(0);
                }
                ++attempts;
                for (BlockPos bp : portalBps) {
                    if (spawnBp == null || !(bp.m_123331_((Vec3i)spawnBp) < 25.0)) continue;
                    tooCloseToAnotherPortal = true;
                }
                for (BlockPos bp : SurvivalServerEvents.portals.stream().map(p -> p.portal.originPos).toList()) {
                    if (spawnBp == null || !(bp.m_123331_((Vec3i)spawnBp) < 25.0)) continue;
                    tooCloseToAnotherPortal = true;
                }
            } while ((spawnBp == null || tooCloseToAnotherPortal) && attempts < 100);
            if (spawnBp != null) {
                portalBps.add(spawnBp);
                WaveSpawner.spawnBuilding("Basic Portal", new BlockPos((Vec3i)spawnBp).m_7494_());
                continue;
            }
            ++failedPortalPlacements;
        }
        if (failedPortalPlacements > 0) {
            PlayerServerEvents.sendMessageToAllPlayers("Failed to spawn " + failedPortalPlacements + " portals!");
        }
        SurvivalServerEvents.lastFaction = Faction.PIGLINS;
    }

    static {
        PIGLIN_UNITS.put(1, List.of((EntityType)EntityRegistrar.BRUTE_UNIT.get(), (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get()));
        PIGLIN_UNITS.put(2, List.of((EntityType)EntityRegistrar.BRUTE_UNIT.get(), (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get(), (EntityType)EntityRegistrar.HOGLIN_UNIT.get(), (EntityType)EntityRegistrar.MAGMA_CUBE_UNIT.get()));
        PIGLIN_UNITS.put(3, List.of((EntityType)EntityRegistrar.BRUTE_UNIT.get(), (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get(), (EntityType)EntityRegistrar.MAGMA_CUBE_UNIT.get(), (EntityType)EntityRegistrar.BLAZE_UNIT.get(), (EntityType)EntityRegistrar.HOGLIN_UNIT.get()));
        PIGLIN_UNITS.put(4, List.of((EntityType)EntityRegistrar.BRUTE_UNIT.get(), (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get(), (EntityType)EntityRegistrar.MAGMA_CUBE_UNIT.get(), (EntityType)EntityRegistrar.BLAZE_UNIT.get(), (EntityType)EntityRegistrar.HOGLIN_UNIT.get(), (EntityType)EntityRegistrar.WITHER_SKELETON_UNIT.get()));
        PIGLIN_UNITS.put(5, List.of((EntityType)EntityRegistrar.BRUTE_UNIT.get(), (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get(), (EntityType)EntityRegistrar.MAGMA_CUBE_UNIT.get(), (EntityType)EntityRegistrar.BLAZE_UNIT.get(), (EntityType)EntityRegistrar.HOGLIN_UNIT.get(), (EntityType)EntityRegistrar.WITHER_SKELETON_UNIT.get(), (EntityType)EntityRegistrar.GHAST_UNIT.get()));
        PIGLIN_UNITS.put(6, List.of((EntityType)EntityRegistrar.BRUTE_UNIT.get(), (EntityType)EntityRegistrar.HEADHUNTER_UNIT.get(), (EntityType)EntityRegistrar.MAGMA_CUBE_UNIT.get(), (EntityType)EntityRegistrar.BLAZE_UNIT.get(), (EntityType)EntityRegistrar.HOGLIN_UNIT.get(), (EntityType)EntityRegistrar.WITHER_SKELETON_UNIT.get(), (EntityType)EntityRegistrar.GHAST_UNIT.get()));
    }
}

