/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.survival.spawners;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;

public class WaveSpawner {
    public static final int MAX_SPAWN_RANGE = 100;
    public static final int MIN_SPAWN_RANGE = 70;
    public static final int SAMPLE_POINTS_PER_BUILDING = 100;
    public static final int MAX_FAILED_BUILDINGS = 10;
    public static final int MIN_VALID_BUILDINGS = 5;
    public static final float PERCENT_VALID_BUILDINGS = 0.1f;
    private static final Random random = new Random();

    public static int getModifiedPopCost(Unit unit) {
        return Math.max(1, unit.getCost().population - 1);
    }

    public static double getYVariance(Level level, BlockPos bp, int radius) {
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                bps.add(MiscUtil.getHighestGroundBlock(level, bp.m_7918_(x, 0, z)));
            }
        }
        int n = bps.size();
        if (n == 0) {
            return 0.0;
        }
        double sumY = 0.0;
        for (BlockPos bp1 : bps) {
            sumY += (double)bp1.m_123342_();
        }
        double meanY = sumY / (double)n;
        double variance = 0.0;
        for (BlockPos bp1 : bps) {
            variance += Math.pow((double)bp1.m_123342_() - meanY, 2.0);
        }
        return variance / (double)n;
    }

    public static void placeIceOrMagma(BlockPos bp, Level level) {
        BlockState bsToPlace;
        BlockPos bpLiquid = null;
        for (int i = 0; i < 10; ++i) {
            if (level.m_8055_(bp.m_7918_(0, 5 - i, 0)).m_60819_().m_76178_()) continue;
            bpLiquid = bp.m_7918_(0, 5 - i, 0);
            break;
        }
        if (bpLiquid == null) {
            return;
        }
        BlockState bs = level.m_8055_(bpLiquid);
        if (bs.m_60819_().m_205070_(FluidTags.f_13132_)) {
            bsToPlace = ((Block)BlockRegistrar.WALKABLE_MAGMA_BLOCK.get()).m_49966_();
        } else if (bs.m_60819_().m_205070_(FluidTags.f_13131_)) {
            bsToPlace = Blocks.f_50449_.m_49966_();
        } else {
            return;
        }
        level.m_46597_(bpLiquid, bsToPlace);
        List<BlockPos> bps = List.of(bpLiquid.m_122012_(), bpLiquid.m_122029_(), bpLiquid.m_122019_(), bpLiquid.m_122024_(), bpLiquid.m_122012_().m_122029_(), bpLiquid.m_122019_().m_122024_(), bpLiquid.m_122012_().m_122029_(), bpLiquid.m_122019_().m_122024_());
        for (BlockPos pos : bps) {
            IPlantable plantable;
            BlockState bsAdj = level.m_8055_(pos);
            if (bsAdj.m_60819_().m_76178_() && (!(bsAdj instanceof IPlantable) || !((plantable = (IPlantable)bsAdj) instanceof LiquidBlockContainer))) continue;
            level.m_46597_(pos, bsToPlace);
        }
    }

    public static List<BlockPos> getValidSpawnPoints(int amount, Level level, boolean allowLiquid, int flatnessRadius) {
        List<Building> buildings = BuildingServerEvents.getBuildings().stream().filter(b -> !"Enemy".equals(b.ownerName) && !b.ownerName.isBlank()).toList();
        Random random = new Random();
        if (buildings.isEmpty()) {
            return List.of();
        }
        Vec3 centroid = new Vec3(0.0, 0.0, 0.0);
        for (Building building : buildings) {
            centroid = centroid.m_82549_(Vec3.m_82512_((Vec3i)building.centrePos));
        }
        double invBs = 1.0f / (float)buildings.size();
        Vec3 fCentroid = centroid.m_82559_(new Vec3(invBs, invBs, invBs));
        List<Building> sortedBuildings = buildings.stream().sorted(Comparator.comparing(b -> b.centrePos.m_203198_(fCentroid.f_82479_, fCentroid.f_82480_, fCentroid.f_82481_)).reversed()).toList();
        int numValidBuildings = (int)(5.0f + (float)buildings.size() * 0.1f);
        List<Building> validBuildings = sortedBuildings.subList(0, Math.min(sortedBuildings.size(), numValidBuildings));
        int spawnAttemptsThisBuilding = 0;
        double distSqrToNearestBuilding = 999999.0;
        double distSqrToNearestEnemyBuilding = 999999.0;
        int failedBuildings = 0;
        ArrayList<BlockPos> validSpawns = new ArrayList<BlockPos>();
        while (true) {
            Building building = validBuildings.get(random.nextInt(validBuildings.size()));
            int x = building.centrePos.m_123341_() + random.nextInt(-100, 100);
            int z = building.centrePos.m_123343_() + random.nextInt(-100, 100);
            int y = level.m_46745_(new BlockPos(x, 0, z)).m_5885_(Heightmap.Types.WORLD_SURFACE, x, z);
            BlockPos spawnBp = MiscUtil.getHighestGroundBlock(level, new BlockPos(x, y, z));
            BlockState spawnBs = level.m_8055_(spawnBp);
            if (++spawnAttemptsThisBuilding > 100) {
                if (++failedBuildings > 10) {
                    break;
                }
            } else {
                Vec3 vec3 = new Vec3((double)x, (double)y, (double)z);
                Building b2 = BuildingUtils.findClosestBuilding(false, vec3, b1 -> !b1.ownerName.equals("Enemy"));
                Building eb = BuildingUtils.findClosestBuilding(false, vec3, b1 -> b1.ownerName.equals("Enemy"));
                if (b2 != null) {
                    distSqrToNearestBuilding = b2.centrePos.m_203193_((Position)vec3);
                }
                if (eb != null) {
                    distSqrToNearestEnemyBuilding = eb.centrePos.m_203193_((Position)vec3);
                }
            }
            if (spawnBs.m_204336_(BlockTags.f_13035_) || spawnBs.m_204336_(BlockTags.f_13106_) || spawnBs.m_204336_(BlockTags.f_13090_) || distSqrToNearestBuilding < 4900.0 || distSqrToNearestEnemyBuilding < 100.0 || !spawnBs.m_60819_().m_76178_() && !allowLiquid || BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), spawnBp) || BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), spawnBp.m_7494_()) || flatnessRadius > 0 && WaveSpawner.getYVariance(level, spawnBp, flatnessRadius) >= (double)((float)flatnessRadius / 2.0f)) continue;
            validSpawns.add(spawnBp);
            if (--amount <= 0) break;
        }
        Collections.shuffle(validSpawns);
        if (validSpawns.isEmpty()) {
            PlayerServerEvents.sendMessageToAllPlayers("WARNING: could not find any valid spawn locations!");
        }
        return validSpawns;
    }

    public static Building spawnBuilding(String buildingName, BlockPos bp) {
        Building building = BuildingServerEvents.placeBuilding(buildingName, bp, Rotation.NONE, "Enemy", new int[0], false, false);
        if (building != null) {
            building.selfBuilding = true;
        }
        BuildingUtils.clearBuildingArea(building);
        return building;
    }
}

