/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.time;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.time.TimeClientEvents;
import com.solegendary.reignofnether.time.TimeServerEvents;
import com.solegendary.reignofnether.time.TimeUtils;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class NightUtils {
    public static boolean isInRangeOfNightSource(Vec3 pos, boolean clientSide) {
        if (clientSide && TimeClientEvents.isBloodMoonActive() || !clientSide && TimeServerEvents.isBloodMoonActive()) {
            return true;
        }
        List<Building> buildings = clientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        Vec2 pos2d = new Vec2((float)pos.f_82479_, (float)pos.f_82481_);
        for (Building building : buildings) {
            if (building.isDestroyedServerside || !(building instanceof NightSource)) continue;
            NightSource ns = (NightSource)((Object)building);
            BlockPos centrePos = BuildingUtils.getCentrePos(building.getBlocks());
            Vec2 centrePos2d = new Vec2((float)centrePos.m_123341_(), (float)centrePos.m_123343_());
            float nightRangeSqr = ns.getNightRange() * ns.getNightRange();
            if (!(centrePos2d.m_165914_(pos2d) < nightRangeSqr)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSunBurnTick(Mob mob) {
        Unit unit;
        if (mob.m_9236_().f_46443_) {
            return false;
        }
        if (mob instanceof Unit && ResearchServerEvents.playerHasCheat((unit = (Unit)mob).getOwnerName(), "slipslopslap")) {
            return false;
        }
        if (mob.f_19797_ % 10 == 0 && TimeUtils.isDay(mob.m_9236_().m_46468_())) {
            boolean isProtected;
            BlockPos blockpos = new BlockPos((int)mob.m_20185_(), (int)mob.m_20188_(), (int)mob.m_20189_());
            boolean bl = isProtected = mob.m_20071_() || mob.f_146808_ || mob.f_146809_ || mob.m_6060_();
            if (isProtected || !mob.m_9236_().m_45527_(blockpos)) {
                return false;
            }
            Vec3 mobEyePos = mob.m_146892_();
            return !NightUtils.isInRangeOfNightSource(mobEyePos, mob.m_9236_().f_46443_);
        }
        return false;
    }
}

