/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.unit.HeroUnitSave;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class HeroUnitSaveData
extends SavedData {
    public final ArrayList<HeroUnitSave> heroUnits = new ArrayList();

    private static HeroUnitSaveData create() {
        return new HeroUnitSaveData();
    }

    @Nonnull
    public static HeroUnitSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return HeroUnitSaveData.create();
        }
        return (HeroUnitSaveData)server.m_129783_().m_8895_().m_164861_(HeroUnitSaveData::load, HeroUnitSaveData::create, "saved-herounit-data");
    }

    public static HeroUnitSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("HeroUnitSaveData.load");
        HeroUnitSaveData data = HeroUnitSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("heroUnits");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag htag = (CompoundTag)ctag;
                String uuid = htag.m_128461_("uuid");
                int experience = htag.m_128451_("experience");
                int skillPoints = htag.m_128451_("skillPoints");
                int charges = htag.m_128451_("charges");
                int ability1Rank = htag.m_128451_("ability1Rank");
                int ability2Rank = htag.m_128451_("ability2Rank");
                int ability3Rank = htag.m_128451_("ability3Rank");
                int ability4Rank = htag.m_128451_("ability4Rank");
                data.heroUnits.add(new HeroUnitSave(uuid, experience, skillPoints, charges, ability1Rank, ability2Rank, ability3Rank, ability4Rank));
                ReignOfNether.LOGGER.info("HeroUnitSaveData.load: " + uuid + "|" + experience + "|" + skillPoints + "|" + charges + "|" + ability1Rank + "|" + ability2Rank + "|" + ability3Rank + "|" + ability4Rank);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.heroUnits.forEach(h -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("uuid", h.uuid);
            cTag.m_128405_("experience", h.experience);
            cTag.m_128405_("skillPoints", h.skillPoints);
            cTag.m_128405_("charges", h.charges);
            cTag.m_128405_("ability1Rank", h.ability1Rank);
            cTag.m_128405_("ability2Rank", h.ability2Rank);
            cTag.m_128405_("ability3Rank", h.ability3Rank);
            cTag.m_128405_("ability4Rank", h.ability4Rank);
            list.add((Object)cTag);
        });
        tag.m_128365_("heroUnits", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

