/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.unit.NonUnitClientEvents;
import com.solegendary.reignofnether.unit.NonUnitServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitFormations;
import com.solegendary.reignofnether.unit.goals.FlyingUsePortalGoal;
import com.solegendary.reignofnether.unit.goals.GatherResourcesGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.ConvertableUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class UnitActionItem {
    private final String ownerName;
    private final UnitAction action;
    private final int unitId;
    private final int[] unitIds;
    private final BlockPos preselectedBlockPos;
    private final BlockPos selectedBuildingPos;
    private final List<UnitAction> nonAbilityActions = List.of(UnitAction.STOP, UnitAction.HOLD, UnitAction.GARRISON, UnitAction.UNGARRISON, UnitAction.MOVE, UnitAction.ATTACK_MOVE, UnitAction.ATTACK, UnitAction.ATTACK_BUILDING, UnitAction.FOLLOW, UnitAction.BUILD_REPAIR, UnitAction.FARM, UnitAction.RETURN_RESOURCES, UnitAction.RETURN_RESOURCES_TO_CLOSEST, UnitAction.DELETE, UnitAction.DISCARD);

    public final UnitAction getAction() {
        return this.action;
    }

    public final int[] getUnitIds() {
        return this.unitIds;
    }

    public final BlockPos getPreselectedBlockPos() {
        return this.preselectedBlockPos;
    }

    public boolean equals(UnitActionItem unitActionItem) {
        if (unitActionItem == null) {
            return false;
        }
        return this.ownerName == null && unitActionItem.ownerName == null || this.ownerName != null && this.ownerName.equals(unitActionItem.ownerName) && this.action == null && unitActionItem.action == null || this.action != null && this.action.equals((Object)unitActionItem.action) && this.preselectedBlockPos == null && unitActionItem.preselectedBlockPos == null || this.preselectedBlockPos != null && this.preselectedBlockPos.equals((Object)unitActionItem.preselectedBlockPos) && this.selectedBuildingPos == null && unitActionItem.selectedBuildingPos == null || this.selectedBuildingPos != null && this.selectedBuildingPos.equals((Object)unitActionItem.selectedBuildingPos) && this.unitId == unitActionItem.unitId && Arrays.equals(this.unitIds, unitActionItem.unitIds);
    }

    public UnitActionItem(String ownerName, UnitAction action, int unitId, int[] unitIds, BlockPos preselectedBlockPos, BlockPos selectedBuildingPos) {
        this.ownerName = ownerName;
        this.action = action;
        this.unitId = unitId;
        this.unitIds = unitIds;
        this.preselectedBlockPos = preselectedBlockPos;
        this.selectedBuildingPos = selectedBuildingPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void action(Level level) {
        Ability usedAbility = null;
        boolean isSandboxPlayer = level.m_5776_() ? SandboxClientEvents.isSandboxPlayer(this.ownerName) : SandboxServer.isSandboxPlayer(this.ownerName);
        ArrayList<Unit> actionableUnits = new ArrayList<Unit>();
        for (int id : this.unitIds) {
            Unit unit;
            Entity entity = level.m_6815_(id);
            if (!(entity instanceof Unit) || !(unit = (Unit)entity).getOwnerName().equals(this.ownerName) && !isSandboxPlayer) continue;
            actionableUnits.add(unit);
        }
        ArrayList<Unit> formationUnits = new ArrayList<Unit>();
        block31: for (Unit unit : actionableUnits) {
            double distToTarget;
            BlockPos bp;
            MoveToTargetBlockGoal goal;
            if (this.action == UnitAction.MOVE && (goal = unit.getMoveGoal()) != null && !level.m_5776_() && (bp = goal.getMoveTarget()) != null && (distToTarget = bp.m_123331_((Vec3i)((Mob)unit).m_20097_())) > 400.0) {
                double ignoreDist = Math.min(5.0, Math.sqrt(distToTarget) / 10.0);
                if (bp.m_123331_((Vec3i)this.preselectedBlockPos) < ignoreDist * ignoreDist) {
                    return;
                }
            }
            if (this.action == UnitAction.TOGGLE_GATHER_TARGET) {
                if (unit instanceof WorkerUnit) {
                    WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                    GatherResourcesGoal goal2 = workerUnit.getGatherResourceGoal();
                    ResourceName targetResourceName = goal2.getTargetResourceName();
                    Unit.fullResetBehaviours(unit);
                    switch (targetResourceName) {
                        case NONE: {
                            goal2.setTargetResourceName(ResourceName.FOOD);
                            break;
                        }
                        case FOOD: {
                            goal2.setTargetResourceName(ResourceName.WOOD);
                            break;
                        }
                        case WOOD: {
                            goal2.setTargetResourceName(ResourceName.ORE);
                            break;
                        }
                        case ORE: {
                            goal2.setTargetResourceName(ResourceName.NONE);
                        }
                    }
                }
            } else if (this.action != UnitAction.ATTACK || unit.getTargetGoal().getTarget() == null || unit.getTargetGoal().getTarget().m_19879_() != this.unitId) {
                boolean foundAbility = false;
                boolean shouldResetBehaviours = true;
                for (Ability ability : unit.getAbilities()) {
                    if (ability.action != this.action) continue;
                    foundAbility = true;
                    shouldResetBehaviours = ability.shouldResetBehaviours();
                    break;
                }
                if (shouldResetBehaviours && (this.nonAbilityActions.contains((Object)this.action) || foundAbility)) {
                    Unit.fullResetBehaviours(unit);
                }
            }
            switch (this.action) {
                case STOP: {
                    Entity passenger = ((Entity)unit).m_146895_();
                    if (!(passenger instanceof Unit)) continue block31;
                    Unit unitPassenger = (Unit)passenger;
                    Unit.fullResetBehaviours(unitPassenger);
                    break;
                }
                case HOLD: {
                    unit.setHoldPosition(true);
                    break;
                }
                case GARRISON: {
                    if (!unit.canGarrison()) continue block31;
                    unit.getGarrisonGoal().setBuildingTarget(this.preselectedBlockPos);
                    break;
                }
                case UNGARRISON: {
                    GarrisonableBuilding garr = GarrisonableBuilding.getGarrison(unit);
                    if (garr == null) continue block31;
                    Building building = (Building)((Object)garr);
                    BlockPos bp2 = building.originPos.m_121955_((Vec3i)garr.getExitPosition());
                    ((LivingEntity)unit).m_6021_((double)((float)bp2.m_123341_() + 0.5f), (double)((float)bp2.m_123342_() + 0.5f), (double)((float)bp2.m_123343_() + 0.5f));
                    break;
                }
                case MOVE: {
                    ResourceName resName = ResourceSources.getBlockResourceName(this.preselectedBlockPos, level);
                    Building buildingAtPos = BuildingUtils.findBuilding(((Entity)unit).m_9236_().m_5776_(), this.preselectedBlockPos);
                    if (unit instanceof WorkerUnit) {
                        WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                        if (resName != ResourceName.NONE && buildingAtPos == null) {
                            GatherResourcesGoal goal3 = workerUnit.getGatherResourceGoal();
                            goal3.setTargetResourceName(resName);
                            goal3.setMoveTarget(this.preselectedBlockPos);
                            if (!Unit.atMaxResources((Unit)((Object)workerUnit))) continue block31;
                            if (level.m_5776_()) {
                                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.worker_inv_full", (Object[])new Object[0]));
                            }
                            goal3.saveAndReturnResources();
                            break;
                        }
                    }
                    if (buildingAtPos instanceof Portal) {
                        Portal portal = (Portal)buildingAtPos;
                        if (portal.portalType == Portal.PortalType.TRANSPORT && unit.canUsePortal()) {
                            MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getUsePortalGoal();
                            if (moveToTargetBlockGoal instanceof FlyingUsePortalGoal) {
                                FlyingUsePortalGoal flyingUsePortalGoal = (FlyingUsePortalGoal)moveToTargetBlockGoal;
                                flyingUsePortalGoal.setBuildingTarget(this.preselectedBlockPos);
                            }
                            if (!((moveToTargetBlockGoal = unit.getUsePortalGoal()) instanceof UsePortalGoal)) continue block31;
                            UsePortalGoal usePortalGoal = (UsePortalGoal)moveToTargetBlockGoal;
                            usePortalGoal.setBuildingTarget(this.preselectedBlockPos);
                            break;
                        }
                    }
                    if (actionableUnits.size() == 1) {
                        unit.setMoveTarget(this.preselectedBlockPos);
                        break;
                    }
                    formationUnits.add(unit);
                    break;
                }
                case ATTACK_MOVE: {
                    if (unit instanceof AttackerUnit) {
                        AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
                        MiscUtil.addUnitCheckpoint(unit, this.preselectedBlockPos, false);
                        attackerUnit.setAttackMoveTarget(this.preselectedBlockPos);
                        break;
                    }
                    unit.setMoveTarget(this.preselectedBlockPos);
                    break;
                }
                case ATTACK: {
                    if (unit instanceof AttackerUnit) {
                        AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
                        attackerUnit.setUnitAttackTargetForced((LivingEntity)level.m_6815_(this.unitId));
                        break;
                    }
                    LivingEntity livingEntity = (LivingEntity)level.m_6815_(this.unitId);
                    if (livingEntity != null) {
                        MiscUtil.addUnitCheckpoint(unit, this.unitId, true);
                    }
                    unit.setFollowTarget(livingEntity);
                    break;
                }
                case ATTACK_BUILDING: {
                    if (unit instanceof AttackerUnit) {
                        AttackerUnit attackerUnit = (AttackerUnit)((Object)unit);
                        attackerUnit.setAttackBuildingTarget(this.preselectedBlockPos);
                        break;
                    }
                    unit.setMoveTarget(this.preselectedBlockPos);
                    break;
                }
                case FOLLOW: {
                    LivingEntity livingEntity = (LivingEntity)level.m_6815_(this.unitId);
                    if (livingEntity != null) {
                        MiscUtil.addUnitCheckpoint(unit, this.unitId, true);
                    }
                    unit.setFollowTarget(livingEntity);
                    break;
                }
                case BUILD_REPAIR: {
                    if (unit instanceof WorkerUnit) {
                        WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                        Building building = BuildingUtils.findBuilding(level.m_5776_(), this.preselectedBlockPos);
                        if (building == null) continue block31;
                        workerUnit.getBuildRepairGoal().setBuildingTarget(building);
                        break;
                    }
                    unit.setMoveTarget(this.preselectedBlockPos);
                    break;
                }
                case ENABLE_AUTOCAST_BUILD_REPAIR: 
                case DISABLE_AUTOCAST_BUILD_REPAIR: {
                    if (!(unit instanceof WorkerUnit)) continue block31;
                    WorkerUnit workerUnit = (WorkerUnit)((Object)unit);
                    workerUnit.getBuildRepairGoal().autocastRepair = this.action == UnitAction.ENABLE_AUTOCAST_BUILD_REPAIR;
                    break;
                }
                case FARM: {
                    WorkerUnit workerUnit;
                    GatherResourcesGoal goal4;
                    if (!(unit instanceof WorkerUnit) || (goal4 = (workerUnit = (WorkerUnit)((Object)unit)).getGatherResourceGoal()) == null) continue block31;
                    goal4.setTargetResourceName(ResourceName.FOOD);
                    goal4.setMoveTarget(this.preselectedBlockPos);
                    Building building = BuildingUtils.findBuilding(level.m_5776_(), this.preselectedBlockPos);
                    if (building == null || !building.name.contains(" Farm")) continue block31;
                    goal4.setTargetFarm(building);
                    if (!Unit.atMaxResources((Unit)((Object)workerUnit))) continue block31;
                    if (level.m_5776_()) {
                        HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.worker_inv_full", (Object[])new Object[0]));
                    }
                    goal4.saveAndReturnResources();
                    break;
                }
                case RETURN_RESOURCES: {
                    WorkerUnit workerUnit;
                    GatherResourcesGoal goal5;
                    if (unit instanceof WorkerUnit && (goal5 = (workerUnit = (WorkerUnit)((Object)unit)).getGatherResourceGoal()) != null) {
                        goal5.saveData.delete();
                    }
                    ReturnResourcesGoal returnResourcesGoal = unit.getReturnResourcesGoal();
                    Building building = BuildingUtils.findBuilding(false, this.preselectedBlockPos);
                    if (returnResourcesGoal == null || building == null) continue block31;
                    returnResourcesGoal.setBuildingTarget(building);
                    break;
                }
                case RETURN_RESOURCES_TO_CLOSEST: {
                    ReturnResourcesGoal returnResourcesGoal;
                    WorkerUnit workerUnit;
                    GatherResourcesGoal goal6;
                    if (unit instanceof WorkerUnit && (goal6 = (workerUnit = (WorkerUnit)((Object)unit)).getGatherResourceGoal()) != null) {
                        goal6.saveData.delete();
                    }
                    if ((returnResourcesGoal = unit.getReturnResourcesGoal()) == null) continue block31;
                    returnResourcesGoal.returnToClosestBuilding();
                    break;
                }
                case DELETE: {
                    ((LivingEntity)unit).m_6074_();
                    break;
                }
                case DISCARD: {
                    if (!(unit instanceof ConvertableUnit)) continue block31;
                    ConvertableUnit cUnit = (ConvertableUnit)((Object)unit);
                    cUnit.setShouldDiscard(true);
                    break;
                }
                default: {
                    boolean enabledAutocast = false;
                    for (Ability ability : unit.getAbilities()) {
                        if (ability.action == this.action && (ability.isOffCooldown() || ability.canBypassCooldown())) {
                            if (ability.canTargetEntities && this.unitId > 0) {
                                ability.use(level, unit, (LivingEntity)level.m_6815_(this.unitId));
                                usedAbility = ability;
                                if (!ability.oneClickOneUse) continue;
                                break block31;
                            }
                            ability.use(level, unit, this.preselectedBlockPos);
                            usedAbility = ability;
                            if (!ability.oneClickOneUse) continue;
                            break block31;
                        }
                        if (ability.autocastEnableAction == this.action) {
                            ability.setAutocast(true);
                            enabledAutocast = true;
                            continue;
                        }
                        if (ability.autocastDisableAction != this.action) continue;
                        ability.setAutocast(false);
                    }
                    if (!enabledAutocast) continue block31;
                    for (Ability ability : unit.getAbilities()) {
                        if (ability.autocastEnableAction == null || ability.autocastEnableAction == this.action) continue;
                        ability.setAutocast(false);
                    }
                    continue block31;
                }
            }
        }
        if (!formationUnits.isEmpty()) {
            List<Pair<LivingEntity, BlockPos>> formationPairs = UnitFormations.getMoveFormation(level, new ArrayList<LivingEntity>(formationUnits.stream().map(u -> (LivingEntity)u).toList()), this.preselectedBlockPos);
            for (Pair<LivingEntity, BlockPos> pair : formationPairs) {
                LivingEntity le = (LivingEntity)pair.getFirst();
                BlockPos targetPos = (BlockPos)pair.getSecond();
                if (!(le instanceof Unit)) continue;
                Unit unit = (Unit)le;
                unit.setMoveTarget(targetPos);
            }
        }
        if (level.m_5776_() && usedAbility != null && usedAbility.oneClickOneUse) {
            HudClientEvents.setLowestCdHudEntity();
        }
        Building actionableBuilding = null;
        if (!this.selectedBuildingPos.equals((Object)new BlockPos(0, 0, 0))) {
            actionableBuilding = BuildingUtils.findBuilding(level.m_5776_(), this.selectedBuildingPos);
        }
        if (actionableBuilding != null) {
            for (Ability ability : actionableBuilding.getAbilities()) {
                if (ability.action != this.action || !ability.isOffCooldown() && !ability.canBypassCooldown()) continue;
                if (ability.canTargetEntities && this.unitId > 0) {
                    ability.use(level, actionableBuilding, (LivingEntity)level.m_6815_(this.unitId));
                    continue;
                }
                ability.use(level, actionableBuilding, this.preselectedBlockPos);
            }
        }
        ArrayList<PathfinderMob> actionableNonUnits = new ArrayList<PathfinderMob>();
        for (int id : this.unitIds) {
            Entity entity = level.m_6815_(id);
            if (!(entity instanceof PathfinderMob)) continue;
            PathfinderMob mob = (PathfinderMob)entity;
            actionableNonUnits.add(mob);
        }
        if (level.m_5776_() && NonUnitClientEvents.canControlNonUnits() || !level.m_5776_() && NonUnitServerEvents.canControlNonUnits(level, this.ownerName)) {
            Object object = actionableNonUnits.iterator();
            while (object.hasNext()) {
                Entity entity;
                PathfinderMob mob = (PathfinderMob)object.next();
                if (mob instanceof Unit) continue;
                mob.m_21573_().m_26573_();
                mob.m_6710_(null);
                if (!level.m_5776_()) {
                    List<Pair<PathfinderMob, BlockPos>> targetPos = NonUnitServerEvents.nonUnitMoveTargets;
                    synchronized (targetPos) {
                        NonUnitServerEvents.nonUnitMoveTargets.removeIf(p -> p.getFirst() == mob);
                    }
                }
                if (List.of(UnitAction.MOVE, UnitAction.FOLLOW, UnitAction.ATTACK_MOVE).contains((Object)this.action)) {
                    BlockPos bp = this.preselectedBlockPos;
                    Path path = mob.m_21573_().m_26524_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 0);
                    mob.m_21573_().m_26536_(path, 1.0);
                    if (!level.m_5776_()) {
                        List<Pair<PathfinderMob, BlockPos>> list = NonUnitServerEvents.nonUnitMoveTargets;
                        synchronized (list) {
                            NonUnitServerEvents.nonUnitMoveTargets.add((Pair<PathfinderMob, BlockPos>)new Pair((Object)mob, (Object)this.preselectedBlockPos));
                        }
                    }
                } else if (this.action == UnitAction.ATTACK && (entity = level.m_6815_(this.unitId)) instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)entity;
                    mob.m_6710_(le);
                }
                if (!level.m_5776_()) {
                    if (this.action != UnitAction.ATTACK_MOVE) {
                        NonUnitServerEvents.attackSuppressedNonUnits.add(mob);
                    }
                    NonUnitServerEvents.moveSuppressedNonUnits.add(mob);
                    continue;
                }
                NonUnitClientEvents.isMoveCheckpointGreen = this.action != UnitAction.ATTACK_MOVE;
            }
        }
    }
}

