/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.unit.UnitSave;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class UnitSaveData
extends SavedData {
    public final ArrayList<UnitSave> units = new ArrayList();

    private static UnitSaveData create() {
        return new UnitSaveData();
    }

    @Nonnull
    public static UnitSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return UnitSaveData.create();
        }
        return (UnitSaveData)server.m_129783_().m_8895_().m_164861_(UnitSaveData::load, UnitSaveData::create, "saved-unit-data");
    }

    public static UnitSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("UnitSaveData.load");
        UnitSaveData data = UnitSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("units");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag utag = (CompoundTag)ctag;
                String name = utag.m_128461_("name");
                String ownerName = utag.m_128461_("ownerName");
                String uuid = utag.m_128461_("uuid");
                BlockPos blockPos = new BlockPos(utag.m_128451_("anchorPosX"), utag.m_128451_("anchorPosY"), utag.m_128451_("anchorPosZ"));
                data.units.add(new UnitSave(name, ownerName, uuid, blockPos));
                ReignOfNether.LOGGER.info("UnitSaveData.load: " + ownerName + "|" + name + "|" + uuid);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.units.forEach(u -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("name", u.name);
            cTag.m_128359_("ownerName", u.ownerName);
            cTag.m_128359_("uuid", u.uuid);
            if (u.anchorPos != null) {
                cTag.m_128405_("anchorPosX", u.anchorPos.m_123341_());
                cTag.m_128405_("anchorPosY", u.anchorPos.m_123342_());
                cTag.m_128405_("anchorPosZ", u.anchorPos.m_123343_());
            } else {
                cTag.m_128405_("anchorPosX", 0);
                cTag.m_128405_("anchorPosY", 0);
                cTag.m_128405_("anchorPosZ", 0);
            }
            list.add((Object)cTag);
        });
        tag.m_128365_("units", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

