/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.Portal;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class FlyingUsePortalGoal
extends FlyingMoveToTargetGoal {
    private Building buildingTarget;

    public FlyingUsePortalGoal(Mob mob) {
        super(mob, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8037_() {
        Building building = this.buildingTarget;
        if (building instanceof Portal) {
            Portal portal = (Portal)building;
            if (this.moveTarget != null) {
                this.calcMoveTarget();
                if (this.buildingTarget.getBlocksPlaced() <= 0) {
                    this.stopUsingPortal();
                }
                Vec3 vec3 = new Vec3((double)((float)this.moveTarget.m_123341_() + 0.5f), (double)((float)this.moveTarget.m_123342_() + 0.5f), (double)((float)this.moveTarget.m_123343_() + 0.5f));
                if (!(this.mob.m_20238_(vec3) <= 9.0)) return;
                if (portal.hasDestination()) {
                    BlockPos bp = portal.destination.m_7918_(0, 4, 0);
                    SoundClientboundPacket.playSoundAtPos(SoundAction.USE_PORTAL, bp);
                    this.mob.m_6021_((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 0.5f), (double)((float)bp.m_123343_() + 0.5f));
                    SoundClientboundPacket.playSoundAtPos(SoundAction.USE_PORTAL, portal.destination);
                }
                this.stopUsingPortal();
                return;
            }
        }
        this.moveTarget = null;
    }

    private void calcMoveTarget() {
        if (this.buildingTarget instanceof Portal) {
            this.moveTarget = this.buildingTarget.centrePos.m_7918_(0, 4, 0);
        }
    }

    public void setBuildingTarget(BlockPos blockPos) {
        if (blockPos != null) {
            if (this.mob.m_9236_().m_5776_()) {
                this.buildingTarget = BuildingUtils.findBuilding(true, blockPos);
                Building building = this.buildingTarget;
                if (building instanceof Portal) {
                    Portal portal = (Portal)building;
                    if (this.buildingTarget.ownerName.equals(((Unit)this.mob).getOwnerName())) {
                        if (portal.hasDestination()) {
                            MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(this.buildingTarget.centrePos.m_123341_(), this.buildingTarget.originPos.m_123342_() + 1, this.buildingTarget.centrePos.m_123343_()), true);
                        } else {
                            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.no_destination", (Object[])new Object[0]));
                        }
                    }
                }
            } else {
                this.buildingTarget = BuildingUtils.findBuilding(false, blockPos);
            }
            this.calcMoveTarget();
            this.m_8056_();
        }
    }

    public Building getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopUsingPortal() {
        this.buildingTarget = null;
        super.stopMoving();
    }
}

