/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class GarrisonGoal
extends MoveToTargetBlockGoal {
    private Building buildingTarget;

    public GarrisonGoal(Mob mob) {
        super(mob, true, 0);
    }

    public void m_8037_() {
        Building building = this.buildingTarget;
        if (building instanceof GarrisonableBuilding) {
            GarrisonableBuilding garrisonableBuilding = (GarrisonableBuilding)((Object)building);
            this.calcMoveTarget();
            if (this.buildingTarget.getBlocksPlaced() <= 0) {
                this.stopGarrisoning();
            }
            if (this.moveTarget != null) {
                Vec3 vec3 = new Vec3((double)((float)this.moveTarget.m_123341_() + 0.5f), (double)((float)this.moveTarget.m_123342_() + 0.5f), (double)((float)this.moveTarget.m_123343_() + 0.5f));
                if (this.mob.m_20238_(vec3) <= 3.0) {
                    if (!garrisonableBuilding.isFull() && this.buildingTarget.isBuilt) {
                        BlockPos bp = this.buildingTarget.originPos.m_121955_((Vec3i)garrisonableBuilding.getEntryPosition());
                        this.mob.m_6021_((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 0.5f), (double)((float)bp.m_123343_() + 0.5f));
                    }
                    this.stopGarrisoning();
                }
            }
        } else {
            this.moveTarget = null;
        }
    }

    private void calcMoveTarget() {
        if (this.buildingTarget instanceof GarrisonableBuilding) {
            this.moveTarget = this.buildingTarget.getClosestGroundPos(this.mob.m_20097_(), 1);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBuildingTarget(BlockPos blockPos) {
        GarrisonableBuilding garrisonableBuilding;
        Building building;
        boolean clientside;
        block7: {
            block6: {
                if (blockPos == null) return;
                clientside = this.mob.m_9236_().m_5776_();
                building = BuildingUtils.findBuilding(clientside, blockPos);
                if (building == null) {
                    return;
                }
                boolean isAllied = clientside ? AlliancesClient.isAllied(building.ownerName, ((Unit)this.mob).getOwnerName()) : AlliancesServerEvents.isAllied(building.ownerName, ((Unit)this.mob).getOwnerName());
                if (!(building instanceof GarrisonableBuilding)) break block6;
                garrisonableBuilding = (GarrisonableBuilding)((Object)building);
                if (building.ownerName.equals(((Unit)this.mob).getOwnerName()) || isAllied) break block7;
            }
            if (!clientside) return;
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.not_garrisonable", (Object[])new Object[0]));
            return;
        }
        if (garrisonableBuilding.isFull()) {
            if (!clientside) return;
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.building_full", (Object[])new Object[0]));
            return;
        }
        if (clientside) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(building.centrePos.m_123341_(), building.originPos.m_123342_() + 1, building.centrePos.m_123343_()), true);
        }
        this.buildingTarget = building;
        this.calcMoveTarget();
        this.m_8056_();
    }

    public Building getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopGarrisoning() {
        this.buildingTarget = null;
        super.stopMoving();
    }
}

