/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RangedAttackBuildingGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.unit.units.monsters.WardenUnit;
import com.solegendary.reignofnether.unit.units.monsters.ZoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.villagers.IronGolemUnit;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Slime;

public class MeleeAttackBuildingGoal
extends MoveToTargetBlockGoal {
    private int ticksToNextBlockBreak;
    private Building buildingTarget;
    protected final int RECALC_COOLDOWN_MAX = 10;
    protected int recalcCooldown;

    public MeleeAttackBuildingGoal(Mob mob) {
        super(mob, true, 0);
        this.ticksToNextBlockBreak = ((AttackerUnit)this.mob).getAttackCooldown();
        this.RECALC_COOLDOWN_MAX = 10;
        this.recalcCooldown = 0;
    }

    public void m_8037_() {
        if (this.buildingTarget != null) {
            if (this.mob.m_21573_().m_26571_() && this.moveTarget != null && this.mob.m_20097_().m_123331_((Vec3i)this.moveTarget) > 1.0 && !this.isAttacking()) {
                if (this.recalcCooldown > 0) {
                    --this.recalcCooldown;
                } else {
                    this.recalcCooldown = 10;
                    this.m_8056_();
                }
            }
            this.calcMoveTarget();
            if (this.buildingTarget.getBlocksPlaced() <= 0) {
                this.stopAttacking();
            }
            if (this.isAttacking()) {
                BlockPos bp = this.buildingTarget.centrePos;
                this.mob.m_21563_().m_24946_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_());
                this.mob.m_21563_().f_186068_ = 20;
                --this.ticksToNextBlockBreak;
                if (this.ticksToNextBlockBreak <= 0) {
                    Slime slime;
                    if (this.mob instanceof IronGolemUnit || this.mob instanceof HoglinUnit || this.mob instanceof ZoglinUnit || this.mob instanceof RavagerUnit || this.mob instanceof WardenUnit) {
                        this.mob.m_7822_((byte)4);
                        UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_ATTACK, (LivingEntity)this.mob);
                    } else {
                        this.mob.m_6674_(InteractionHand.MAIN_HAND);
                    }
                    AttackerUnit unit = (AttackerUnit)this.mob;
                    this.ticksToNextBlockBreak = unit.getAttackCooldown();
                    double damageFloat = unit.getUnitAttackDamage() * this.buildingTarget.getMeleeDamageMult();
                    if (unit instanceof IronGolemUnit) {
                        damageFloat *= 2.0;
                    } else if (unit instanceof HoglinUnit || unit instanceof ZoglinUnit) {
                        damageFloat *= 1.5;
                    }
                    double damageFloor = Math.floor(damageFloat);
                    int damageInt = (int)damageFloor;
                    Random random = new Random();
                    if (random.nextDouble(1.0) < damageFloat - damageFloor) {
                        ++damageInt;
                    }
                    this.buildingTarget.destroyRandomBlocks(damageInt);
                    Mob mob = this.mob;
                    if (mob instanceof Slime && (slime = (Slime)mob).m_20096_()) {
                        slime.m_6135_();
                    }
                }
            }
        } else {
            this.moveTarget = null;
        }
    }

    private void calcMoveTarget() {
        if (this.buildingTarget != null) {
            this.moveTarget = this.buildingTarget.getClosestGroundPos(this.mob.m_20097_(), 1);
        }
    }

    public boolean isAttacking() {
        if (this.buildingTarget != null && this.moveTarget != null) {
            return MiscUtil.isMobInRangeOfPos(this.moveTarget, (LivingEntity)this.mob, 2.0f);
        }
        return false;
    }

    public void setBuildingTarget(BlockPos blockPos) {
        if (blockPos != null) {
            if (this.mob.m_9236_().m_5776_()) {
                Building b = BuildingUtils.findBuilding(this.mob.m_9236_().m_5776_(), blockPos);
                if (b != null && !b.invulnerable) {
                    this.buildingTarget = b;
                    MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(this.buildingTarget.centrePos.m_123341_(), this.buildingTarget.originPos.m_123342_() + 1, this.buildingTarget.centrePos.m_123343_()), false);
                }
            } else {
                Building b = BuildingUtils.findBuilding(this.mob.m_9236_().m_5776_(), blockPos);
                if (b != null && !b.invulnerable) {
                    AttackerUnit aUnit;
                    Entity entity;
                    this.buildingTarget = b;
                    if (this.mob.m_20160_() && (entity = this.mob.m_146895_()) instanceof AttackerUnit && (entity = (aUnit = (AttackerUnit)entity).getAttackBuildingGoal()) instanceof RangedAttackBuildingGoal) {
                        RangedAttackBuildingGoal rabg = (RangedAttackBuildingGoal)entity;
                        rabg.setBuildingTarget(this.buildingTarget);
                    }
                }
            }
            this.calcMoveTarget();
            this.m_8056_();
        }
    }

    public Building getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopAttacking() {
        this.buildingTarget = null;
        super.stopMoving();
    }
}

