/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientboundPacket;
import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UnitCrossbowAttackGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class RangedAttackBuildingGoal<T extends Mob>
extends Goal {
    private final T mob;
    private BlockPos blockTarget = null;
    private UnitBowAttackGoal<?> bowAttackGoal = null;
    private UnitCrossbowAttackGoal<?> cbowAttackGoal = null;
    private Building buildingTarget = null;

    public RangedAttackBuildingGoal(T mob, UnitBowAttackGoal<?> bowAttackGoal) {
        this.mob = mob;
        this.bowAttackGoal = bowAttackGoal;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public RangedAttackBuildingGoal(T mob, UnitCrossbowAttackGoal<?> cbowAttackGoal) {
        this.mob = mob;
        this.cbowAttackGoal = cbowAttackGoal;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void setNextBlockTarget() {
        if (this.buildingTarget != null && !this.buildingTarget.getBlocks().isEmpty()) {
            Random rand = new Random();
            List<BuildingBlock> nonAirBlocks = this.buildingTarget.getBlocks().stream().filter(b -> b.isPlaced(this.mob.m_9236_())).toList();
            int bound = nonAirBlocks.size();
            if (bound > 0) {
                int randIndex = rand.nextInt(bound);
                BuildingBlock block = nonAirBlocks.get(randIndex);
                this.blockTarget = block.getBlockPos();
            } else {
                this.blockTarget = null;
            }
        }
    }

    public void setBuildingTarget(BlockPos blockPos) {
        if (blockPos != null) {
            if (this.mob.m_9236_().m_5776_()) {
                Building b = BuildingUtils.findBuilding(this.mob.m_9236_().m_5776_(), blockPos);
                if (b != null && !b.invulnerable) {
                    this.buildingTarget = b;
                    MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(this.buildingTarget.centrePos.m_123341_(), this.buildingTarget.originPos.m_123342_() + 1, this.buildingTarget.centrePos.m_123343_()), false);
                }
            } else {
                Building b = BuildingUtils.findBuilding(this.mob.m_9236_().m_5776_(), blockPos);
                if (b != null && !b.invulnerable) {
                    this.buildingTarget = b;
                    this.setNextBlockTarget();
                }
            }
            this.m_8056_();
        }
    }

    public void setBuildingTarget(Building building) {
        this.buildingTarget = building;
    }

    public Building getBuildingTarget() {
        return this.buildingTarget;
    }

    public boolean m_8036_() {
        return this.blockTarget != null;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.isDoneMoving();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.blockTarget = null;
        this.buildingTarget = null;
        this.mob.m_21561_(false);
    }

    public void m_8037_() {
        if (this.buildingTarget != null && this.buildingTarget.getBlocksPlaced() <= 0) {
            this.m_8041_();
        }
        if (this.blockTarget != null) {
            float tx = (float)this.blockTarget.m_123341_() + 0.5f;
            float ty = (float)this.blockTarget.m_123342_() + 0.5f;
            float tz = (float)this.blockTarget.m_123343_() + 0.5f;
            this.mob.m_21563_().m_24946_((double)tx, (double)ty, (double)tz);
            if (this.mob.m_9236_().m_5776_()) {
                return;
            }
            float attackRange = ((AttackerUnit)this.mob).getAttackRange();
            double distToTarget = Math.sqrt(this.mob.m_20275_((double)tx, (double)ty, (double)tz));
            if (distToTarget > (double)(attackRange - 1.0f) && !((Unit)this.mob).getHoldPosition()) {
                if (!this.mob.m_20159_()) {
                    this.moveTo(this.blockTarget);
                }
            } else if (!this.mob.m_20159_()) {
                this.stopMoving();
            }
            if (distToTarget <= (double)attackRange && this.bowAttackGoal != null && this.bowAttackGoal.getAttackCooldown() <= 0) {
                T t = this.mob;
                if (t instanceof RangedAttackerUnit) {
                    RangedAttackerUnit rangedAttackerUnit = (RangedAttackerUnit)t;
                    rangedAttackerUnit.performUnitRangedAttack(tx, ty, tz, 20.0f);
                    if (!this.mob.m_9236_().m_5776_() && this.buildingTarget != null) {
                        FogOfWarClientboundPacket.revealRangedUnit(this.buildingTarget.ownerName, this.mob.m_19879_());
                    }
                }
                this.bowAttackGoal.setToMaxAttackCooldown();
                this.setNextBlockTarget();
            }
        }
    }

    private boolean isDoneMoving() {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            return flyingMoveGoal.isAtDestination();
        }
        return this.mob.m_21573_().m_26571_();
    }

    private void stopMoving() {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            flyingMoveGoal.stopMoving();
        } else {
            this.mob.m_21573_().m_26573_();
        }
    }

    private void moveTo(BlockPos bp) {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            flyingMoveGoal.setMoveTarget(bp);
        } else {
            this.mob.m_21573_().m_26519_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 1.0);
        }
    }
}

