/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class RangedFlyingAttackGroundGoal<T extends Mob>
extends Goal {
    private final T mob;
    private BlockPos groundTarget = null;
    private final UnitBowAttackGoal<?> bowAttackGoal;

    public RangedFlyingAttackGroundGoal(T mob, UnitBowAttackGoal<?> bowAttackGoal) {
        this.mob = mob;
        this.bowAttackGoal = bowAttackGoal;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.groundTarget != null;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.isDoneMoving();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        this.setGroundTarget(null);
        this.mob.m_21561_(false);
    }

    public BlockPos getGroundTarget() {
        return this.groundTarget;
    }

    public void setGroundTarget(BlockPos groundTarget) {
        this.groundTarget = groundTarget;
        if (groundTarget != null) {
            MiscUtil.addUnitCheckpoint((Unit)this.mob, groundTarget, false);
        }
    }

    public void m_8037_() {
        if (this.groundTarget != null) {
            float tx = (float)this.groundTarget.m_123341_() + 0.5f;
            float ty = (float)this.groundTarget.m_123342_() + 0.5f;
            float tz = (float)this.groundTarget.m_123343_() + 0.5f;
            this.mob.m_21563_().m_24946_((double)tx, (double)ty, (double)tz);
            if (this.mob.m_9236_().m_5776_()) {
                return;
            }
            float attackRange = ((AttackerUnit)this.mob).getAttackRange();
            double distToTarget = Math.sqrt(this.mob.m_20275_((double)tx, (double)ty, (double)tz));
            if (distToTarget > (double)(attackRange - 1.0f) && !((Unit)this.mob).getHoldPosition()) {
                this.moveTo(this.groundTarget);
            } else {
                this.stopMoving();
            }
            if (distToTarget <= (double)attackRange && this.bowAttackGoal.getAttackCooldown() <= 0) {
                T t = this.mob;
                if (t instanceof RangedAttackerUnit) {
                    RangedAttackerUnit rangedAttackerUnit = (RangedAttackerUnit)t;
                    rangedAttackerUnit.performUnitRangedAttack(tx, ty, tz, 20.0f);
                }
                this.bowAttackGoal.setToMaxAttackCooldown();
            }
        }
    }

    private boolean isDoneMoving() {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            return flyingMoveGoal.isAtDestination();
        }
        return this.mob.m_21573_().m_26571_();
    }

    private void stopMoving() {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            flyingMoveGoal.stopMoving();
        } else {
            this.mob.m_21573_().m_26573_();
        }
    }

    private void moveTo(BlockPos bp) {
        Unit unit = (Unit)this.mob;
        MoveToTargetBlockGoal moveToTargetBlockGoal = unit.getMoveGoal();
        if (moveToTargetBlockGoal instanceof FlyingMoveToTargetGoal) {
            FlyingMoveToTargetGoal flyingMoveGoal = (FlyingMoveToTargetGoal)moveToTargetBlockGoal;
            flyingMoveGoal.setMoveTarget(bp);
        } else {
            this.mob.m_21573_().m_26519_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_(), 1.0);
        }
    }
}

