/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.FlyingMoveToTargetGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.RangedAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.UnitBowAttackGoal;
import com.solegendary.reignofnether.unit.goals.UnitRangedAttackGoal;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.PhantomSummon;
import com.solegendary.reignofnether.unit.units.villagers.RavagerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public interface AttackerUnit {
    public boolean getWillRetaliate();

    public int getAttackCooldown();

    public float getAttacksPerSecond();

    public float getAggroRange();

    public boolean getAggressiveWhenIdle();

    public float getAttackRange();

    public float getUnitAttackDamage();

    public BlockPos getAttackMoveTarget();

    public boolean canAttackBuildings();

    public Goal getAttackGoal();

    public Goal getAttackBuildingGoal();

    default public void setUnitAttackTarget(@Nullable LivingEntity target) {
        if (target != null) {
            MiscUtil.addUnitCheckpoint((Unit)((Object)this), target.m_19879_(), false);
        }
        ((Unit)((Object)this)).getTargetGoal().setTarget(target);
    }

    default public void setUnitAttackTargetForced(@Nullable LivingEntity target) {
        this.setUnitAttackTarget(target);
        if (target != null) {
            ((Unit)((Object)this)).getTargetGoal().forced = true;
        }
    }

    default public void setAttackBuildingTarget(BlockPos preselectedBlockPos) {
        if (this.canAttackBuildings()) {
            Goal attackBuildingGoal = this.getAttackBuildingGoal();
            if (attackBuildingGoal instanceof RangedAttackBuildingGoal) {
                RangedAttackBuildingGoal rabg = (RangedAttackBuildingGoal)attackBuildingGoal;
                rabg.setBuildingTarget(preselectedBlockPos);
            } else if (attackBuildingGoal instanceof MeleeAttackBuildingGoal) {
                MeleeAttackBuildingGoal mabg = (MeleeAttackBuildingGoal)attackBuildingGoal;
                mabg.setBuildingTarget(preselectedBlockPos);
            }
        } else {
            Level level = ((LivingEntity)this).m_9236_();
            Building building = BuildingUtils.findBuilding(level.m_5776_(), preselectedBlockPos);
            if (building != null) {
                BlockPos groundCentrePos = new BlockPos(building.centrePos.m_123341_(), building.originPos.m_123342_() + 1, building.centrePos.m_123343_());
                BlockPos targetPos = MyMath.getXZRangeLimitedBlockPos(new BlockPos((Vec3i)groundCentrePos), ((LivingEntity)this).m_20097_(), this.getAttackRange() - 5.0f);
                while (!level.m_8055_(targetPos.m_7494_()).m_60795_()) {
                    targetPos = targetPos.m_7494_();
                }
                ((Unit)((Object)this)).setMoveTarget(targetPos);
                if (((LivingEntity)this).m_9236_().f_46443_) {
                    MiscUtil.addUnitCheckpoint((Unit)((Object)this), groundCentrePos, false);
                }
            }
        }
    }

    public static void resetBehaviours(AttackerUnit unit) {
        Goal attackBuildingGoal;
        unit.setUnitAttackTarget(null);
        unit.setAttackMoveTarget(null);
        Goal attackGoal = unit.getAttackGoal();
        if (attackGoal instanceof MeleeWindupAttackUnitGoal) {
            MeleeWindupAttackUnitGoal mwaug = (MeleeWindupAttackUnitGoal)attackGoal;
            mwaug.resetWindup();
        }
        if ((attackBuildingGoal = unit.getAttackBuildingGoal()) instanceof RangedAttackBuildingGoal) {
            RangedAttackBuildingGoal rabg = (RangedAttackBuildingGoal)attackBuildingGoal;
            rabg.m_8041_();
        } else if (attackBuildingGoal instanceof MeleeAttackBuildingGoal) {
            MeleeAttackBuildingGoal mabg = (MeleeAttackBuildingGoal)attackBuildingGoal;
            mabg.stopAttacking();
        }
    }

    public void setAttackMoveTarget(@Nullable BlockPos var1);

    private static boolean isAttackingBuilding(AttackerUnit attackerUnit) {
        boolean isAttackingBuilding = false;
        Goal attackBuildingGoal = attackerUnit.getAttackBuildingGoal();
        if (attackBuildingGoal instanceof RangedAttackBuildingGoal) {
            RangedAttackBuildingGoal rabg = (RangedAttackBuildingGoal)attackBuildingGoal;
            isAttackingBuilding = rabg.getBuildingTarget() != null;
        } else if (attackBuildingGoal instanceof MeleeAttackBuildingGoal) {
            MeleeAttackBuildingGoal mabg = (MeleeAttackBuildingGoal)attackBuildingGoal;
            isAttackingBuilding = mabg.getBuildingTarget() != null;
        }
        return isAttackingBuilding;
    }

    public static void tick(AttackerUnit attackerUnit) {
        RangedAttackerUnit rangedAttackerUnit;
        int revealDuration;
        Mob unitMob = (Mob)attackerUnit;
        Unit unit = (Unit)((Object)attackerUnit);
        if (!unitMob.m_9236_().f_46443_) {
            Goal goal = attackerUnit.getAttackGoal();
            if (goal instanceof AbstractMeleeAttackUnitGoal) {
                AbstractMeleeAttackUnitGoal meleeAttackUnitGoal = (AbstractMeleeAttackUnitGoal)goal;
                meleeAttackUnitGoal.tickAttackCooldown();
            } else {
                goal = attackerUnit.getAttackGoal();
                if (goal instanceof UnitRangedAttackGoal) {
                    UnitRangedAttackGoal rangedAttackGoal = (UnitRangedAttackGoal)goal;
                    rangedAttackGoal.tickAttackCooldown();
                } else {
                    goal = attackerUnit.getAttackGoal();
                    if (goal instanceof UnitBowAttackGoal) {
                        UnitBowAttackGoal rangedAttackGoal = (UnitBowAttackGoal)goal;
                        rangedAttackGoal.tickAttackCooldown();
                    }
                }
            }
            if (attackerUnit.getAttackBuildingGoal() != null && attackerUnit.canAttackBuildings()) {
                attackerUnit.getAttackBuildingGoal().m_8037_();
            }
        } else if (unit instanceof RangedAttackerUnit && (revealDuration = (rangedAttackerUnit = (RangedAttackerUnit)((Object)unit)).getFogRevealDuration()) > 0) {
            rangedAttackerUnit.setFogRevealDuration(revealDuration - 1);
        }
        if (!unitMob.m_9236_().f_46443_ && unitMob.f_19797_ % 4 == 0) {
            boolean isAttackingBuilding = AttackerUnit.isAttackingBuilding(attackerUnit);
            if (attackerUnit.getAttackMoveTarget() != null && !unit.hasLivingTarget() && !isAttackingBuilding) {
                attackerUnit.attackClosestEnemy((ServerLevel)unitMob.m_9236_());
                if (unit.getTargetGoal().getTarget() == null && unit.getMoveGoal().getMoveTarget() == null && !AttackerUnit.isAttackingBuilding(attackerUnit)) {
                    unit.setMoveTarget(attackerUnit.getAttackMoveTarget());
                }
            }
            if (unitMob.m_21225_() != null && attackerUnit.getWillRetaliate() && !isAttackingBuilding && unit.getTargetGoal().getTarget() == null && (unit.getMoveGoal().getMoveTarget() == null || unit.getHoldPosition()) && unit.getFollowTarget() == null) {
                Player player;
                Unit unitDS;
                Entity lastDSEntity = unitMob.m_21225_().m_7639_();
                boolean isMeleeAttackedByFlyingOrGarrisoned = false;
                if (lastDSEntity instanceof Unit && ((unitDS = (Unit)lastDSEntity).getMoveGoal() instanceof FlyingMoveToTargetGoal || GarrisonableBuilding.getGarrison(unitDS) != null || unitDS instanceof PhantomSummon || unitDS instanceof Vex) && attackerUnit.getAttackGoal() instanceof AbstractMeleeAttackUnitGoal) {
                    isMeleeAttackedByFlyingOrGarrisoned = true;
                }
                Relationship rs = UnitServerEvents.getUnitToEntityRelationship(unit, lastDSEntity);
                if (!(isMeleeAttackedByFlyingOrGarrisoned || !(lastDSEntity instanceof LivingEntity) || lastDSEntity instanceof Player && (player = (Player)lastDSEntity).m_7500_() || rs != Relationship.NEUTRAL && rs != Relationship.HOSTILE)) {
                    attackerUnit.setUnitAttackTarget((LivingEntity)lastDSEntity);
                }
            }
            if (unit.isIdle() && !isAttackingBuilding && attackerUnit.getAggressiveWhenIdle()) {
                attackerUnit.attackClosestEnemy((ServerLevel)unitMob.m_9236_());
            }
            if (!isAttackingBuilding && !((Unit)((Object)attackerUnit)).getTargetGoal().forced) {
                attackerUnit.retargetToClosestUnit((ServerLevel)unitMob.m_9236_());
            }
        }
    }

    default public void retargetToClosestUnit(ServerLevel level) {
        double distCurrentTarget;
        double distClosestTarget;
        float aggroRange = this.getAggroRange();
        GarrisonableBuilding garr = GarrisonableBuilding.getGarrison((Unit)((Object)this));
        if (garr != null) {
            aggroRange = garr.getAttackRange();
        }
        LivingEntity closestTarget = MiscUtil.findClosestAttackableEntity((Mob)this, aggroRange, level);
        LivingEntity currentTarget = ((Mob)this).m_5448_();
        if (closestTarget != null && currentTarget != null && (distClosestTarget = ((Mob)this).m_20238_(closestTarget.m_20182_())) < (distCurrentTarget = ((Mob)this).m_20238_(currentTarget.m_20182_()))) {
            ((Unit)((Object)this)).getMoveGoal().stopMoving();
            this.setUnitAttackTarget(closestTarget);
        }
    }

    default public void attackClosestEnemy(ServerLevel level) {
        Building closestBuilding;
        LivingEntity entity;
        float aggroRange = this.getAggroRange();
        GarrisonableBuilding garr = GarrisonableBuilding.getGarrison((Unit)((Object)this));
        if (garr != null) {
            aggroRange = garr.getAttackRange();
        }
        if ((entity = MiscUtil.findClosestAttackableEntity((Mob)this, aggroRange, level)) != null) {
            ((Unit)((Object)this)).getMoveGoal().stopMoving();
            this.setUnitAttackTarget(entity);
            return;
        }
        if (!(!this.canAttackBuildings() || this instanceof RavagerUnit && ((LivingEntity)this).m_20160_() || ((Unit)((Object)this)).getOwnerName().isEmpty() || (closestBuilding = MiscUtil.findClosestAttackableBuilding((Mob)this, aggroRange, level)) == null)) {
            ((Unit)((Object)this)).getMoveGoal().stopMoving();
            this.setAttackBuildingTarget(closestBuilding.originPos);
        }
    }

    public static double getWeaponDamageModifier(AttackerUnit attackerUnit) {
        ItemStack itemStack = ((LivingEntity)attackerUnit).m_6844_(EquipmentSlot.MAINHAND);
        if (!itemStack.m_41619_()) {
            for (AttributeModifier attr : itemStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                if (attr.m_22217_() != AttributeModifier.Operation.ADDITION) continue;
                return attr.m_22218_();
            }
        }
        return 0.0;
    }
}

