/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.interfaces;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public interface HeroUnit {
    public static final int MAX_HERO_LEVEL = 10;

    public float getHealthBonusPerLevel();

    public float getAttackBonusPerLevel();

    public float getBaseHealth();

    public float getBaseAttack();

    public int getSkillPoints();

    public void setSkillPoints(int var1);

    public boolean isRankUpMenuOpen();

    public void showRankUpMenu(boolean var1);

    public int getExperience();

    public void setExperience(int var1);

    default public int getChargesForSaveData() {
        return 0;
    }

    default public void setChargesFromSaveData(int charges) {
    }

    default public void setStatsForLevel() {
        AttributeInstance aiAttackDamage;
        AttributeInstance aiMaxHealth = ((LivingEntity)this).m_21051_(Attributes.f_22276_);
        if (aiMaxHealth != null) {
            aiMaxHealth.m_22100_((double)(this.getBaseHealth() + (float)(this.getHeroLevel() - 1) * this.getHealthBonusPerLevel()));
        }
        if ((aiAttackDamage = ((LivingEntity)this).m_21051_(Attributes.f_22281_)) != null) {
            aiAttackDamage.m_22100_((double)(this.getBaseAttack() + (float)(this.getHeroLevel() - 1) * this.getAttackBonusPerLevel()));
        }
    }

    default public void addExperience(int amount) {
        if (((LivingEntity)this).m_9236_().m_5776_()) {
            return;
        }
        int levelBefore = this.getHeroLevel();
        if (levelBefore >= 10) {
            return;
        }
        this.setExperience(this.getExperience() + amount);
        int levelDiff = this.getHeroLevel() - levelBefore;
        HeroClientboundPacket.setExperience(((LivingEntity)this).m_19879_(), this.getExperience());
        if (levelDiff > 0) {
            this.setSkillPoints(this.getSkillPoints() + levelDiff);
            HeroClientboundPacket.setSkillPoints(((LivingEntity)this).m_19879_(), this.getSkillPoints());
            SoundClientboundPacket.playSoundAtPos(SoundAction.LEVEL_UP, ((LivingEntity)this).m_20097_());
            this.setStatsForLevel();
            ((LivingEntity)this).m_5634_((float)levelDiff * this.getHealthBonusPerLevel());
        }
    }

    default public int getHeroLevel() {
        int level = 0;
        int expToNextLevel = 200;
        int exp = this.getExperience();
        while ((exp -= (expToNextLevel += 100)) > 0 && ++level < 10) {
        }
        return level;
    }

    default public int getExpOnCurrentLevel() {
        if (this.getHeroLevel() >= 10) {
            return 0;
        }
        int expToNextLevel = 200;
        int expCount = 0;
        int exp = this.getExperience();
        while (expCount < exp) {
            if (expCount + expToNextLevel > exp) {
                return exp - expCount;
            }
            expCount += expToNextLevel;
            expToNextLevel += 100;
        }
        return 0;
    }

    default public int getExpToNextlevel() {
        if (this.getHeroLevel() >= 10) {
            return 0;
        }
        return (this.getHeroLevel() + 1) * 100;
    }

    default public List<HeroAbility> getHeroAbilities() {
        HeroUnit heroUnit = this;
        if (heroUnit instanceof Unit) {
            Unit unit = (Unit)((Object)heroUnit);
            return unit.getAbilities().stream().filter(a -> a instanceof HeroAbility).map(a -> (HeroAbility)a).toList();
        }
        return List.of();
    }
}

